/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.httpd;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.httpd.URLMapperHandler;

public class MultiURLMapperHandler
implements HttpServer.Handler {
    private final HttpServer server_;
    private final String basePath_;
    private final URL baseUrl_;
    private final Map urlMap_;
    private int resourceCount_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MultiURLMapperHandler(HttpServer server, String basePath) throws MalformedURLException {
        this.server_ = server;
        if (!basePath.startsWith("/")) {
            basePath = "/" + basePath;
        }
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        this.basePath_ = basePath;
        this.baseUrl_ = new URL(server.getBaseUrl(), basePath);
        this.urlMap_ = Collections.synchronizedMap(new HashMap());
    }

    public URL getBaseUrl() {
        return this.baseUrl_;
    }

    public synchronized URL addLocalUrl(URL localUrl) {
        URL mappedUrl;
        String relPath;
        block7: {
            String path = localUrl.getPath();
            int lastSlash = path.lastIndexOf("/");
            String name = lastSlash >= 0 && lastSlash < path.length() - 1 ? path.substring(lastSlash + 1) : "f";
            try {
                relPath = ++this.resourceCount_ + "/" + name;
                mappedUrl = new URL(this.baseUrl_, relPath);
            }
            catch (MalformedURLException e) {
                try {
                    relPath = this.resourceCount_ + "/f";
                    mappedUrl = new URL(this.baseUrl_, relPath);
                }
                catch (MalformedURLException e2) {
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError())).initCause(e2));
                }
            }
            String frag = localUrl.getRef();
            if (frag != null) {
                try {
                    mappedUrl = new URL(mappedUrl.toString() + "#" + frag);
                }
                catch (MalformedURLException e) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError();
                }
            }
        }
        this.urlMap_.put(relPath, localUrl);
        return mappedUrl;
    }

    public synchronized void removeServerUrl(URL url) {
        String sbase;
        String surl = url.toString();
        if (!surl.startsWith(sbase = this.baseUrl_.toString())) {
            return;
        }
        String relPath = surl.substring(sbase.length());
        this.urlMap_.remove(relPath);
    }

    public HttpServer.Response serveRequest(HttpServer.Request request) {
        String path = request.getUrl();
        if (!path.startsWith(this.basePath_)) {
            return null;
        }
        String relPath = path.substring(this.basePath_.length());
        if (!this.urlMap_.containsKey(relPath)) {
            return HttpServer.createErrorResponse(404, "Not found");
        }
        URL srcUrl = (URL)this.urlMap_.get(relPath);
        return URLMapperHandler.mapUrlResponse(request.getMethod(), srcUrl);
    }

    static {
        $assertionsDisabled = !MultiURLMapperHandler.class.desiredAssertionStatus();
    }
}

