/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.ErrInfo;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.DefaultClientProfile;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.ResultHandler;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.gui.GuiHubConnector;
import org.astrogrid.samp.gui.UniformCallActionManager;
import org.astrogrid.samp.httpd.UtilServer;
import org.astrogrid.samp.util.ResourceType;

public class SampLoad
extends JDialog {
    private final GuiHubConnector connector_;
    private final URL url_;
    private final String mtype_;
    private final JComboBox targetSelector_;
    private final JLabel statusField_;
    private final Action sendAct_;
    private Map responseMap_;
    private static final URL ICON_URL = SampLoad.class.getResource("/org/astrogrid/samp/images/sampload.png");
    private static final Logger logger_ = Logger.getLogger(SampLoad.class.getName());

    public SampLoad(GuiHubConnector connector, final ResourceType rtype, final URL url, String location) {
        super((Dialog)null, "SAMP Loader", true);
        DefaultComboBoxModel<String> targetModel;
        this.connector_ = connector;
        this.url_ = url;
        this.mtype_ = rtype == null ? null : rtype.getMType();
        String tname = rtype == null ? null : rtype.getName();
        UniformCallActionManager callManager = new UniformCallActionManager(this, connector, this.mtype_, tname){

            protected Map createMessage() {
                return rtype.createMessage(url);
            }

            protected ResultHandler createResultHandler(HubConnection conn, Message msg, Client[] recipients) {
                final HashSet<Client> recips = new HashSet<Client>(Arrays.asList(recipients));
                return new ResultHandler(){

                    public void result(Client responder, Response response) {
                        SampLoad.this.responseMap_.put(responder, response);
                        if (response.isOK()) {
                            recips.remove(responder);
                        }
                        SampLoad.this.updateStatus();
                    }

                    public void done() {
                        boolean success;
                        boolean bl = success = recips.size() == 0;
                        if (success) {
                            Timer timer = new Timer(1000, new ActionListener(){

                                public void actionPerformed(ActionEvent evt) {
                                    SampLoad.this.closeDialog();
                                }
                            });
                            timer.setRepeats(false);
                            timer.start();
                        }
                    }
                };
            }
        };
        if (rtype == null) {
            targetModel = new DefaultComboBoxModel<String>(new String[]{"All Clients"});
            this.sendAct_ = new AbstractAction("Send to selected target"){

                public void actionPerformed(ActionEvent evt) {
                }
            };
        } else {
            targetModel = callManager.createTargetSelector();
            this.sendAct_ = callManager.createTargetAction(targetModel);
        }
        this.targetSelector_ = new JComboBox(targetModel){

            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }
        };
        AbstractAction cancelAct = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent evt) {
                SampLoad.this.closeDialog();
            }
        };
        this.setDefaultCloseOperation(2);
        this.connector_.addConnectionListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SampLoad.this.updateStatus();
            }
        });
        targetModel.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent evt) {
                SampLoad.this.updateSelector();
            }

            public void intervalAdded(ListDataEvent evt) {
                SampLoad.this.updateSelector();
            }

            public void intervalRemoved(ListDataEvent evt) {
                SampLoad.this.updateSelector();
            }
        });
        this.getContentPane().addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                this.checkConnection();
            }

            public void mouseExited(MouseEvent evt) {
                this.checkConnection();
            }

            public void mousePressed(MouseEvent evt) {
                this.checkConnection();
            }

            private void checkConnection() {
                try {
                    SampLoad.this.connector_.getConnection();
                }
                catch (SampException sampException) {
                    // empty catch block
                }
            }
        });
        JButton sendButton = new JButton(this.sendAct_);
        sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SampLoad.this.responseMap_ = new LinkedHashMap();
                SampLoad.this.updateStatus();
            }
        });
        this.statusField_ = new JLabel();
        JPanel displayPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        SampLoad.addLine(displayPanel, gbc, "Location", SampLoad.createField(location), true);
        SampLoad.addLine(displayPanel, gbc, "MType", SampLoad.createField(this.mtype_), true);
        SampLoad.addLine(displayPanel, gbc, "Target", this.targetSelector_, false);
        SampLoad.addLine(displayPanel, gbc, "Status", this.statusField_, true);
        Box buttLine = Box.createHorizontalBox();
        buttLine.add(Box.createHorizontalGlue());
        buttLine.add(sendButton);
        buttLine.add(Box.createHorizontalStrut(10));
        buttLine.add(new JButton(cancelAct));
        buttLine.add(Box.createHorizontalGlue());
        buttLine.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Box qbox = Box.createVerticalBox();
        Icon qicon = ICON_URL != null ? new ImageIcon(ICON_URL) : UIManager.getIcon("OptionPane.questionIcon");
        qbox.add(new JLabel(qicon));
        qbox.add(Box.createVerticalGlue());
        qbox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Component hstrut = Box.createHorizontalStrut(450);
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)displayPanel, "Center");
        contentPane.add((Component)buttLine, "South");
        contentPane.add((Component)qbox, "West");
        contentPane.add(hstrut, "North");
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.updateSelector();
    }

    private void updateStatus() {
        boolean canSend;
        String status;
        if (this.url_ == null) {
            status = "No such file";
            canSend = false;
        } else if (this.mtype_ == null) {
            status = "Unknown resource type (not " + SampLoad.commaJoin(ResourceType.getKnownResourceTypes()) + ")";
            canSend = false;
        } else if (!this.connector_.isConnected()) {
            status = "No hub";
            canSend = false;
        } else if (this.targetSelector_.getItemCount() <= 1) {
            status = "No clients for " + this.mtype_;
            canSend = false;
        } else if (this.responseMap_ == null) {
            status = "Ready";
            canSend = true;
        } else if (this.responseMap_.size() == 0) {
            status = "sending ...";
            canSend = false;
        } else {
            StringBuffer sbuf = new StringBuffer();
            Iterator it = this.responseMap_.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (sbuf.length() > 0) {
                    sbuf.append("; ");
                }
                Client client = (Client)entry.getKey();
                Response response = (Response)entry.getValue();
                sbuf.append(client + ": ");
                if (response.isOK()) {
                    sbuf.append("OK");
                    continue;
                }
                ErrInfo err = response.getErrInfo();
                if (err == null) {
                    sbuf.append("ERROR");
                    continue;
                }
                sbuf.append(response.getStatus()).append(" ").append(err.getErrortxt());
            }
            status = sbuf.toString();
            canSend = false;
        }
        this.statusField_.setText(status);
        this.sendAct_.setEnabled(canSend);
    }

    private void updateSelector() {
        if (this.targetSelector_.getItemCount() == 2) {
            this.targetSelector_.setSelectedIndex(1);
        } else if (this.targetSelector_.getSelectedIndex() < 0) {
            this.targetSelector_.setSelectedIndex(0);
        }
        this.updateStatus();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private static void addLine(JComponent panel, GridBagConstraints gbc, String labelTxt, JComponent comp, boolean hfill) {
        GridBagLayout layer = (GridBagLayout)panel.getLayout();
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(2, 5, 5, 2);
        JLabel label = new JLabel(labelTxt + ": ");
        layer.setConstraints(label, gbc);
        panel.add(label);
        GridBagConstraints gbc1 = (GridBagConstraints)gbc.clone();
        gbc1.gridx = 1;
        gbc1.anchor = 17;
        gbc1.weightx = 1.0;
        gbc1.fill = hfill ? 2 : 0;
        gbc1.gridwidth = 0;
        layer.setConstraints(comp, gbc1);
        panel.add(comp);
    }

    private static JTextField createField(String txt) {
        JTextField field = new JTextField();
        field.setEditable(false);
        field.setText(txt);
        field.setCaretPosition(0);
        return field;
    }

    private static String commaJoin(Object[] items) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            if (sbuf.length() > 0) {
                sbuf.append(", ");
            }
            sbuf.append(String.valueOf(items[i]));
        }
        return sbuf.toString();
    }

    private static final URL getUrl(String location) {
        File f = new File(location);
        if (f.exists()) {
            return SampUtils.fileToUrl(f);
        }
        try {
            return new URL(location);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static int runMain(String[] args) throws IOException {
        ResourceType[] resourceTypes = ResourceType.getKnownResourceTypes();
        StringBuffer rtbuf = new StringBuffer();
        for (int ir = 0; ir < resourceTypes.length; ++ir) {
            if (rtbuf.length() > 0) {
                rtbuf.append("|");
            }
            rtbuf.append(resourceTypes[ir].getName().toLowerCase());
        }
        String usage = "\n   Usage:" + ("\n      " + SampLoad.class.getName()) + "\n         " + " [-help]" + " [-/+verbose]" + "\n         " + (" [-rtype " + rtbuf + "]") + " <file-or-url>" + "\n";
        ResourceType rtype = null;
        String location = null;
        int verbAdjust = 0;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.equals("-rtype") && rtype == null && it.hasNext()) {
                it.remove();
                String rtName = (String)it.next();
                it.remove();
                for (int ir = 0; ir < resourceTypes.length; ++ir) {
                    ResourceType rt = resourceTypes[ir];
                    if (!rtName.equalsIgnoreCase(rt.getName())) continue;
                    rtype = rt;
                }
                if (rtype != null) continue;
                System.err.println(usage);
                return 1;
            }
            if (arg.startsWith("-verb")) {
                it.remove();
                --verbAdjust;
                continue;
            }
            if (arg.startsWith("+verb")) {
                it.remove();
                ++verbAdjust;
                continue;
            }
            if (arg.equals("-help")) {
                it.remove();
                System.out.println(usage);
                return 0;
            }
            if (arg.startsWith("-") || arg.startsWith("+")) {
                System.err.println(usage);
                return 1;
            }
            if (location == null) {
                it.remove();
                location = arg;
                continue;
            }
            System.err.println(usage);
            return 1;
        }
        if (location == null) {
            System.err.println(usage);
            return 1;
        }
        int logLevel = Level.WARNING.intValue() + 100 * verbAdjust;
        Logger.getLogger("org.astrogrid.samp").setLevel(Level.parse(Integer.toString(logLevel)));
        if (location == null) {
            System.err.println(usage);
            return 1;
        }
        URL url = SampLoad.getUrl(location);
        if (url == null) {
            logger_.warning("Bad location: " + location);
        }
        if (url != null) {
            if (rtype == null) {
                rtype = ResourceType.readHeadResourceType(url);
            }
            if (rtype == null) {
                rtype = ResourceType.readContentResourceType(url);
            }
            if (rtype == null) {
                logger_.warning("Unknown resource type: " + url);
            }
        }
        Metadata meta = new Metadata();
        meta.setName("SampLoad");
        try {
            meta.setIconUrl(UtilServer.getInstance().exportResource(ICON_URL).toString());
        }
        catch (Exception e) {
            logger_.log(Level.WARNING, "Can't export application icon", e);
        }
        meta.setDescriptionText("Browser helper application to forward downloaded files" + (" (" + rtype + ") ") + "to SAMP Hub");
        meta.put("author.name", "Mark Taylor");
        ClientProfile profile = DefaultClientProfile.getProfile();
        GuiHubConnector connector = new GuiHubConnector(profile);
        connector.declareMetadata(meta);
        connector.declareSubscriptions(connector.computeSubscriptions());
        connector.setActive(rtype != null);
        SampLoad dialog = new SampLoad(connector, rtype, url, location);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        connector.setActive(false);
        return 0;
    }

    public static void main(String[] args) throws IOException {
        int status = SampLoad.runMain(args);
        System.exit(status);
    }
}

