/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.web.AuthResourceBundle;
import org.astrogrid.samp.web.ClientAuthorizer;
import org.astrogrid.samp.web.CredentialPresenter;

public class HubSwingClientAuthorizer
implements ClientAuthorizer {
    private final Component parent_;
    private final CredentialPresenter presenter_;
    private static final int MAX_POPUP_WIDTH = 500;
    private static final Logger logger_ = Logger.getLogger(HubSwingClientAuthorizer.class.getName());

    public HubSwingClientAuthorizer(Component parent, CredentialPresenter presenter) {
        this.parent_ = parent;
        this.presenter_ = presenter;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException("Client authorization dialogues impossible - no graphics");
        }
    }

    public void authorize(HttpServer.Request request, Map securityMap) throws SampException {
        AuthResourceBundle.Content authContent = AuthResourceBundle.getAuthContent(ResourceBundle.getBundle(AuthResourceBundle.class.getName()));
        Object[] qmsg = this.getMessageLines(request, securityMap, authContent);
        String noOpt = authContent.noWord();
        String yesOpt = authContent.yesWord();
        JOptionPane jop = new JOptionPane(qmsg, 2, 0, null, new String[]{noOpt, yesOpt}, noOpt);
        JDialog dialog = jop.createDialog(this.parent_, authContent.windowTitle());
        HubSwingClientAuthorizer.attemptSetAlwaysOnTop(dialog, true);
        dialog.setModal(true);
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
        dialog.dispose();
        if (jop.getValue() != yesOpt) {
            throw new SampException("User denied authorization");
        }
    }

    private Object[] getMessageLines(HttpServer.Request request, Map securityMap, AuthResourceBundle.Content authContent) throws SampException {
        Map headerMap = request.getHeaderMap();
        CredentialPresenter.Presentation presentation = this.presenter_.createPresentation(request, securityMap, authContent);
        ArrayList<Object> lineList = new ArrayList<Object>();
        lineList.addAll(HubSwingClientAuthorizer.toLineList(authContent.appIntroductionLines()));
        lineList.add("\n");
        lineList.add(this.createLabelledFields(presentation.getAuthEntries(), authContent.undeclaredWord()));
        lineList.add("\n");
        Object[] lines = presentation.getAuthLines();
        lineList.addAll(Arrays.asList(lines));
        if (lines.length > 0) {
            lineList.add("\n");
        }
        lineList.addAll(HubSwingClientAuthorizer.toLineList(authContent.privilegeWarningLines()));
        lineList.add("\n");
        lineList.addAll(HubSwingClientAuthorizer.toLineList(authContent.adviceLines()));
        lineList.add("\n");
        lineList.add(authContent.questionLine());
        return lineList.toArray();
    }

    private JComponent createLabelledFields(Map infoMap, String undeclaredWord) {
        GridBagLayout layer = new GridBagLayout();
        JPanel box = new JPanel(layer){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return new Dimension(Math.min(size.width, 500), size.height);
            }
        };
        GridBagConstraints keyCons = new GridBagConstraints();
        GridBagConstraints valCons = new GridBagConstraints();
        keyCons.gridy = 0;
        valCons.gridy = 0;
        keyCons.gridx = 0;
        valCons.gridx = 1;
        keyCons.anchor = 17;
        valCons.anchor = 17;
        keyCons.fill = 0;
        valCons.fill = 2;
        keyCons.weighty = 1.0;
        valCons.weighty = 1.0;
        keyCons.weightx = 0.0;
        valCons.weightx = 1.0;
        valCons.insets = new Insets(1, 1, 1, 1);
        Box stack = Box.createVerticalBox();
        Iterator it = infoMap.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)infoMap.get(key);
            String valtxt = value == null ? undeclaredWord : value;
            JLabel keyComp = new JLabel(key + ": ");
            JTextField valueField = new JTextField(valtxt);
            valueField.setEditable(false);
            layer.setConstraints(keyComp, keyCons);
            layer.setConstraints(valueField, valCons);
            box.add(keyComp);
            box.add(valueField);
            ++keyCons.gridy;
            ++valCons.gridy;
        }
        box.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        return box;
    }

    private static String[] toLines(String linesTxt) {
        return linesTxt.split("\\n");
    }

    private static List toLineList(String linesTxt) {
        return Arrays.asList(HubSwingClientAuthorizer.toLines(linesTxt));
    }

    private static void attemptSetAlwaysOnTop(Window win, boolean isOnTop) {
        try {
            Window.class.getMethod("setAlwaysOnTop", Boolean.TYPE).invoke((Object)win, isOnTop);
        }
        catch (Throwable e) {
            logger_.info("Can't set window on top, not J2SE5");
        }
    }
}

