/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.util.Map;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.hub.MessageRestriction;

public class ListMessageRestriction
implements MessageRestriction {
    private final boolean allow_;
    private final boolean useSubsInfo_;
    private final Subscriptions subs_;
    public static String[] DEFAULT_SAFE_MTYPES = new String[]{"samp.app.*", "samp.msg.progress", "table.*", "image.*", "coord.*", "spectrum.*", "bibcode.*", "voresource.*", "coverage.*"};
    public static final String SAFE_MTYPE_PROP = "jsamp.mtypes.safe";
    public static final MessageRestriction DEFAULT = new ListMessageRestriction(true, ListMessageRestriction.getSafeMTypes(), true);
    public static final MessageRestriction ALLOW_ALL = new ListMessageRestriction(false, new String[0], true){

        public String toString() {
            return "ALLOW_ALL";
        }
    };
    public static final MessageRestriction DENY_ALL = new ListMessageRestriction(true, new String[0], true){

        public String toString() {
            return "DENY_ALL";
        }
    };

    public ListMessageRestriction(boolean allow, String[] mtypes, boolean useSubsInfo) {
        this.allow_ = allow;
        this.useSubsInfo_ = useSubsInfo;
        this.subs_ = new Subscriptions();
        for (int im = 0; im < mtypes.length; ++im) {
            this.subs_.addMType(mtypes[im]);
        }
    }

    public boolean permitSend(String mtype, Map subsInfo) {
        if (this.useSubsInfo_) {
            Object markedHarmless = subsInfo.get("samp.mostly-harmless");
            if (markedHarmless == null) {
                markedHarmless = subsInfo.get("x-samp.mostly-harmless");
            }
            if ("0".equals(markedHarmless)) {
                return false;
            }
            if ("1".equals(markedHarmless)) {
                return true;
            }
        }
        boolean knownSafe = !this.allow_ ^ this.subs_.isSubscribed(mtype);
        return knownSafe;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer().append(this.allow_ ? "Allow" : "Deny").append(' ').append(this.subs_.keySet());
        if (this.useSubsInfo_) {
            sbuf.append("; ").append("honour (x-)samp.mostly-harmless");
        }
        return sbuf.toString();
    }

    public static String[] getSafeMTypes() {
        String safeMtypes = System.getProperty(SAFE_MTYPE_PROP);
        if (safeMtypes == null) {
            return DEFAULT_SAFE_MTYPES;
        }
        return safeMtypes.split(",");
    }
}

