/*
 * Decompiled with CFR 0.152.
 */
package gaiasky;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.TextUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.Link;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnTextArea;
import gaiasky.util.scene2d.OwnTextButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ErrorDialog
implements ApplicationListener {
    private final Exception exception;
    private Stage ui;
    private ScreenViewport vp;
    private SpriteBatch sb;
    private Skin skin;

    public ErrorDialog(Exception exception) {
        this.exception = exception;
    }

    public void create() {
        int height = Gdx.graphics.getHeight();
        float unitsPerPixel = 1.0f / ((float)height / 1000.0f) * Settings.settings.program.ui.scale;
        ScreenViewport vp = new ScreenViewport();
        vp.setUnitsPerPixel(unitsPerPixel);
        this.vp = vp;
        this.sb = this.initializeSpriteBatch();
        this.ui = new Stage((Viewport)this.vp, (Batch)this.sb);
        FileHandle fh = Gdx.files.internal("skins/" + Settings.settings.program.ui.theme + "/" + Settings.settings.program.ui.theme + ".json");
        if (!fh.exists()) {
            Settings.settings.program.ui.theme = "dark-green";
            fh = Gdx.files.internal("skins/" + Settings.settings.program.ui.theme + "/" + Settings.settings.program.ui.theme + ".json");
        }
        this.skin = new Skin(fh);
        ObjectMap fonts = this.skin.getAll(BitmapFont.class);
        for (String key : fonts.keys()) {
            ((BitmapFont)fonts.get((Object)key)).getRegion().getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        }
        this.rebuildUI();
        Gdx.input.setInputProcessor((InputProcessor)this.ui);
    }

    private void rebuildUI() {
        Table t = new Table(this.skin);
        t.setFillParent(true);
        this.ui.clear();
        this.ui.addActor((Actor)t);
        OwnLabel title = new OwnLabel((CharSequence)I18n.msg("error.crash.title"), this.skin, "header-large");
        String msg = this.exception != null ? (this.exception.getLocalizedMessage() != null ? this.exception.getLocalizedMessage() : (this.exception.getMessage() != null ? this.exception.getMessage() : this.exception.getClass().getSimpleName())) : "-";
        OwnLabel subtitle = new OwnLabel((CharSequence)I18n.msg("notif.error", TextUtils.breakCharacters(msg, 40)), this.skin, "default");
        OwnLabel urlLabel = new OwnLabel((CharSequence)I18n.msg("error.crash.exception.1"), this.skin, "header-s");
        Link url = new Link((CharSequence)"https://codeberg.org/gaiasky/gaiasky/issues", this.skin, "https://codeberg.org/gaiasky/gaiasky/issues");
        OwnLabel applicationMessageLabel = new OwnLabel((CharSequence)I18n.msg("error.crash.applicationmessage"), this.skin, "header-s");
        OwnLabel crashLocLabel = new OwnLabel((CharSequence)I18n.msg("error.crash.exception.2"), this.skin);
        OwnLabel crashLoc = new OwnLabel((CharSequence)TextUtils.capString(SysUtils.getCrashReportsDir().toString(), 50), this.skin, "hud-subheader");
        crashLoc.addListener((EventListener)new OwnTextTooltip(SysUtils.getCrashReportsDir().toString(), this.skin));
        Image img = new Image(new Texture(Gdx.files.internal("img/crash.png")));
        OwnTextButton b = new OwnTextButton(I18n.msg("gui.close"), this.skin, "default");
        b.setWidth(400.0f);
        b.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                Gdx.app.postRunnable(() -> {
                    this.dispose();
                    Gdx.app.exit();
                    System.exit(1);
                });
            }
            return true;
        });
        b.pad(10.0f);
        Table left = new Table(this.skin);
        left.add((Actor)title).left().padBottom(10.0f).row();
        left.add((Actor)subtitle).left().padBottom(30.0f).row();
        left.add((Actor)urlLabel).left().padBottom(10.0f).row();
        left.add((Actor)url).left().padBottom(30.0f).row();
        left.add((Actor)applicationMessageLabel).left().padBottom(10.0f).row();
        left.add((Actor)crashLocLabel).left().padBottom(10.0f).row();
        left.add((Actor)crashLoc).left().padBottom(30.0f).row();
        t.add((Actor)left).left();
        t.add((Actor)img).left().row();
        if (this.exception != null && this.exception.getStackTrace() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.exception.printStackTrace(pw);
            String sStackTrace = sw.toString();
            long lines = TextUtils.countLines(sStackTrace);
            OwnTextArea stackTraceTextArea = new OwnTextArea(sStackTrace, this.skin, "default");
            stackTraceTextArea.setPrefRows(15.0f);
            stackTraceTextArea.setWidth(800.0f);
            stackTraceTextArea.setHeight((float)lines * 55.0f);
            OwnScrollPane stackTraceScroll = new OwnScrollPane((Actor)stackTraceTextArea, this.skin, "minimalist");
            stackTraceScroll.setWidth(820.0f);
            stackTraceScroll.setHeight(400.0f);
            stackTraceScroll.setFadeScrollBars(false);
            OwnLabel stackTraceLabel = new OwnLabel((CharSequence)I18n.msg("error.crash.stacktrace"), this.skin, "header-s");
            t.add((Actor)stackTraceLabel).colspan(2).left().padBottom(10.0f).row();
            t.add((Actor)stackTraceScroll).colspan(2).left().padBottom(10.0f).row();
            OwnTextButton copy = new OwnTextButton(I18n.msg("error.crash.copy"), this.skin);
            copy.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    Gdx.app.getClipboard().setContents(sStackTrace);
                }
                return false;
            });
            t.add((Actor)copy).colspan(2).left().padBottom(80.0f).row();
        }
        t.add((Actor)b).colspan(2).center().row();
    }

    private SpriteBatch initializeSpriteBatch() {
        ShaderProgram spriteShader = new ShaderProgram(Gdx.files.internal("shader/2d/spritebatch.vertex.glsl"), Gdx.files.internal("shader/2d/spritebatch.fragment.glsl"));
        return new SpriteBatch(100, spriteShader);
    }

    public void resize(int width, int height) {
        float unitsPerPixel = 1.0f / ((float)height / 1000.0f) * Settings.settings.program.ui.scale;
        this.vp.setUnitsPerPixel(unitsPerPixel);
        this.vp.update(width, height, true);
        this.sb.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, (float)width, (float)height);
    }

    public void render() {
        Gdx.gl.glClear(16640);
        this.ui.act(Gdx.graphics.getDeltaTime());
        this.ui.draw();
    }

    public void pause() {
    }

    public void resume() {
    }

    public void dispose() {
        this.ui.dispose();
    }
}

