/*
 * Decompiled with CFR 0.152.
 */
package gaiasky;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Graphics;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Window;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3WindowConfiguration;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureArray;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.ui.TooltipManager;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BaseJsonReader;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.TimeUtils;
import com.badlogic.gdx.utils.Timer;
import com.badlogic.gdx.utils.UBJsonReader;
import gaiasky.GaiaSkyView;
import gaiasky.data.AssetBean;
import gaiasky.data.OctreeLoader;
import gaiasky.data.api.OrientationServer;
import gaiasky.data.util.OrbitDataLoader;
import gaiasky.data.util.OrientationServerLoader;
import gaiasky.data.util.PointCloudData;
import gaiasky.data.util.SceneLoader;
import gaiasky.desktop.GaiaSkyDesktop;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.api.IGui;
import gaiasky.gui.bookmarks.BookmarksManager;
import gaiasky.gui.main.ConsoleLogger;
import gaiasky.gui.main.DebugGui;
import gaiasky.gui.main.FullGui;
import gaiasky.gui.main.GamepadGui;
import gaiasky.gui.main.GuiRegistry;
import gaiasky.gui.main.KeyBindings;
import gaiasky.gui.main.KeyboardInputController;
import gaiasky.gui.main.LoadingGui;
import gaiasky.gui.main.ModePopupInfo;
import gaiasky.gui.main.SpacecraftGui;
import gaiasky.gui.main.StereoGui;
import gaiasky.gui.main.TimeGui;
import gaiasky.gui.main.WelcomeGui;
import gaiasky.gui.vr.MainVRGui;
import gaiasky.gui.vr.StandaloneVRGui;
import gaiasky.gui.vr.WelcomeGuiVR;
import gaiasky.render.ComponentTypes;
import gaiasky.render.api.IPostProcessor;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.camera.NaturalCamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.scene.view.FocusView;
import gaiasky.script.ConsoleManager;
import gaiasky.script.IScriptingInterface;
import gaiasky.script.ScriptingServer;
import gaiasky.util.CatalogInfo;
import gaiasky.util.CatalogManager;
import gaiasky.util.Constants;
import gaiasky.util.CrashReporter;
import gaiasky.util.GaiaSkyAssets;
import gaiasky.util.GaiaSkyLoader;
import gaiasky.util.GlobalResources;
import gaiasky.util.LocationLogManager;
import gaiasky.util.Logger;
import gaiasky.util.MasterManager;
import gaiasky.util.MemInfo;
import gaiasky.util.ModelCache;
import gaiasky.util.Settings;
import gaiasky.util.SettingsManager;
import gaiasky.util.SlaveManager;
import gaiasky.util.SysUtils;
import gaiasky.util.TextUtils;
import gaiasky.util.VMemInfo;
import gaiasky.util.camera.rec.Camcorder;
import gaiasky.util.coord.vsop87.VSOP87Binary;
import gaiasky.util.coord.vsop87.VSOP87Loader;
import gaiasky.util.ds.GaiaSkyExecutorService;
import gaiasky.util.gdx.TextureArrayLoader;
import gaiasky.util.gdx.g2d.BitmapFont;
import gaiasky.util.gdx.loader.BitmapFontLoader;
import gaiasky.util.gdx.loader.G3dModelLoader;
import gaiasky.util.gdx.loader.GLBWrapperLoader;
import gaiasky.util.gdx.loader.GLTFWrapperLoader;
import gaiasky.util.gdx.loader.OwnObjLoader;
import gaiasky.util.gdx.loader.OwnPixmapLoader;
import gaiasky.util.gdx.loader.OwnTextureLoader;
import gaiasky.util.gdx.loader.PFMData;
import gaiasky.util.gdx.loader.PFMDataLoader;
import gaiasky.util.gdx.loader.PFMTextureLoader;
import gaiasky.util.gdx.loader.is.GzipInputStreamProvider;
import gaiasky.util.gdx.loader.is.RegularInputStreamProvider;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.loader.AtmosphereShaderProviderLoader;
import gaiasky.util.gdx.shader.loader.GroundShaderProviderLoader;
import gaiasky.util.gdx.shader.loader.RelativisticShaderProviderLoader;
import gaiasky.util.gdx.shader.loader.TessellationShaderProviderLoader;
import gaiasky.util.gdx.shader.provider.AtmosphereShaderProvider;
import gaiasky.util.gdx.shader.provider.GroundShaderProvider;
import gaiasky.util.gdx.shader.provider.RelativisticShaderProvider;
import gaiasky.util.gdx.shader.provider.ShaderProgramProvider;
import gaiasky.util.gdx.shader.provider.TessellationShaderProvider;
import gaiasky.util.gravwaves.RelativisticEffectsManager;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.screenshot.ScreenshotsManager;
import gaiasky.util.time.GlobalClock;
import gaiasky.util.time.ITimeFrameProvider;
import gaiasky.util.time.RealTimeClock;
import gaiasky.util.tree.OctreeNode;
import gaiasky.vr.openxr.XrDriver;
import gaiasky.vr.openxr.XrLoadStatus;
import gaiasky.vr.openxr.input.XrControllerDevice;
import gaiasky.vr.openxr.input.XrInputListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jafama.FastMath;
import org.lwjgl.opengl.GL30;

public final class GaiaSky
implements ApplicationListener,
IObserver {
    private static final Logger.Log logger = Logger.getLogger(GaiaSky.class);
    public static GaiaSky instance;
    public final Object frameMonitor = new Object();
    private final String sceneName = "SceneData";
    private final GaiaSkyDesktop.CLIArgs cliArgs;
    private final Array<Runnable> parkedUpdateRunnables = new Array(10);
    private final Map<String, Runnable> parkedUpdateRunnablesMap = Collections.synchronizedMap(new HashMap());
    private final Array<Runnable> parkedCameraRunnables = new Array(10);
    private final Map<String, Runnable> parkedCameraRunnablesMap = Collections.synchronizedMap(new HashMap());
    private final AtomicBoolean crashed = new AtomicBoolean(false);
    private final AtomicBoolean running = new AtomicBoolean(true);
    public Lwjgl3Window window;
    public Graphics graphics;
    public XrDriver xrDriver;
    public AssetManager assetManager;
    public GaiaSkyAssets gaiaSkyAssets;
    public CameraManager cameraManager;
    public Scene scene;
    public SceneRenderer sceneRenderer;
    public long frames;
    public InputMultiplexer inputMultiplexer;
    public int maxTextureSize;
    public int maxVertexAttributes;
    public IGui welcomeGui;
    public IGui loadingGui;
    public IGui mainGui;
    public IGui spacecraftGui;
    public IGui stereoGui;
    public IGui debugGui;
    public IGui crashGui;
    public IGui gamepadGui;
    public IGui mainVRGui;
    public IGui timeGui;
    public StandaloneVRGui<?> welcomeGuiVR;
    public StandaloneVRGui<?> loadingGuiVR;
    public ITimeFrameProvider time;
    public boolean windowCreated = false;
    public boolean saveState = true;
    public GaiaSkyView gaiaSkyView = null;
    private Runnable updateProcess;
    private Runnable updateRenderProcess;
    private long startTime;
    private long startTimeScene;
    private double t;
    private GuiRegistry guiRegistry;
    private int dynamicResolutionLevel = 0;
    private long lastDynamicResolutionChange = 0L;
    private float fps;
    private float unitsPerPixel = 1.0f;
    private ConsoleLogger consoleLogger;
    private List<IGui> guis;
    private SpriteBatch renderBatch;
    private boolean initialized = false;
    private GlobalResources globalResources;
    private GaiaSkyExecutorService executorService;
    private long startNanos = System.nanoTime();
    private long lastResizeTime = Long.MAX_VALUE;
    private int resizeWidth;
    private int resizeHeight;
    private final Runnable runnableInitialGui = () -> {
        if (Settings.settings.runtime.openXr) {
            this.renderGui(this.welcomeGuiVR);
        }
        this.renderGui(this.welcomeGui);
    };
    private final Runnable mainUpdaterRenderer = () -> {
        Settings settings = Settings.settings;
        this.assetManager.update();
        if (!settings.runtime.updatePause) {
            Object object = this.frameMonitor;
            synchronized (object) {
                this.frameMonitor.notify();
            }
            if (settings.runtime.openXr) {
                this.xrDriver.pollEvents();
            }
            this.update(this.graphics.getDeltaTime());
            EventManager.publish(Event.RENDER_FRAME, this, new Object[0]);
            if (settings.graphics.screenOutput) {
                int tw = this.graphics.getWidth();
                int th = this.graphics.getHeight();
                if (tw == 0 || th == 0) {
                    tw = settings.graphics.resolution[0];
                    th = settings.graphics.resolution[1];
                }
                int w = settings.runtime.openXr ? settings.graphics.backBufferResolution[0] : (int)((double)tw * settings.graphics.backBufferScale);
                int h = settings.runtime.openXr ? settings.graphics.backBufferResolution[1] : (int)((double)th * settings.graphics.backBufferScale);
                this.sceneRenderer.clearScreen();
                IPostProcessor.PostProcessBean ppb = this.gaiaSkyAssets.postProcessor.getPostProcessBean(IPostProcessor.RenderType.screen);
                if (ppb != null) {
                    this.sceneRenderer.render(this.cameraManager, this.t, w, h, tw, th, null, ppb);
                }
                if (settings.runtime.openXr) {
                    this.guiRegistry.render(settings.graphics.backBufferResolution[0], settings.graphics.backBufferResolution[1]);
                } else {
                    this.guiRegistry.render(tw, th);
                }
                if (this.mainVRGui != null) {
                    this.mainVRGui.render(0, 0);
                }
            }
        }
        this.sceneRenderer.swapRenderLists();
        ++this.frames;
        if (settings.graphics.fpsLimit > 0.0) {
            this.targetFrameRate(settings.graphics.fpsLimit);
        } else if (!settings.program.isStereoOrCubemap() && settings.graphics.dynamicResolution && TimeUtils.timeSinceMillis((long)this.startTimeScene) > 10000L && TimeUtils.millis() - this.lastDynamicResolutionChange > 1000L && !settings.runtime.openXr) {
            this.fps = MathUtilsDouble.lowPass(1.0f / this.graphics.getDeltaTime(), this.fps, 10.0f);
            if (this.fps < 30.0f && this.dynamicResolutionLevel < settings.graphics.dynamicResolutionScale.length - 1) {
                settings.graphics.backBufferScale = settings.graphics.dynamicResolutionScale[++this.dynamicResolutionLevel];
                GaiaSky.postRunnable(() -> this.resizeImmediate(this.graphics.getWidth(), this.graphics.getHeight(), true, true, false, false));
                this.lastDynamicResolutionChange = TimeUtils.millis();
            } else if (this.fps > 60.0f && this.dynamicResolutionLevel > 0) {
                settings.graphics.backBufferScale = settings.graphics.dynamicResolutionScale[--this.dynamicResolutionLevel];
                GaiaSky.postRunnable(() -> this.resizeImmediate(this.graphics.getWidth(), this.graphics.getHeight(), true, true, false, false));
                this.lastDynamicResolutionChange = TimeUtils.millis();
            }
        }
    };
    private final Runnable runnableLoadingGui = () -> {
        boolean finished = false;
        try {
            finished = this.assetManager.update();
        }
        catch (GdxRuntimeException e) {
            logger.warn(e.getLocalizedMessage());
        }
        if (finished) {
            this.doneLoading();
            this.updateRenderProcess = this.mainUpdaterRenderer;
        } else {
            if (Settings.settings.runtime.openXr) {
                this.renderGui(this.loadingGuiVR);
            }
            this.renderGui(this.loadingGui);
        }
    };

    public GaiaSky(GaiaSkyDesktop.CLIArgs cliArgs) {
        assert (cliArgs != null) : "CLI arguments can't be null";
        instance = this;
        this.cliArgs = cliArgs;
        this.updateRenderProcess = this.runnableInitialGui;
    }

    public static synchronized void postRunnable(Runnable r) {
        if (instance != null && GaiaSky.instance.window != null) {
            GaiaSky.instance.window.postRunnable(r);
        } else {
            Gdx.app.postRunnable(r);
        }
    }

    public void create() {
        this.startTime = TimeUtils.millis();
        Settings settings = Settings.settings;
        Gdx.app.setLogLevel(this.cliArgs.debug ? 3 : 2);
        Logger.level = this.cliArgs.debug ? Logger.LoggerLevel.DEBUG : Logger.LoggerLevel.INFO;
        settings.graphics.updateBackBufferResolution();
        Pools.get(Array.class, (int)200);
        Timer.instance();
        this.consoleLogger = new ConsoleLogger();
        if (this.cliArgs.debug) {
            logger.debug("Logging level set to DEBUG");
        }
        this.graphics = Gdx.graphics;
        this.window = this.cliArgs.headless ? null : ((Lwjgl3Graphics)this.graphics).getWindow();
        logger.info(settings.version.version, I18n.msg("gui.build", settings.version.build));
        logger.info(I18n.msg("notif.info.displaymode", this.graphics.getWidth(), this.graphics.getHeight(), Gdx.graphics.isFullscreen()));
        logger.info(I18n.msg("notif.info.device", GL30.glGetString((int)7937)));
        logger.info(I18n.msg("notif.glversion", GL30.glGetString((int)7938)));
        logger.info(I18n.msg("notif.glslversion", GL30.glGetString((int)35724)));
        logger.info(I18n.msg("notif.javaversion", System.getProperty("java.version"), System.getProperty("java.vendor")));
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = new Object[1];
        this.maxVertexAttributes = GL30.glGetInteger((int)34921);
        objectArray2[0] = this.maxVertexAttributes;
        objectArray[0] = I18n.msg("notif.info.maxattribs", objectArray2);
        logger.info(objectArray);
        Object[] objectArray3 = new Object[1];
        Object[] objectArray4 = new Object[1];
        this.maxTextureSize = GL30.glGetInteger((int)3379);
        objectArray4[0] = this.maxTextureSize;
        objectArray3[0] = I18n.msg("notif.info.maxtexsize", objectArray4);
        logger.info(objectArray3);
        EventManager.publish(Event.INPUT_ENABLED_CMD, this, false);
        if (!settings.initialized) {
            logger.error(new RuntimeException(I18n.msg("notif.error", "global configuration not initialized")));
            return;
        }
        GlobalClock clock = new GlobalClock(1.0, Instant.now());
        RealTimeClock real = new RealTimeClock();
        this.time = settings.runtime.realTime ? real : clock;
        this.t = 0.0;
        I18n.initialize();
        TooltipManager.getInstance().initialTime = 1.0f;
        TooltipManager.getInstance().hideAll();
        InternalFileHandleResolver internalResolver = new InternalFileHandleResolver();
        FileHandleResolver dataResolver = fileName -> settings.data.dataFileHandle(fileName);
        this.assetManager = new AssetManager((FileHandleResolver)internalResolver);
        this.assetManager.setLoader(Texture.class, ".pfm", (AssetLoader)new PFMTextureLoader(dataResolver));
        this.assetManager.setLoader(PFMData.class, (AssetLoader)new PFMDataLoader(dataResolver));
        this.assetManager.setLoader(Pixmap.class, (AssetLoader)new OwnPixmapLoader(dataResolver));
        this.assetManager.setLoader(PointCloudData.class, (AssetLoader)new OrbitDataLoader(dataResolver));
        this.assetManager.setLoader(OrientationServer.class, (AssetLoader)new OrientationServerLoader(dataResolver));
        this.assetManager.setLoader(ExtShaderProgram.class, (AssetLoader)new ShaderProgramProvider((FileHandleResolver)internalResolver, ".vertex.glsl", ".fragment.glsl"));
        this.assetManager.setLoader(BitmapFont.class, (AssetLoader)new BitmapFontLoader((FileHandleResolver)internalResolver));
        this.assetManager.setLoader(Texture.class, (AssetLoader)new OwnTextureLoader((FileHandleResolver)internalResolver));
        this.assetManager.setLoader(TextureArray.class, (AssetLoader)new TextureArrayLoader((FileHandleResolver)internalResolver));
        this.assetManager.setLoader(AtmosphereShaderProvider.class, new AtmosphereShaderProviderLoader((FileHandleResolver)internalResolver));
        this.assetManager.setLoader(GroundShaderProvider.class, new GroundShaderProviderLoader((FileHandleResolver)internalResolver));
        this.assetManager.setLoader(TessellationShaderProvider.class, new TessellationShaderProviderLoader((FileHandleResolver)internalResolver));
        this.assetManager.setLoader(RelativisticShaderProvider.class, new RelativisticShaderProviderLoader((FileHandleResolver)internalResolver));
        this.assetManager.setLoader(IntModel.class, ".obj", (AssetLoader)new OwnObjLoader(new RegularInputStreamProvider(), (FileHandleResolver)internalResolver));
        this.assetManager.setLoader(IntModel.class, ".obj.gz", (AssetLoader)new OwnObjLoader(new GzipInputStreamProvider(), (FileHandleResolver)internalResolver));
        this.assetManager.setLoader(IntModel.class, ".g3dj", (AssetLoader)new G3dModelLoader((BaseJsonReader)new JsonReader(), (FileHandleResolver)internalResolver));
        this.assetManager.setLoader(IntModel.class, ".g3db", (AssetLoader)new G3dModelLoader((BaseJsonReader)new UBJsonReader(), (FileHandleResolver)internalResolver));
        this.assetManager.setLoader(IntModel.class, ".gltf", (AssetLoader)new GLTFWrapperLoader(dataResolver));
        this.assetManager.setLoader(IntModel.class, ".glb", (AssetLoader)new GLBWrapperLoader(dataResolver));
        this.assetManager.setLoader(GaiaSkyAssets.class, (AssetLoader)new GaiaSkyLoader((FileHandleResolver)internalResolver));
        this.assetManager.setLoader(Scene.class, (AssetLoader)new SceneLoader(dataResolver));
        this.assetManager.setLoader(VSOP87Binary.class, (AssetLoader)new VSOP87Loader(dataResolver));
        this.globalResources = new GlobalResources();
        MasterManager.initialize();
        SlaveManager.load(this.assetManager);
        this.executorService = new GaiaSkyExecutorService();
        this.initializeConstants();
        this.cameraManager = new CameraManager(this.assetManager, CameraManager.CameraMode.FOCUS_MODE, this.cliArgs.vr, this.globalResources);
        AssetBean.setAssetManager(this.assetManager);
        XrLoadStatus vrStatus = this.createVR();
        this.cameraManager.updateFrustumPlanes();
        this.guis = new ArrayList<IGui>(3);
        this.sceneRenderer = new SceneRenderer(this.xrDriver, this.globalResources);
        this.sceneRenderer.initialize(this.assetManager);
        new ScreenshotsManager(this, this.sceneRenderer, this.globalResources);
        this.assetManager.load("gaiasky-assets", GaiaSkyAssets.class, (AssetLoaderParameters)new GaiaSkyLoader.GaiaSkyLoaderParameters(this, this.cliArgs.noScriptingServer));
        Set<AssetBean> assets = AssetBean.getAssets();
        for (AssetBean ab : assets) {
            ab.load(this.assetManager);
        }
        this.renderBatch = this.globalResources.getSpriteBatch();
        EventManager.instance.subscribe((IObserver)this, Event.LOAD_DATA_CMD, Event.UI_SCALE_RECOMPUTE_CMD);
        this.inputMultiplexer = new InputMultiplexer();
        Gdx.input.setInputProcessor((InputProcessor)this.inputMultiplexer);
        this.welcomeGui = new WelcomeGui(this.globalResources.getSkin(), this.graphics, Float.valueOf(1.0f / settings.program.ui.scale), this.cliArgs.skipWelcome, vrStatus);
        this.welcomeGui.initialize(this.assetManager, this.globalResources.getSpriteBatch());
        if (settings.runtime.openXr) {
            this.welcomeGuiVR = new StandaloneVRGui<WelcomeGuiVR>(this.xrDriver, WelcomeGuiVR.class, this.globalResources.getSkin(), new XrInputListener(){

                @Override
                public boolean showUI(boolean value, XrControllerDevice device) {
                    return false;
                }

                @Override
                public boolean accept(boolean value, XrControllerDevice device) {
                    if (value) {
                        return this.proceedToLoading(device);
                    }
                    return false;
                }

                @Override
                public boolean cameraMode(boolean value, XrControllerDevice device) {
                    if (value) {
                        return this.proceedToLoading(device);
                    }
                    return false;
                }

                @Override
                public boolean rotate(boolean value, XrControllerDevice device) {
                    return false;
                }

                @Override
                public boolean move(Vector2 value, XrControllerDevice device) {
                    return false;
                }

                @Override
                public boolean select(float value, XrControllerDevice device) {
                    return false;
                }

                private boolean proceedToLoading(XrControllerDevice device) {
                    WelcomeGui wg = (WelcomeGui)GaiaSky.this.welcomeGui;
                    if (wg.baseDataPresent()) {
                        device.sendHapticPulse(GaiaSky.this.xrDriver, 200000000L, 150.0f, 1.0f);
                        wg.startLoading();
                        return true;
                    }
                    return false;
                }
            });
            this.welcomeGuiVR.initialize(this.assetManager, this.globalResources.getSpriteBatch());
            this.xrDriver.setRenderer(this.welcomeGuiVR);
        } else {
            this.graphics.setVSync(true);
        }
    }

    private void initializeConstants() {
        if (this.cliArgs.vr) {
            Constants.initialize(Settings.settings.scene.distanceScaleVr);
        } else {
            Constants.initialize(Settings.settings.scene.distanceScaleDesktop);
        }
    }

    private XrLoadStatus createVR() {
        Settings settings = Settings.settings;
        if (this.cliArgs.vr) {
            try {
                settings.runtime.openXr = true;
                this.xrDriver = new XrDriver();
                this.xrDriver.createOpenXRInstance();
                this.xrDriver.initializeXRSystem();
                this.xrDriver.checkOpenGL();
                this.xrDriver.initializeOpenXRSession(this.window.getWindowHandle());
                this.xrDriver.createOpenXRReferenceSpace();
                this.xrDriver.createOpenXRSwapchains();
                this.xrDriver.initializeOpenGLFrameBuffers();
                this.xrDriver.initializeInput();
                this.xrDriver.pollEvents();
                if (settings.graphics.resolution[0] != this.xrDriver.getWidth()) {
                    logger.info("Resizing to XR system values:  [" + settings.graphics.resolution[0] + "x" + settings.graphics.resolution[1] + "] -> [" + this.xrDriver.getWidth() + "x" + this.xrDriver.getHeight() + "]");
                    settings.graphics.backBufferResolution[1] = this.xrDriver.getHeight();
                    settings.graphics.backBufferResolution[0] = this.xrDriver.getWidth();
                }
                settings.graphics.vsync = false;
                this.graphics.setWindowedMode(settings.graphics.resolution[0], settings.graphics.resolution[1]);
                this.graphics.setVSync(settings.graphics.vsync);
                if (!settings.scene.visibility.get(ComponentTypes.ComponentType.Others.name()).booleanValue()) {
                    EventManager.publish(Event.TOGGLE_VISIBILITY_CMD, this, "element.others", true);
                }
                this.mainVRGui = new MainVRGui(this.globalResources.getSkin());
                this.mainVRGui.initialize(this.assetManager, this.globalResources.getSpriteBatch());
                this.xrDriver.addListener((MainVRGui)this.mainVRGui);
                EventManager.publish(Event.VR_DRIVER_LOADED, this, this.xrDriver);
                return XrLoadStatus.OK;
            }
            catch (Exception e) {
                settings.runtime.openXr = false;
                logger.error(e);
                logger.error(I18n.msg("vr.init.fail"));
                return XrLoadStatus.ERROR_NO_CONTEXT;
            }
        }
        settings.runtime.openXr = false;
        return XrLoadStatus.NO_VR;
    }

    private void doneLoading() {
        final Settings settings = Settings.settings;
        GaiaSkyAssets assets = (GaiaSkyAssets)this.assetManager.get("gaiasky-assets", GaiaSkyAssets.class);
        this.globalResources.doneLoading(this.assetManager);
        this.windowCreated = true;
        if (this.welcomeGui != null) {
            this.welcomeGui.dispose();
            this.welcomeGui = null;
        }
        if (this.loadingGui != null) {
            this.loadingGui.dispose();
            this.loadingGui = null;
        }
        if (settings.runtime.openXr) {
            this.xrDriver.setRenderer(null);
            this.loadingGuiVR.dispose();
            this.loadingGuiVR = null;
        }
        this.gaiaSkyAssets = assets;
        if (!this.assetManager.isLoaded("SceneData")) {
            throw new RuntimeException("Error loading scene from data load string: SceneData, and files: " + TextUtils.concatenate(File.pathSeparator, settings.data.dataFiles));
        }
        this.scene = (Scene)this.assetManager.get("SceneData");
        this.updateProcess = () -> {
            this.scene.update(this.time);
            this.cameraManager.swapBuffers();
        };
        this.sceneRenderer.doneLoading(this.assetManager);
        this.sceneRenderer.resize(this.graphics.getWidth(), this.graphics.getHeight(), (int)FastMath.round((double)((double)this.graphics.getWidth() * settings.graphics.backBufferScale)), (int)FastMath.round((double)((double)this.graphics.getHeight() * settings.graphics.backBufferScale)));
        this.cameraManager.doneLoading(this.assetManager);
        this.scene.setUpEntities();
        this.scene.prepareUpdateSystems(this.sceneRenderer);
        this.inputMultiplexer.clear();
        this.guiRegistry = new GuiRegistry(this.globalResources.getSkin(), this.scene, this.gaiaSkyAssets.catalogManager);
        this.guiRegistry.setInputMultiplexer(this.inputMultiplexer);
        Gdx.input.setInputProcessor((InputProcessor)this.inputMultiplexer);
        this.consoleLogger.setUseHistorical(false);
        this.reinitialiseGUI2();
        EventManager.publish(Event.VISIBILITY_OF_COMPONENTS, this, this.sceneRenderer.visible);
        this.inputMultiplexer.addProcessor((InputProcessor)new KeyboardInputController(Gdx.input));
        EventManager.publish(Event.SCENE_LOADED, this, this.scene);
        this.touchSceneGraph();
        EventManager.publish(Event.TIME_CHANGE_INFO, this, this.time.getTime());
        EventManager.instance.subscribe((IObserver)this, Event.CAMERA_MODE_CMD, Event.STEREOSCOPIC_CMD, Event.CUBEMAP_CMD, Event.PARK_RUNNABLE, Event.PARK_CAMERA_RUNNABLE, Event.UNPARK_RUNNABLE, Event.SCENE_ADD_OBJECT_CMD, Event.SCENE_ADD_OBJECT_NO_POST_CMD, Event.SCENE_REMOVE_OBJECT_CMD, Event.SCENE_REMOVE_OBJECT_NO_POST_CMD, Event.SCENE_RELOAD_NAMES_CMD, Event.HOME_CMD, Event.RESET_RENDERER, Event.SCENE_FORCE_UPDATE, Event.GO_HOME_INSTANT_CMD);
        EventManager.publish(Event.INPUT_ENABLED_CMD, this, true);
        EventManager.publish(Event.TIME_CHANGE_CMD, this, Instant.now());
        for (IGui gui : this.guis) {
            gui.resize(this.graphics.getWidth(), this.graphics.getHeight());
        }
        if (settings.runtime.openXr) {
            GaiaSky.postRunnable(() -> this.resizeImmediate(this.xrDriver.getWidth(), this.xrDriver.getHeight(), true, false, false, false));
        }
        this.frames = 0L;
        Timer.Task debugTask1 = new Timer.Task(this){
            final /* synthetic */ GaiaSky this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                EventManager.publish(Event.FPS_INFO, (Object)this, Float.valueOf(1.0f / this.this$0.graphics.getDeltaTime()));
                EventManager.publish(Event.DEBUG_TIME, (Object)this, this.this$0.getRunTimeSeconds());
                EventManager.publish(Event.DEBUG_RAM, (Object)this, MemInfo.getUsedMemory(), MemInfo.getFreeMemory(), MemInfo.getTotalMemory(), MemInfo.getMaxMemory());
                EventManager.publish(Event.DEBUG_VRAM, (Object)this, VMemInfo.getUsedMemory(), VMemInfo.getTotalMemory());
                if (settings.graphics.dynamicResolution) {
                    EventManager.publish(Event.DEBUG_DYN_RES, (Object)this, this.this$0.dynamicResolutionLevel, settings.graphics.dynamicResolutionScale[this.this$0.dynamicResolutionLevel]);
                }
                if (OctreeLoader.instance != null) {
                    EventManager.publish(Event.DEBUG_OBJECTS, (Object)this, OctreeNode.nObjectsObserved, OctreeLoader.instance.getNLoadedStars());
                    EventManager.publish(Event.DEBUG_QUEUE, (Object)this, OctreeNode.nOctantsObserved, OctreeLoader.instance.getLoadQueueSize());
                }
            }
        };
        Timer.Task debugTask10 = new Timer.Task(){

            public void run() {
                EventManager.publish(Event.SAMP_INFO, (Object)this, GaiaSky.this.gaiaSkyAssets.sampClient.getStatus());
            }
        };
        Timer.schedule((Timer.Task)debugTask1, (float)2.0f, (float)1.0f);
        Timer.schedule((Timer.Task)debugTask10, (float)2.0f, (float)10.0f);
        Timer.Task startCapturing = new Timer.Task(this){

            public void run() {
                LocationLogManager.instance().startCapturing();
            }
        };
        Timer.schedule((Timer.Task)startCapturing, (float)1.0f);
        this.guiRegistry.publishReleaseNotes();
        this.goHome();
        Timer.Task logAttributes = new Timer.Task(this){

            public void run() {
                logger.info("Total number of attributes registered: " + Attribute.getNumAttributes());
                if (Settings.settings.program.debugInfo) {
                    logger.debug("Registered attributes:");
                    Array<String> attributes = Attribute.getTypes();
                    for (int i = 0; i < attributes.size; ++i) {
                        logger.debug(i + ": " + (String)attributes.get(i));
                    }
                }
            }
        };
        Timer.schedule((Timer.Task)logAttributes, (float)5.0f);
        if (this.cliArgs.vr) {
            Timer.Task scaleGaia = new Timer.Task(){

                public void run() {
                    ImmutableArray<Entity> satellites = GaiaSky.this.scene.findEntitiesByFamily(GaiaSky.this.scene.getFamilies().satellites);
                    for (Entity satellite : satellites) {
                        Base base = (Base)Mapper.base.get(satellite);
                        GaiaSky.this.gaiaSkyAssets.scriptingInterface.setObjectSizeScaling(base.getName(), Constants.DISTANCE_SCALE_FACTOR / 10.0);
                    }
                }
            };
            Timer.schedule((Timer.Task)scaleGaia, (float)10.0f);
        }
        this.scene.reportDebugObjects();
        EventManager.publish(Event.INITIALIZED_INFO, this, new Object[0]);
        this.sceneRenderer.setRendering(true);
        this.graphics.setVSync(settings.graphics.vsync);
        this.startTimeScene = TimeUtils.millis();
        this.initialized = true;
    }

    public void touchSceneGraph() {
        Settings settings = Settings.settings;
        settings.runtime.octreeLoadActive = false;
        boolean timeOnBak = settings.runtime.timeOn;
        settings.runtime.timeOn = true;
        this.time.update(1.0E-9);
        this.scene.update(this.time);
        this.sceneRenderer.swapRenderLists();
        this.time.update(0.0);
        settings.runtime.timeOn = timeOnBak;
        settings.runtime.octreeLoadActive = true;
    }

    private void goHome() {
        final Settings settings = Settings.settings;
        final Entity homeObject = this.scene.findFocus(settings.scene.homeObject);
        boolean isOn = true;
        if (homeObject != null && (isOn = this.isOn(((Base)Mapper.base.get((Entity)homeObject)).ct)) && !settings.program.net.slave.active) {
            EventManager.publish(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FOCUS_MODE});
            EventManager.publish(Event.FOCUS_CHANGE_CMD, this, homeObject, true);
            EventManager.publish(Event.GO_TO_OBJECT_CMD, this, new Object[0]);
            if (settings.runtime.openXr) {
                EventManager.publishDelayed(Event.CAMERA_MODE_CMD, this, 1000L, new Object[]{CameraManager.CameraMode.FREE_MODE});
            }
        } else {
            EventManager.publish(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FREE_MODE});
            EventManager.publish(Event.CAMERA_POS_CMD, this, new Object[]{new double[]{0.0, 5.0 * Constants.AU_TO_U, 0.0}});
            EventManager.publish(Event.CAMERA_DIR_CMD, this, new Object[]{new double[]{0.0, -1.0, 0.0}});
            EventManager.publish(Event.CAMERA_UP_CMD, this, new Object[]{new double[]{0.0, 0.0, 1.0}});
        }
        if (!isOn) {
            Timer.Task t = new Timer.Task(this){

                public void run() {
                    logger.info("The home object '" + settings.scene.homeObject + "' is invisible due to its type(s): " + String.valueOf(((Base)Mapper.base.get((Entity)homeObject)).ct));
                }
            };
            Timer.schedule((Timer.Task)t, (float)1.0f);
        }
    }

    public void reinitialiseGUI1() {
        Settings settings = Settings.settings;
        if (this.guis != null && !this.guis.isEmpty()) {
            for (IGui gui : this.guis) {
                gui.dispose();
            }
            this.guis.clear();
        }
        this.globalResources.initialize(this.assetManager);
        this.mainGui = new FullGui(this.globalResources.getSkin(), this.graphics, Float.valueOf(this.unitsPerPixel), this.globalResources);
        this.mainGui.initialize(this.assetManager, this.globalResources.getSpriteBatch());
        this.debugGui = new DebugGui(this.globalResources.getSkin(), this.graphics, Float.valueOf(this.unitsPerPixel));
        this.debugGui.initialize(this.assetManager, this.globalResources.getSpriteBatch());
        this.spacecraftGui = new SpacecraftGui(this.globalResources.getSkin(), this.graphics, Float.valueOf(this.unitsPerPixel));
        this.spacecraftGui.initialize(this.assetManager, this.globalResources.getSpriteBatch());
        this.stereoGui = new StereoGui(this.globalResources.getSkin(), this.graphics, Float.valueOf(this.unitsPerPixel));
        this.stereoGui.initialize(this.assetManager, this.globalResources.getSpriteBatch());
        this.gamepadGui = new GamepadGui(this.globalResources.getSkin(), this.graphics, Float.valueOf(this.unitsPerPixel));
        this.gamepadGui.initialize(this.assetManager, this.globalResources.getSpriteBatch());
        this.timeGui = new TimeGui(this.globalResources.getSkin(), this.graphics, Float.valueOf(this.unitsPerPixel));
        this.timeGui.initialize(this.assetManager, this.globalResources.getSpriteBatch());
        if (this.guis != null) {
            this.guis.add(this.mainGui);
            this.guis.add(this.debugGui);
            this.guis.add(this.spacecraftGui);
            this.guis.add(this.stereoGui);
            this.guis.add(this.gamepadGui);
            this.guis.add(this.timeGui);
        }
    }

    public void reinitialiseGUI2() {
        Settings settings = Settings.settings;
        if (this.guiRegistry != null) {
            this.guiRegistry.dispose();
        }
        this.guiRegistry = new GuiRegistry(this.globalResources.getSkin(), this.scene, this.gaiaSkyAssets.catalogManager);
        this.guiRegistry.setInputMultiplexer(this.inputMultiplexer);
        this.guiRegistry.unregisterAll();
        ((FullGui)this.mainGui).setScene(this.scene);
        this.mainGui.setVisibilityToggles(ComponentTypes.ComponentType.values(), this.sceneRenderer.visible);
        for (IGui gui : this.guis) {
            gui.doneLoading(this.assetManager);
        }
        if (settings.program.modeStereo.active) {
            this.guiRegistry.set(this.stereoGui);
            this.guiRegistry.setPrevious(this.mainGui);
        } else {
            this.guiRegistry.set(this.mainGui);
            this.guiRegistry.setPrevious(null);
        }
        this.guiRegistry.registerGui(this.debugGui);
        this.guiRegistry.addProcessor(this.debugGui);
        this.guiRegistry.registerGui(this.gamepadGui);
        this.guiRegistry.addProcessor(this.gamepadGui);
        this.guiRegistry.registerSpecialGui(this.timeGui);
    }

    public void pause() {
    }

    public void resume() {
    }

    public void dispose() {
        Settings settings = Settings.settings;
        this.running.set(false);
        if (this.dynamicResolutionLevel > 0 && settings.graphics.backBufferScale == settings.graphics.dynamicResolutionScale[0]) {
            settings.graphics.backBufferScale = 1.0;
            this.dynamicResolutionLevel = 0;
        }
        if (this.saveState && !this.crashed.get()) {
            SettingsManager.persistSettings(new File(System.getProperty("properties.file")));
            if (this.gaiaSkyAssets != null && this.gaiaSkyAssets.bookmarksManager != null) {
                this.gaiaSkyAssets.bookmarksManager.persistBookmarks();
            }
        }
        ScriptingServer.dispose();
        EventManager.publish(Event.FLUSH_FRAMES, this, new Object[0]);
        if (this.guis != null) {
            for (IGui gui : this.guis) {
                gui.dispose();
            }
        }
        EventManager.publish(Event.DISPOSE, this, new Object[0]);
        ModelCache.cache.dispose();
        if (this.assetManager != null) {
            this.assetManager.dispose();
        }
        if (this.executorService != null) {
            this.executorService.shutDownThreadPool();
        }
        ScriptingServer.dispose();
        if (this.sceneRenderer != null) {
            this.sceneRenderer.dispose();
        }
        if (this.gaiaSkyAssets != null && this.gaiaSkyAssets.postProcessor != null) {
            this.gaiaSkyAssets.postProcessor.dispose();
        }
        try {
            Path tmp = SysUtils.getDataTempDir(settings.data.location);
            if (Files.exists(tmp, new LinkOption[0]) && Files.isDirectory(tmp, new LinkOption[0])) {
                GlobalResources.deleteRecursively(tmp);
            }
        }
        catch (Exception e) {
            logger.error(e, "Error deleting tmp directory");
        }
        if (this.xrDriver != null) {
            this.xrDriver.dispose();
        }
        CrashReporter.writeLastSessionLog(logger);
        if (SysUtils.isLinux() && SysUtils.isWayland()) {
            System.exit(0);
        }
    }

    public void resetDynamicResolution() {
        if (Settings.settings.graphics.dynamicResolution) {
            Settings.settings.graphics.dynamicResolution = false;
            Settings.settings.graphics.backBufferScale = 1.0;
            this.dynamicResolutionLevel = 0;
            this.lastDynamicResolutionChange = 0L;
        }
        GaiaSky.postRunnable(() -> this.resizeImmediate(this.graphics.getWidth(), this.graphics.getHeight(), true, true, false, false));
    }

    public FrameBuffer getBackRenderBuffer() {
        return this.sceneRenderer.getRenderProcess().getResultBuffer();
    }

    public void setCrashed(boolean crashed) {
        this.crashed.set(crashed);
    }

    public void render() {
        if (this.running.get() && !this.crashed.get() && this.updateRenderProcess != null) {
            this.updateRenderProcess.run();
        } else if (this.crashGui != null) {
            this.assetManager.update();
            this.renderGui(this.crashGui);
            ++this.frames;
        }
        if (this.cliArgs.externalView && this.gaiaSkyView == null) {
            GaiaSky.postRunnable(() -> {
                Lwjgl3Application app = (Lwjgl3Application)Gdx.app;
                Lwjgl3WindowConfiguration config = new Lwjgl3WindowConfiguration();
                config.setWindowPosition(0, 0);
                config.setWindowedMode(this.graphics.getWidth(), this.graphics.getHeight());
                config.setTitle(Settings.APPLICATION_NAME + " - External view");
                config.useVsync(false);
                config.setWindowIcon(Files.FileType.Internal, new String[]{"icon/gs_round_256.png"});
                this.gaiaSkyView = new GaiaSkyView(this.globalResources.getSkin(), this.globalResources.getSpriteShader());
                Lwjgl3Window newWindow = app.newWindow((ApplicationListener)this.gaiaSkyView, config);
                this.gaiaSkyView.setWindow(newWindow);
            });
        }
    }

    private void targetFrameRate(double fps) {
        if (fps > 0.0) {
            double targetFrameTimeNanos;
            long currentFrameTimeNanos = System.nanoTime() - this.startNanos;
            if ((double)currentFrameTimeNanos < (targetFrameTimeNanos = 1.0E9 / fps)) {
                GaiaSky.busySleep((long)(targetFrameTimeNanos - (double)currentFrameTimeNanos));
            }
            this.startNanos = System.nanoTime();
        }
    }

    private static void busySleep(long nanos) {
        long elapsed;
        long startTime = System.nanoTime();
        while ((elapsed = System.nanoTime() - startTime) < nanos) {
        }
    }

    public void update(double dt) {
        this.updateResize();
        Timer.instance();
        double dtGs = this.getDtGs(dt);
        this.t += dtGs;
        this.guiRegistry.update(dtGs);
        EventManager.publish(Event.UPDATE_GUI, this, dtGs);
        this.time.update(dtGs);
        EventManager.instance.dispatchDelayedMessages();
        this.cameraManager.update(dtGs, this.time);
        if (this.mainVRGui != null) {
            this.mainVRGui.update(dtGs);
        }
        this.runParkedProcesses(this.parkedCameraRunnables);
        if (this.parkedCameraRunnables.size > 0 && this.cameraManager.current instanceof NaturalCamera) {
            ((NaturalCamera)this.cameraManager.current).updatePerspectiveCamera();
        }
        RelativisticEffectsManager.getInstance().update(this.time, this.cameraManager.current);
        this.updateProcess.run();
        this.runParkedProcesses(this.parkedUpdateRunnables);
    }

    private double getDtGs(double dt) {
        Settings settings = Settings.settings;
        double dtGs = settings.frame.active ? 1.0 / settings.frame.targetFps : (Camcorder.instance.isRecording() ? 1.0 / settings.camrecorder.targetFps : FastMath.min((double)dt, (double)0.05));
        return dtGs;
    }

    private void runParkedProcesses(Array<Runnable> processes) {
        if (processes != null && processes.size > 0) {
            Array.ArrayIterator it = processes.iterator();
            while (it.hasNext()) {
                Runnable r = (Runnable)it.next();
                try {
                    r.run();
                }
                catch (Exception e) {
                    logger.error(e);
                    it.remove();
                }
            }
        }
    }

    public void resize(int width, int height) {
        if (width != 0 && height != 0) {
            EventManager.publish(Event.UI_SCALE_RECOMPUTE_CMD, this, height);
            if (!Gdx.graphics.isFullscreen()) {
                EventManager.publish(Event.WINDOW_RESOLUTION_INFO, this, width, height);
            }
            if (!this.initialized) {
                this.resizeImmediate(width, height, true, true, true, true);
            }
            this.resizeWidth = width;
            this.resizeHeight = height;
            this.lastResizeTime = System.currentTimeMillis();
            if (this.renderBatch != null) {
                this.renderBatch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, (float)width, (float)height);
            }
            Settings.settings.graphics.resolution[0] = width;
            Settings.settings.graphics.resolution[1] = height;
        }
    }

    private void updateResize() {
        long currResizeTime = System.currentTimeMillis();
        if (currResizeTime - this.lastResizeTime > 100L) {
            Settings settings = Settings.settings;
            this.resizeImmediate(this.resizeWidth, this.resizeHeight, !settings.runtime.openXr, !settings.runtime.openXr, true, true);
            this.lastResizeTime = Long.MAX_VALUE;
        }
    }

    public void resizeImmediate(int width, int height, boolean resizePostProcessors, boolean resizeRenderSys, boolean resizeGuis, boolean resizeScreenConf) {
        try {
            Settings settings = Settings.settings;
            int renderWidth = (int)FastMath.round((double)((double)width * settings.graphics.backBufferScale));
            int renderHeight = (int)FastMath.round((double)((double)height * settings.graphics.backBufferScale));
            this.globalResources.resize(renderWidth, renderHeight);
            if (!this.initialized) {
                if (this.welcomeGui != null) {
                    this.welcomeGui.resize(width, height);
                }
                if (this.loadingGui != null) {
                    this.loadingGui.resizeImmediate(width, height);
                }
            } else {
                if (resizePostProcessors) {
                    this.gaiaSkyAssets.postProcessor.resizeImmediate(renderWidth, renderHeight, width, height);
                }
                if (resizeGuis) {
                    for (IGui gui : this.guis) {
                        gui.resizeImmediate(width, height);
                    }
                }
                if (this.mainVRGui != null) {
                    this.mainVRGui.resize(width, height);
                }
                this.sceneRenderer.resize(width, height, renderWidth, renderHeight, resizeRenderSys);
                if (resizeScreenConf) {
                    settings.graphics.resize(width, height);
                }
            }
            this.cameraManager.updateAngleEdge(renderWidth, renderHeight);
            this.cameraManager.resize(width, height);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    private void renderGui(IGui gui) {
        gui.update(this.graphics.getDeltaTime());
        gui.render(this.graphics.getWidth(), this.graphics.getHeight());
    }

    public IScriptingInterface scripting() {
        return this.gaiaSkyAssets.scriptingInterface;
    }

    public GaiaSkyExecutorService getExecutorService() {
        return this.executorService;
    }

    public GuiRegistry getGuiRegistry() {
        return this.guiRegistry;
    }

    public BookmarksManager getBookmarksManager() {
        return this.gaiaSkyAssets.bookmarksManager;
    }

    public ICamera getICamera() {
        return this.cameraManager.current;
    }

    public double getT() {
        return this.t;
    }

    public CameraManager getCameraManager() {
        return this.cameraManager;
    }

    public IPostProcessor getPostProcessor() {
        return this.gaiaSkyAssets.postProcessor;
    }

    public GaiaSkyDesktop.CLIArgs getCliArgs() {
        return this.cliArgs;
    }

    public boolean isOn(int ordinal) {
        return this.sceneRenderer.isOn(ordinal);
    }

    public boolean isOn(ComponentTypes.ComponentType comp) {
        return this.sceneRenderer.isOn(comp);
    }

    public boolean isOn(ComponentTypes cts) {
        return this.sceneRenderer.allOn(cts);
    }

    public float alpha(ComponentTypes cts) {
        return this.sceneRenderer.alpha(cts);
    }

    public Optional<CatalogInfo> getCatalogInfoFromEntity(Entity entity) {
        if (Mapper.datasetDescription.has(entity)) {
            return this.gaiaSkyAssets.catalogManager.getByEntity(entity);
        }
        return Optional.empty();
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        Settings settings = Settings.settings;
        switch (event) {
            case LOAD_DATA_CMD: {
                this.reinitialiseGUI1();
                this.loadingGui = new LoadingGui(this.globalResources.getSkin(), this.graphics, Float.valueOf(1.0f / settings.program.ui.scale), false);
                this.loadingGui.initialize(this.assetManager, this.globalResources.getSpriteBatch());
                Gdx.input.setInputProcessor((InputProcessor)this.loadingGui.getGuiStage());
                if (settings.runtime.openXr) {
                    this.loadingGuiVR = new StandaloneVRGui<LoadingGui>(this.xrDriver, LoadingGui.class, this.globalResources.getSkin(), null);
                    this.loadingGuiVR.initialize(this.assetManager, this.globalResources.getSpriteBatch());
                    this.xrDriver.setRenderer(this.loadingGuiVR);
                    this.welcomeGuiVR.dispose();
                    this.welcomeGuiVR = null;
                }
                this.updateRenderProcess = this.runnableLoadingGui;
                if (this.scene != null) break;
                String[] dataFilesToLoad = new String[settings.data.dataFiles.size()];
                int i = 0;
                Iterator<String> iterator = settings.data.dataFiles.iterator();
                while (iterator.hasNext()) {
                    String dataFile;
                    dataFilesToLoad[i] = dataFile = iterator.next();
                    ++i;
                }
                this.assetManager.load("SceneData", Scene.class, (AssetLoaderParameters)new SceneLoader.SceneLoaderParameters(dataFilesToLoad));
                break;
            }
            case CAMERA_MODE_CMD: {
                CameraManager.CameraMode mode = (CameraManager.CameraMode)((Object)data[0]);
                if (settings.program.modeStereo.isStereoHalfViewport()) {
                    this.guiRegistry.change(this.stereoGui);
                    break;
                }
                if (mode == CameraManager.CameraMode.SPACECRAFT_MODE) {
                    this.guiRegistry.change(this.spacecraftGui);
                    break;
                }
                this.guiRegistry.change(this.mainGui);
                break;
            }
            case STEREOSCOPIC_CMD: {
                if (this.isVR()) break;
                boolean stereoMode = (Boolean)data[0];
                if (stereoMode && this.guiRegistry.current != this.stereoGui) {
                    this.guiRegistry.change(this.stereoGui);
                } else if (!stereoMode && this.guiRegistry.previous != null && this.guiRegistry.previous != this.stereoGui && this.guiRegistry.previous != this.spacecraftGui) {
                    IGui prev = this.guiRegistry.current != null ? this.guiRegistry.current : this.mainGui;
                    this.guiRegistry.change(this.guiRegistry.previous, prev);
                }
                if (stereoMode) {
                    this.resetDynamicResolution();
                    String[] keysStrToggle = KeyBindings.instance.getStringArrayKeys("action.toggle/element.stereomode");
                    String[] keysStrProfile = KeyBindings.instance.getStringArrayKeys("action.switchstereoprofile");
                    ModePopupInfo mpi = new ModePopupInfo();
                    mpi.title = I18n.msg("gui.stereo.title");
                    mpi.header = I18n.msg("gui.stereo.notice.header");
                    mpi.addMapping(I18n.msg("gui.stereo.notice.back"), keysStrToggle);
                    mpi.addMapping(I18n.msg("gui.stereo.notice.profile"), keysStrProfile);
                    EventManager.publish(Event.MODE_POPUP_CMD, this, mpi, "stereo", Float.valueOf(10.0f));
                    break;
                }
                EventManager.publish(Event.MODE_POPUP_CMD, this, null, "stereo");
                break;
            }
            case CUBEMAP_CMD: {
                Boolean cubemapMode = (Boolean)data[0];
                if (this.isVR() || !cubemapMode.booleanValue()) break;
                this.resetDynamicResolution();
                break;
            }
            case SCENE_ADD_OBJECT_CMD: {
                boolean addToIndex;
                Entity toAdd = (Entity)data[0];
                boolean bl = addToIndex = data.length == 1 || (Boolean)data[1] != false;
                if (this.scene == null) break;
                GaiaSky.postRunnable(() -> {
                    try {
                        this.scene.insert(toAdd, addToIndex);
                    }
                    catch (Exception e) {
                        logger.error(e);
                    }
                });
                break;
            }
            case SCENE_ADD_OBJECT_NO_POST_CMD: {
                boolean addToIndex;
                Entity toAddPost = (Entity)data[0];
                boolean bl = addToIndex = data.length == 1 || (Boolean)data[1] != false;
                if (this.scene == null) break;
                try {
                    this.scene.insert(toAddPost, addToIndex);
                }
                catch (Exception e) {
                    logger.error(e);
                }
                break;
            }
            case SCENE_REMOVE_OBJECT_CMD: {
                boolean removeFromIndex;
                Entity toRemove = null;
                if (data[0] instanceof String) {
                    toRemove = this.scene.getEntity((String)data[0]);
                    if (toRemove == null) {
                        return;
                    }
                } else if (data[0] instanceof Entity) {
                    toRemove = (Entity)data[0];
                } else if (data[0] instanceof FocusView) {
                    toRemove = ((FocusView)data[0]).getEntity();
                }
                if (toRemove == null) break;
                boolean bl = removeFromIndex = data.length == 1 || (Boolean)data[1] != false;
                if (this.scene == null) break;
                Entity entityToRemove = toRemove;
                GaiaSky.postRunnable(() -> {
                    try {
                        this.scene.remove(entityToRemove, removeFromIndex);
                    }
                    catch (Exception e) {
                        logger.warn(e);
                    }
                });
                break;
            }
            case SCENE_REMOVE_OBJECT_NO_POST_CMD: {
                boolean removeFromIndex;
                Entity toRemove = null;
                if (data[0] instanceof String) {
                    toRemove = this.scene.getEntity((String)data[0]);
                    if (toRemove == null) {
                        return;
                    }
                } else if (data[0] instanceof Entity) {
                    toRemove = (Entity)data[0];
                } else if (data[0] instanceof FocusView) {
                    toRemove = ((FocusView)data[0]).getEntity();
                }
                if (toRemove == null) break;
                boolean bl = removeFromIndex = data.length == 1 || (Boolean)data[1] != false;
                if (this.scene == null) break;
                this.scene.remove(toRemove, removeFromIndex);
                break;
            }
            case SCENE_RELOAD_NAMES_CMD: {
                GaiaSky.postRunnable(() -> this.scene.updateLocalizedNames());
                break;
            }
            case UI_SCALE_RECOMPUTE_CMD: {
                int height = data != null && data.length > 0 ? ((Integer)data[0]).intValue() : Gdx.graphics.getHeight();
                this.applyUIScale(height, this.guis);
                break;
            }
            case HOME_CMD: 
            case GO_HOME_INSTANT_CMD: {
                this.goHome();
                break;
            }
            case PARK_RUNNABLE: {
                String key = (String)data[0];
                Runnable updateRunnable = (Runnable)data[1];
                this.parkUpdateRunnable(key, updateRunnable);
                break;
            }
            case PARK_CAMERA_RUNNABLE: {
                String key = (String)data[0];
                Runnable cameraRunnable = (Runnable)data[1];
                this.parkCameraRunnable(key, cameraRunnable);
                break;
            }
            case UNPARK_RUNNABLE: {
                String key = (String)data[0];
                this.removeRunnable(key);
                break;
            }
            case RESET_RENDERER: {
                if (this.sceneRenderer == null) break;
                this.sceneRenderer.resetRenderSystemFlags();
                break;
            }
            case SCENE_FORCE_UPDATE: {
                this.touchSceneGraph();
            }
        }
    }

    private float getUIScale(int height) {
        return (float)height / 1600.0f * Settings.settings.program.ui.scale;
    }

    public void applyUIScale(int height, IGui gui) {
        if (gui != null) {
            gui.updateUnitsPerPixel(1.0f / this.getUIScale(height));
        }
    }

    public void applyUIScale(int height, List<IGui> guis) {
        if (guis != null) {
            this.unitsPerPixel = 1.0f / this.getUIScale(height);
            for (IGui gui : guis) {
                gui.updateUnitsPerPixel(this.unitsPerPixel);
            }
        }
    }

    public float getUnitsPerPixel() {
        return this.unitsPerPixel;
    }

    public boolean isInitialised() {
        return this.initialized;
    }

    public boolean isHeadless() {
        return this.cliArgs.headless;
    }

    public boolean isExternalView() {
        return this.gaiaSkyView != null;
    }

    public GlobalResources getGlobalResources() {
        return this.globalResources;
    }

    public CatalogManager getCatalogManager() {
        return this.gaiaSkyAssets.catalogManager;
    }

    public ConsoleManager getConsoleManager() {
        return this.gaiaSkyAssets.consoleManager;
    }

    public void parkUpdateRunnable(String key, Runnable runnable) {
        this.parkRunnable(key, runnable, this.parkedUpdateRunnablesMap, this.parkedUpdateRunnables);
    }

    public void parkCameraRunnable(String key, Runnable runnable) {
        this.parkRunnable(key, runnable, this.parkedCameraRunnablesMap, this.parkedCameraRunnables);
    }

    public void parkRunnable(String key, Runnable runnable, Map<String, Runnable> map, Array<Runnable> runnables) {
        map.put(key, runnable);
        runnables.add((Object)runnable);
    }

    public void removeRunnable(String key) {
        this.removeRunnable(key, this.parkedUpdateRunnablesMap, this.parkedUpdateRunnables);
        this.removeRunnable(key, this.parkedCameraRunnablesMap, this.parkedCameraRunnables);
    }

    private void removeRunnable(String key, Map<String, Runnable> map, Array<Runnable> runnables) {
        Runnable r;
        if (map.containsKey(key) && (r = map.get(key)) != null) {
            runnables.removeValue((Object)r, true);
            map.remove(key);
        }
    }

    public double getRunTimeSeconds() {
        return (double)TimeUtils.timeSinceMillis((long)this.startTime) / 1000.0;
    }

    public double getSceneTimeSeconds() {
        return (double)TimeUtils.timeSinceMillis((long)this.startTimeScene) / 1000.0;
    }

    public boolean isVR() {
        return this.cliArgs.vr;
    }

    public static void popupNotification(String message, float duration, Object source, Logger.LoggerLevel level, Throwable t) {
        EventManager.publish(Event.POST_POPUP_NOTIFICATION, source, message, Float.valueOf(duration));
        if (t != null) {
            logger.log(level, message, t.getLocalizedMessage());
        } else {
            logger.log(level, message);
        }
    }

    public static void popupNotification(String message, float duration, Object source) {
        GaiaSky.popupNotification(message, duration, source, Logger.LoggerLevel.INFO, null);
    }
}

