/*
 * Decompiled with CFR 0.152.
 */
package gaiasky;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Graphics;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Input;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Window;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.util.RenderUtils;
import gaiasky.util.scene2d.OwnLabel;

public class GaiaSkyView
implements ApplicationListener,
IObserver {
    private final Skin skin;
    private final ShaderProgram spriteShader;
    private final Vector2 lastTexSize;
    public Lwjgl3Window window;
    public Lwjgl3Graphics graphics;
    public Lwjgl3Input input;
    private Stage ui;
    private SpriteBatch sb;
    private boolean initGui = false;
    private boolean initializing = true;

    public GaiaSkyView(Skin skin, ShaderProgram spriteShader) {
        this.skin = skin;
        this.spriteShader = spriteShader;
        this.lastTexSize = new Vector2(-1.0f, -1.0f);
        EventManager.instance.subscribe((IObserver)this, Event.INITIALIZED_INFO);
    }

    public void setWindow(Lwjgl3Window window) {
        this.window = window;
    }

    public void create() {
        this.sb = new SpriteBatch(100, this.spriteShader);
    }

    private void createInitGui() {
        if (!this.initGui) {
            ScreenViewport vp = new ScreenViewport();
            Stage ui = new Stage((Viewport)vp, (Batch)this.sb);
            vp.update(this.graphics.getWidth(), this.graphics.getHeight(), true);
            OwnLabel l = new OwnLabel((CharSequence)"The external view will appear here as soon as Gaia Sky finishes loading", this.skin, "default");
            Container c = new Container((Actor)l);
            c.center();
            c.setFillParent(true);
            ui.addActor((Actor)c);
            this.ui = ui;
            this.initGui = true;
        }
    }

    private void removeGui() {
        this.ui.clear();
        this.initializing = false;
    }

    public void resize(int width, int height) {
        if (this.ui != null) {
            this.ui.getViewport().update(width, height, true);
        }
    }

    public void render() {
        Gdx.gl.glClear(16640);
        this.updateGlobals();
        this.createInitGui();
        if (this.initializing) {
            this.ui.act(this.graphics.getDeltaTime());
            this.ui.getViewport().apply();
            this.ui.draw();
        } else {
            FrameBuffer renderBuffer = GaiaSky.instance.getBackRenderBuffer();
            if (renderBuffer != null) {
                RenderUtils.renderKeepAspect(renderBuffer, this.sb, (Graphics)this.graphics, this.lastTexSize);
            }
        }
    }

    private void updateGlobals() {
        if (this.graphics == null) {
            this.graphics = (Lwjgl3Graphics)Gdx.graphics;
        }
        if (this.input == null) {
            this.input = (Lwjgl3Input)Gdx.input;
        }
    }

    public void pause() {
    }

    public void resume() {
    }

    public void dispose() {
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.INITIALIZED_INFO) {
            this.postRunnable(this::removeGui);
        }
    }

    public void postRunnable(Runnable r) {
        if (this.window != null) {
            this.window.postRunnable(r);
        } else {
            Gdx.app.postRunnable(r);
        }
    }
}

