/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data;

import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class AssetBean<T> {
    private static final Set<AssetBean> assetDescriptors = new HashSet<AssetBean>();
    private static final AtomicReference<AssetManager> assetManager = new AtomicReference();
    private final String assetName;
    private final Class<T> assetClass;
    private AssetLoaderParameters<T> assetParams = null;

    private AssetBean(String assetName, Class<T> assetClass) {
        this.assetName = assetName;
        this.assetClass = assetClass;
    }

    private AssetBean(String assetName, Class<T> assetClass, AssetLoaderParameters<T> params) {
        this(assetName, assetClass);
        this.assetParams = params;
    }

    public static <T> void addAsset(String assetName, Class<T> assetClass) {
        if (assetManager == null) {
            assetDescriptors.add(new AssetBean<T>(assetName, assetClass));
        } else {
            assetManager.get().load(assetName, assetClass);
        }
    }

    public static <T> void addAsset(String assetName, Class<T> assetClass, AssetLoaderParameters<T> params) {
        if (assetManager == null) {
            assetDescriptors.add(new AssetBean<T>(assetName, assetClass, params));
        } else {
            assetManager.get().load(assetName, assetClass, params);
        }
    }

    public static Set<AssetBean> getAssets() {
        return assetDescriptors;
    }

    public static void setAssetManager(AssetManager manager) {
        assetManager.set(manager);
    }

    public static AssetManager manager() {
        return assetManager.get();
    }

    public void load(AssetManager manager) {
        if (this.assetParams != null) {
            manager.load(this.assetName, this.assetClass, this.assetParams);
        } else {
            manager.load(this.assetName, this.assetClass);
        }
    }
}

