/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Constructor;
import com.badlogic.gdx.utils.reflect.Method;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import gaiasky.data.AbstractSceneLoader;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.scene.Archetype;
import gaiasky.scene.AttributeMap;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.record.BillboardDataset;
import gaiasky.scene.record.MachineDefinition;
import gaiasky.scene.record.RotateTransform;
import gaiasky.util.Functions;
import gaiasky.util.Logger;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.TextUtils;
import gaiasky.util.coord.IBodyCoordinates;
import gaiasky.util.i18n.I18n;
import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class JsonLoader
extends AbstractSceneLoader {
    private static final Logger.Log logger = Logger.getLogger(JsonLoader.class);
    private static final String COMPONENTS_PACKAGE = "gaiasky.scene.record.";
    private static final List<String> PARAM_SKIP = Arrays.asList("args", "impl", "archetype", "comment", "comments");
    private static final Map<String, String> REPLACE = new HashMap<String, String>();
    private static final AttributeMap attributeMap;

    public JsonLoader(Map<String, Entity> index) {
        this.index = index;
    }

    public JsonLoader() {
        this(null);
    }

    private static String replace(String key) {
        if (REPLACE.containsKey(key)) {
            return REPLACE.get(key);
        }
        return key;
    }

    @Override
    public Array<Entity> loadData() throws FileNotFoundException {
        int processed;
        int count;
        JsonValue child;
        Array loadedEntities = new Array();
        Array filePaths = new Array((Object[])this.filePaths);
        Array updates = new Array();
        Array updateFiles = new Array();
        JsonReader json = new JsonReader();
        for (String filePath : filePaths) {
            FileHandle file = Settings.settings.data.dataFileHandle(filePath, this.datasetDirectory);
            JsonValue root = json.parse(file.read());
            if (root.has("objects")) {
                child = root.get((String)"objects").child;
                count = root.get((String)"objects").size;
                processed = 0;
                int loaded = 0;
                while (child != null) {
                    ++processed;
                    String archetypeName = child.has("archetype") ? child.getString("archetype") : child.getString("impl");
                    archetypeName = archetypeName.replace("gaia.cu9.ari.gaiaorbit", "gaiasky");
                    if (!this.scene.archetypes().contains(archetypeName)) {
                        if (!this.loggedArchetypes.contains(archetypeName)) {
                            logger.warn("Skipping " + TextUtils.classSimpleName(archetypeName) + ": no suitable archetype found.");
                            this.loggedArchetypes.add(archetypeName);
                        }
                    } else {
                        ++loaded;
                        Archetype archetype = this.scene.archetypes().get(archetypeName);
                        Entity entity = archetype.createEntity();
                        try {
                            this.fillEntity(child, entity, TextUtils.classSimpleName(archetypeName), false);
                            loadedEntities.add((Object)entity);
                            this.addToIndex(entity);
                        }
                        catch (ReflectionException e) {
                            logger.error(e);
                        }
                    }
                    child = child.next;
                    EventManager.publish(Event.UPDATE_LOAD_PROGRESS, this, file.name(), Float.valueOf((float)processed / (float)count));
                }
                EventManager.publish(Event.UPDATE_LOAD_PROGRESS, this, file.name(), Float.valueOf(2.0f));
                logger.info(I18n.msg("notif.nodeloader", loaded, filePath));
                continue;
            }
            if (!root.has("updates")) continue;
            updates.add((Object)root);
            updateFiles.add((Object)file);
        }
        int i = 0;
        for (JsonValue model : updates) {
            FileHandle file = (FileHandle)updateFiles.get(i);
            child = model.get((String)"updates").child;
            count = model.get((String)"updates").size;
            processed = 0;
            while (child != null) {
                String name = child.getString("name");
                if (name != null) {
                    String nameLowerCase = name.toLowerCase(Locale.ROOT).trim();
                    if (this.index.containsKey(nameLowerCase)) {
                        Entity entity = (Entity)this.index.get(nameLowerCase);
                        if (entity != null) {
                            try {
                                Archetype archetype = this.scene.archetypes().findArchetype(entity);
                                this.fillEntity(child, entity, archetype.getName(), true);
                            }
                            catch (ReflectionException e) {
                                logger.error(e);
                            }
                        } else {
                            logger.warn("Entity retrieved from index is null: " + nameLowerCase);
                        }
                    } else {
                        logger.warn("Update name not found in index: " + nameLowerCase);
                    }
                } else {
                    logger.warn("Update element does not contain a name attribute: " + file.name());
                }
                child = child.next;
                EventManager.publish(Event.UPDATE_LOAD_PROGRESS, this, file.name(), Float.valueOf((float)processed / (float)count));
            }
            ++i;
        }
        return loadedEntities;
    }

    private void addToIndex(Entity entity) {
        Base base = (Base)Mapper.base.get(entity);
        String name = base.getName().toLowerCase(Locale.ROOT).trim();
        if (!this.index.containsKey(name)) {
            this.index.put(name, entity);
        }
    }

    public void processJson(JsonValue json, Functions.Function3<Class<?>, Object, JsonValue, Boolean> function) throws ReflectionException {
        JsonValue attribute = json.child;
        while (attribute != null) {
            block17: {
                Object value;
                Class<Map> valueClass;
                block19: {
                    block20: {
                        block18: {
                            if (PARAM_SKIP.contains(attribute.name)) break block17;
                            valueClass = null;
                            value = null;
                            if (!attribute.isValue()) break block18;
                            valueClass = this.getValueClass(attribute);
                            value = this.getValue(attribute);
                            if (value instanceof String) {
                                value = ((String)value).replace("gaia.cu9.ari.gaiaorbit", "gaiasky");
                            }
                            break block19;
                        }
                        if (!attribute.isArray()) break block20;
                        switch (attribute.child.type()) {
                            case stringValue: {
                                valueClass = String[].class;
                                value = attribute.asStringArray();
                                break;
                            }
                            case doubleValue: {
                                valueClass = double[].class;
                                value = attribute.asDoubleArray();
                                break;
                            }
                            case booleanValue: {
                                valueClass = boolean[].class;
                                value = attribute.asBooleanArray();
                                break;
                            }
                            case longValue: {
                                valueClass = int[].class;
                                value = attribute.asIntArray();
                                break;
                            }
                            case object: {
                                valueClass = Object[].class;
                                value = new Object[attribute.size];
                                JsonValue vectorAttribute = attribute.child;
                                int i = 0;
                                while (vectorAttribute != null) {
                                    String clazzName = vectorAttribute.getString("impl").replace("gaia.cu9.ari.gaiaorbit", "gaiasky");
                                    clazzName = JsonLoader.replace(clazzName);
                                    Class childClazz = ClassReflection.forName((String)clazzName);
                                    ((Object[])value)[i] = this.convertJsonToObject(vectorAttribute, childClazz);
                                    ++i;
                                    vectorAttribute = vectorAttribute.next;
                                }
                                break block19;
                            }
                            case array: {
                                Pair<Object, Class> p = this.toMultidimDoubleArray(attribute);
                                value = p.getFirst();
                                valueClass = p.getSecond();
                                break;
                            }
                        }
                        break block19;
                    }
                    if (attribute.isObject()) {
                        Object clazzName = attribute.has("impl") ? attribute.getString("impl") : COMPONENTS_PACKAGE + TextUtils.capitalise(attribute.name) + "Component";
                        clazzName = ((String)clazzName).replace("gaia.cu9.ari.gaiaorbit", "gaiasky");
                        try {
                            valueClass = ClassReflection.forName((String)clazzName);
                            value = this.convertJsonToObject(attribute, valueClass);
                        }
                        catch (Exception e1) {
                            try {
                                valueClass = Map.class;
                                value = this.convertJsonToMap(attribute);
                            }
                            catch (Exception e2) {
                                logger.error("Could not convert attribute to value, object or map: " + String.valueOf(attribute));
                            }
                        }
                    }
                }
                if (function != null && !function.apply(valueClass, value, attribute).booleanValue()) {
                    logger.error("Failed to apply function to JSON attribute: " + String.valueOf(attribute));
                }
            }
            attribute = attribute.next;
        }
    }

    public void fillEntity(JsonValue json, Entity entity, String className, boolean update) throws ReflectionException {
        this.processJson(json, (valueClass, value, attribute) -> {
            try {
                if (update && attribute.name.equalsIgnoreCase("name")) {
                    return true;
                }
                String key = this.findAttribute(attribute.name, className);
                if (key != null) {
                    Class<? extends Component> componentClass = attributeMap.get(key);
                    Component comp = entity.getComponent(componentClass);
                    if (comp != null) {
                        if (update) {
                            if (!this.update((JsonValue)attribute, comp, value, (Class<?>)valueClass, componentClass)) {
                                logger.error("Update operation failed (unsupported?) for attribute: " + attribute.name);
                            }
                        } else if (!this.set((JsonValue)attribute, comp, value, (Class<?>)valueClass, componentClass)) {
                            boolean succeed = this.set(comp, attribute.name, value);
                            if (!succeed) {
                                logger.error("Could not set attribute " + attribute.name + " (" + valueClass.getName() + ") in class " + String.valueOf(componentClass) + " or its superclass/interfaces.");
                            }
                            return succeed;
                        }
                    } else {
                        logger.error("Error, component of class " + String.valueOf(componentClass) + " is null: " + json.name);
                        return false;
                    }
                    return true;
                }
                if (Mapper.base.has(entity)) {
                    Base base = (Base)Mapper.base.get(entity);
                    base.addExtraAttribute(attribute.name, value);
                    return true;
                }
                logger.warn("Component not found for attribute '" + attribute.name + "' and class '" + className + "'");
                return false;
            }
            catch (Exception e) {
                logger.error(e);
                return false;
            }
        });
        logger.debug(I18n.msg("notif.loading", className + ": " + ((Base)entity.getComponent(Base.class)).names[0]));
    }

    public String findAttribute(String attributeName, String className) {
        String mixedKey = attributeName + ":" + className;
        if (attributeMap.containsKey(mixedKey)) {
            return mixedKey;
        }
        if (attributeMap.containsKey(attributeName)) {
            return attributeName;
        }
        return null;
    }

    private Object convertJsonToObject(JsonValue json, Class<?> clazz) throws ReflectionException {
        Object instance;
        try {
            if (json.has("args")) {
                JsonValue args = json.get("args");
                Class[] argumentTypes = new Class[args.size];
                Object[] arguments = new Object[args.size];
                for (int i = 0; i < args.size; ++i) {
                    JsonValue arg = args.get(i);
                    argumentTypes[i] = this.getValueClass(arg);
                    arguments[i] = this.getValue(arg);
                }
                Constructor constructor = ClassReflection.getConstructor(clazz, (Class[])argumentTypes);
                instance = constructor.newInstance(arguments);
            } else {
                instance = ClassReflection.newInstance(clazz);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate class: " + e.getMessage());
        }
        if (instance != null) {
            this.processJson(json, (valueClass, value, attribute) -> this.set((JsonValue)attribute, instance, value, (Class<?>)valueClass, clazz));
        } else {
            logger.error("Error, instance is null: " + json.name);
        }
        return instance;
    }

    public boolean set(Object instance, String fieldName, Object fieldValue) throws IllegalStateException {
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                field.set(instance, fieldValue);
                return true;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private boolean set(JsonValue attribute, Object instance, Object value, Class<?> valueClass, Class<?> instanceClass) {
        String methodName = "set" + TextUtils.propertyToMethodName(attribute.name);
        Method m = this.searchMethod(methodName, valueClass, instanceClass);
        if (m != null) {
            try {
                m.invoke(instance, new Object[]{value});
            }
            catch (ReflectionException e) {
                logger.error(e);
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean update(JsonValue attribute, Object instance, Object value, Class<?> valueClass, Class<?> instanceClass) {
        String methodName = "update" + TextUtils.propertyToMethodName(attribute.name);
        Method m = this.searchMethod(methodName, valueClass, instanceClass);
        if (m != null) {
            try {
                m.invoke(instance, new Object[]{value});
            }
            catch (ReflectionException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
        return false;
    }

    private Method searchMethod(String methodName, Class<?> parameterType, Class<?> source) {
        Method m = null;
        try {
            m = ClassReflection.getMethod(source, (String)methodName, (Class[])new Class[]{parameterType});
        }
        catch (ReflectionException e) {
            try {
                if (methodName.contains("setCoordinates")) {
                    m = ClassReflection.getMethod(source, (String)methodName, (Class[])new Class[]{IBodyCoordinates.class});
                }
            }
            catch (ReflectionException reflectionException) {
                // empty catch block
            }
        }
        return m;
    }

    private Object getValue(JsonValue val) {
        Object[] value = null;
        switch (val.type()) {
            case stringValue: {
                value = val.asString();
                break;
            }
            case doubleValue: {
                value = val.asDouble();
                break;
            }
            case booleanValue: {
                value = val.asBoolean();
                break;
            }
            case longValue: {
                value = val.asLong();
                break;
            }
            case array: {
                try {
                    value = val.asDoubleArray();
                }
                catch (IllegalStateException e1) {
                    try {
                        value = val.asFloatArray();
                    }
                    catch (IllegalStateException e2) {
                        try {
                            value = val.asLongArray();
                        }
                        catch (IllegalStateException e3) {
                            try {
                                value = val.asIntArray();
                            }
                            catch (IllegalStateException e4) {
                                try {
                                    value = val.asStringArray();
                                }
                                catch (IllegalStateException e5) {
                                    try {
                                        value = val.asCharArray();
                                    }
                                    catch (IllegalStateException illegalStateException) {}
                                }
                            }
                        }
                    }
                }
                break;
            }
        }
        return value;
    }

    private Class<?> getValueClass(JsonValue val) {
        Class valueClass = null;
        switch (val.type()) {
            case stringValue: {
                valueClass = String.class;
                break;
            }
            case doubleValue: {
                valueClass = Double.class;
                break;
            }
            case booleanValue: {
                valueClass = Boolean.class;
                break;
            }
            case longValue: {
                valueClass = Long.class;
                break;
            }
        }
        return valueClass;
    }

    public int depth(JsonValue attribute) {
        int d = 1;
        if (attribute.child != null) {
            return d + this.depth(attribute.child);
        }
        return d;
    }

    public Pair<Object, Class> toMultidimDoubleArray(JsonValue attribute) {
        int dim = this.depth(attribute) - 1;
        switch (dim) {
            case 1: {
                return this.to1DoubleArray(attribute);
            }
            case 2: {
                return this.to2DoubleArray(attribute);
            }
            case 3: {
                return this.to3DoubleArray(attribute);
            }
        }
        logger.error("Double arrays of dimension " + dim + " not supported: attribute \"" + attribute.name + "\"");
        return null;
    }

    public Pair<Object, Class> to1DoubleArray(JsonValue attribute) {
        return new Pair<Object, Class>(attribute.asDouble(), double[].class);
    }

    public Pair<Object, Class> to2DoubleArray(JsonValue attribute) {
        JsonValue json = attribute.child;
        int size = attribute.size;
        double[][] result = new double[size][];
        int i = 0;
        do {
            result[i] = json.asDoubleArray();
            json = json.next();
            ++i;
        } while (json != null);
        return new Pair<double[][], Class<double[][]>>(result, double[][].class);
    }

    public Pair<Object, Class> to3DoubleArray(JsonValue attribute) {
        JsonValue json = attribute.child;
        int size = attribute.size;
        double[][][] result = new double[size][][];
        int i = 0;
        do {
            double[][] l1 = new double[json.size][];
            JsonValue child = json.child;
            int j = 0;
            do {
                double[] l2 = child.asDoubleArray();
                l1[j] = l2;
                child = child.next();
                ++j;
            } while (child != null);
            result[i] = l1;
            json = json.next();
            ++i;
        } while (json != null);
        return new Pair<double[][][], Class<double[][][]>>(result, double[][][].class);
    }

    public Map<String, Object> convertJsonToMap(JsonValue json) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        JsonValue child = json.child;
        while (child != null) {
            Object val = this.getValue(child);
            if (val != null) {
                map.put(child.name, val);
            }
            child = child.next;
        }
        return map;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public void setDescription(String description) {
    }

    @Override
    public void setParams(Map<String, Object> params) {
    }

    static {
        REPLACE.put("gaiasky.scenegraph.MachineDefinition", MachineDefinition.class.getName());
        REPLACE.put("gaiasky.scenegraph.particle.BillboardDataset", BillboardDataset.class.getName());
        REPLACE.put("gaiasky.scenegraph.component.RotateTransform", RotateTransform.class.getName());
        attributeMap = new AttributeMap();
        attributeMap.initialize();
    }
}

