/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.TimeUtils;
import gaiasky.GaiaSky;
import gaiasky.data.AbstractSceneLoader;
import gaiasky.data.api.IOctantLoader;
import gaiasky.data.group.BinaryDataProvider;
import gaiasky.data.group.MetadataBinaryIO;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.scene.Archetype;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.DatasetDescription;
import gaiasky.scene.component.Fade;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Octant;
import gaiasky.scene.component.Octree;
import gaiasky.scene.component.StarSet;
import gaiasky.scene.component.tag.TagOctreeObject;
import gaiasky.scene.entity.SetUtils;
import gaiasky.scene.system.initialize.BaseInitializer;
import gaiasky.scene.system.initialize.ParticleSetInitializer;
import gaiasky.scene.system.initialize.SceneGraphBuilderSystem;
import gaiasky.scene.view.OctreeObjectView;
import gaiasky.util.CatalogInfo;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.concurrent.ServiceThread;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.tree.IOctreeObject;
import gaiasky.util.tree.LoadStatus;
import gaiasky.util.tree.OctreeNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jafama.FastMath;

public class OctreeLoader
extends AbstractSceneLoader
implements IObserver,
IOctantLoader {
    protected static final int PRELOAD_DEPTH = 3;
    protected static final int LOAD_QUEUE_MAX_SIZE = 100;
    protected static final long MIN_QUEUE_CLEAR_MS = 2000L;
    protected static final int MAX_LOAD_CHUNK = 5;
    private static final Logger.Log logger = Logger.getLogger(OctreeLoader.class);
    public static OctreeLoader instance;
    protected final long maxLoadedStars;
    private final BinaryDataProvider particleReader;
    protected int nLoadedStars = 0;
    protected Queue<OctreeNode> toLoadQueue;
    protected boolean loadingPaused = false;
    protected long lastQueueClearMs = 0L;
    protected String name;
    protected String description;
    protected Map<String, Object> params;
    protected Queue<OctreeNode> toUnloadQueue;
    protected long[] loadedIds;
    protected int loadedObjects;
    protected int maxLoadedIds;
    protected int idxLoadedIds;
    protected String metadata;
    protected String particles;
    protected OctreeLoaderThread daemon;
    private int dataVersionHint;
    private SceneGraphBuilderSystem sceneGraphBuilder;
    private BaseInitializer baseInitializer;
    private ParticleSetInitializer setInitializer;
    private double epoch = AstroUtils.JD_J2015_5;

    public OctreeLoader() {
        instance = this;
        this.particleReader = new BinaryDataProvider();
        this.maxLoadedStars = Settings.settings.scene.octree.maxStars;
        logger.info("Maximum loaded stars setting: " + this.maxLoadedStars);
        Comparator<OctreeNode> depthComparator = Comparator.comparingInt(o -> o.depth);
        this.toLoadQueue = new PriorityBlockingQueue<OctreeNode>(100, depthComparator);
        this.toUnloadQueue = new ArrayBlockingQueue<OctreeNode>(100);
        this.maxLoadedIds = 50;
        this.idxLoadedIds = 0;
        this.loadedIds = new long[this.maxLoadedIds];
        EventManager.instance.subscribe((IObserver)this, Event.DISPOSE, Event.PAUSE_BACKGROUND_LOADING, Event.RESUME_BACKGROUND_LOADING, Event.CLEAR_OCTANT_QUEUE);
    }

    @Override
    public void initialize(String[] files, String dsLocation, Scene scene) throws RuntimeException {
        super.initialize(files, dsLocation, scene);
        this.initializePrivate();
    }

    @Override
    public void initialize(String[] files, Scene scene) throws RuntimeException {
        super.initialize(files, scene);
        this.initializePrivate();
    }

    private void initializePrivate() {
        if (this.filePaths == null || this.filePaths.length < 2) {
            throw new RuntimeException("Error loading octree files: " + String.valueOf(this.filePaths != null ? Integer.valueOf(this.filePaths.length) : "files array is null"));
        }
        this.particles = this.filePaths[0];
        this.metadata = this.filePaths[1];
        this.sceneGraphBuilder = new SceneGraphBuilderSystem(this.scene.index(), null, 0);
        this.setInitializer = new ParticleSetInitializer(true, null, 0);
        this.baseInitializer = new BaseInitializer(this.scene, true, null, 0);
    }

    protected Entity loadOctreeData() {
        logger.info(I18n.msg("notif.loading", this.metadata));
        MetadataBinaryIO metadataReader = new MetadataBinaryIO();
        OctreeNode rootOctant = metadataReader.readMetadataMapped(this.metadata);
        rootOctant.setOctantLoader(this, true);
        logger.info(I18n.msg("notif.nodeloader", rootOctant.numNodesRec(), this.metadata));
        logger.info(I18n.msg("notif.loading", this.particles));
        Archetype archetype = this.scene.archetypes().get("OctreeWrapper");
        Entity entity = archetype.createEntity();
        String name = this.name != null ? this.name : "LOD data";
        String description = this.description != null ? this.description : "Octree-based LOD dataset";
        CatalogInfo ci = new CatalogInfo(name, description, null, CatalogInfo.CatalogInfoSource.LOD, 1.5f, entity);
        ci.nParticles = this.params.containsKey("nObjects") ? (Long)this.params.get("nObjects") : -1L;
        ci.nParticles = ci.nParticles < 0L && this.params.containsKey("nobjects") ? (Long)this.params.get("nobjects") : -1L;
        ci.sizeBytes = this.params.containsKey("size") ? (Long)this.params.get("size") : -1L;
        Octree octree = (Octree)Mapper.octree.get(entity);
        octree.roulette = new ArrayList<IOctreeObject>(Math.min(10, (int)((double)rootOctant.numObjectsRec * 0.5)));
        Base base = (Base)Mapper.base.get(entity);
        base.setName(name);
        base.opacity = 1.0f;
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        graph.parentName = "Universe";
        Fade fade = (Fade)Mapper.fade.get(entity);
        fade.setFadeout(new double[]{8000.0, 500000.0});
        Octant root = (Octant)Mapper.octant.get(entity);
        root.octant = rootOctant;
        this.dataVersionHint = name.contains("DR2") || name.contains("dr2") || description.contains("DR2") || description.contains("dr2") ? 0 : 1;
        try {
            int depthLevel = FastMath.min((int)OctreeNode.maxDepth, (int)3);
            this.loadLod(depthLevel, entity, true);
            this.flushLoadedIds();
        }
        catch (IOException e) {
            logger.error(e);
        }
        root.octant.updateCounts();
        if (root.octant.numChildrenRec + 1 < 4 && Settings.settings.scene.star.group.numLabels <= 50) {
            long numLabels = FastMath.max((long)Settings.settings.scene.star.group.getMaxNumIndices(), (long)((long)(50.0 / (double)(root.octant.numChildrenRec + 1))));
            this.updateNumLabelsRecursive(root.octant, numLabels);
        }
        return entity;
    }

    private void updateNumLabelsRecursive(OctreeNode octant, long numLabels) {
        if (octant.objects != null && !octant.objects.isEmpty()) {
            for (IOctreeObject sg : octant.objects) {
                if (!(sg instanceof OctreeObjectView)) continue;
                OctreeObjectView oov = (OctreeObjectView)sg;
                if (oov.set == null) continue;
                StarSet set = oov.set;
                float n = MathUtilsDouble.max(new float[]{numLabels, oov.set.numLabels});
                set.updateNumLabelsValue((int)n, oov.getEntity());
            }
        }
        if (octant.children != null) {
            for (int i = 0; i < 8; ++i) {
                if (octant.children[i] == null) continue;
                this.updateNumLabelsRecursive(octant.children[i], numLabels);
            }
        }
    }

    public void setEpoch(Double epoch) {
        this.epoch = AstroUtils.getJulianDate(epoch);
    }

    public void setEpoch(Long epoch) {
        this.epoch = AstroUtils.getJulianDate(epoch.longValue());
    }

    @Override
    public Array<Entity> loadData() {
        Array loadedEntities = new Array();
        Entity octreeWrapper = this.loadOctreeData();
        if (octreeWrapper != null) {
            this.daemon = new OctreeLoaderThread(octreeWrapper, this);
            this.daemon.setDaemon(true);
            this.daemon.setName("gaiasky-new-octreeload");
            this.daemon.setPriority(1);
            this.daemon.start();
            Timer timer = new Timer(true);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    OctreeLoader.this.flushLoadQueue();
                }
            }, 1000L, 1000L);
            Array result = new Array(false, 1);
            result.add((Object)octreeWrapper);
            Octant root = (Octant)Mapper.octant.get(octreeWrapper);
            logger.info(I18n.msg("notif.catalog.init", root.octant.countObjects()));
            loadedEntities.add((Object)octreeWrapper);
        }
        return loadedEntities;
    }

    protected void addLoadedInfo(long id, int nobjects) {
        if (this.idxLoadedIds >= this.maxLoadedIds) {
            this.flushLoadedIds();
        }
        this.loadedIds[this.idxLoadedIds++] = id;
        this.loadedObjects += nobjects;
    }

    protected void flushLoadedIds() {
        if (this.idxLoadedIds > 0) {
            String str = "[" + this.loadedIds[0] + ", ..., " + this.loadedIds[this.idxLoadedIds - 1] + "]";
            logger.info(I18n.msg("notif.octantsloaded", this.loadedObjects, this.idxLoadedIds, str));
            this.idxLoadedIds = 0;
            this.loadedObjects = 0;
        }
    }

    @Override
    public void queue(OctreeNode octant) {
        if (this.daemon != null) {
            this.addToQueue(octant);
        }
    }

    @Override
    public void clearQueue() {
        if (this.daemon != null) {
            if (TimeUtils.millis() - this.lastQueueClearMs > 2000L) {
                this.emptyLoadQueue();
                this.lastQueueClearMs = TimeUtils.millis();
            }
            this.abortCurrentLoading();
        }
    }

    @Override
    public int getLoadQueueSize() {
        if (this.daemon != null) {
            return this.toLoadQueue.size();
        }
        return -1;
    }

    @Override
    public int getNLoadedStars() {
        if (this.daemon != null) {
            return this.nLoadedStars;
        }
        return -1;
    }

    @Override
    public void touch(OctreeNode octant) {
        if (this.daemon != null) {
            this.touchOctant(octant);
        }
    }

    public void emptyLoadQueue() {
        int n = this.toLoadQueue.size();
        if (n > 0) {
            for (OctreeNode octant : this.toLoadQueue) {
                octant.setStatus(LoadStatus.NOT_LOADED);
            }
            this.toLoadQueue.clear();
        }
    }

    public void addToQueue(OctreeNode octant) {
        if (!this.loadingPaused) {
            if (this.toLoadQueue.size() >= 100) {
                OctreeNode out = this.toLoadQueue.poll();
                out.setStatus(LoadStatus.NOT_LOADED);
            }
            this.toLoadQueue.add(octant);
            octant.setStatus(LoadStatus.QUEUED);
        }
    }

    public void touchOctant(OctreeNode octant) {
        this.toUnloadQueue.remove(octant);
        if (octant.depth > 3) {
            this.toUnloadQueue.offer(octant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushLoadQueue() {
        if (!(this.daemon.isAwake() || this.toLoadQueue.isEmpty() || this.loadingPaused)) {
            Object object = this.daemon.getThreadLock();
            synchronized (object) {
                EventManager.publish(Event.BACKGROUND_LOADING_INFO, this, new Object[0]);
                this.daemon.getThreadLock().notifyAll();
            }
        }
    }

    public void abortCurrentLoading() {
        this.daemon.abort();
    }

    public void loadLod(Integer lod, Entity octreeWrapper, boolean immediate) throws IOException {
        Octant root = (Octant)Mapper.octant.get(octreeWrapper);
        this.loadOctant(root.octant, octreeWrapper, lod, immediate);
    }

    public void loadOctant(OctreeNode octant, Entity octreeWrapper, Integer level, boolean immediate) {
        if (level >= 0) {
            this.loadOctant(octant, octreeWrapper, true, immediate);
            if (octant.children != null) {
                for (OctreeNode child : octant.children) {
                    if (child == null || child.numObjectsRec <= 0) continue;
                    this.loadOctant(child, octreeWrapper, level - 1, immediate);
                }
            }
        }
    }

    public void loadOctants(Array<OctreeNode> octants, Entity octreeWrapper, boolean immediate, AtomicBoolean abort) {
        if (octants.size > 0) {
            int i = 0;
            OctreeNode octant = (OctreeNode)octants.get(0);
            while (i < octants.size && !abort.get()) {
                if (!this.loadOctant(octant, octreeWrapper, true, immediate)) {
                    logger.warn("Octant not loaded: " + octant.pageId);
                }
                octant = (OctreeNode)octants.get(++i);
            }
            this.flushLoadedIds();
            if (abort.get()) {
                for (int j = i; j < octants.size; ++j) {
                    ((OctreeNode)octants.get(j)).setStatus(LoadStatus.NOT_LOADED);
                }
            }
        }
    }

    public boolean loadOctant(OctreeNode octant, Entity octreeWrapper, boolean fullInit, boolean immediate) {
        FileHandle octantFile = Settings.settings.data.dataFileHandle(this.particles + "particles_" + String.format("%06d", octant.pageId) + ".bin");
        if (!octantFile.exists() || octantFile.isDirectory()) {
            return false;
        }
        DatasetDescription datasetDesc = (DatasetDescription)Mapper.datasetDescription.get(octreeWrapper);
        Octree octree = (Octree)Mapper.octree.get(octreeWrapper);
        List<IParticleRecord> data = this.particleReader.loadDataMapped(octantFile.path(), 1.0, this.dataVersionHint);
        Entity sg = SetUtils.createStarSet(this.scene, "stargroup-%%SGID%%", data, this.baseInitializer, this.setInitializer, fullInit);
        sg.add((Component)new TagOctreeObject());
        StarSet set = (StarSet)Mapper.starSet.get(sg);
        set.setEpoch(this.epoch);
        DatasetDescription sgDatasetDesc = (DatasetDescription)Mapper.datasetDescription.get(sg);
        sgDatasetDesc.setCatalogInfoBare(datasetDesc.catalogInfo);
        Octant sgOctant = (Octant)Mapper.octant.get(sg);
        Runnable populate = () -> {
            OctreeNode octreeNode = octant;
            synchronized (octreeNode) {
                sgOctant.octant = octant;
                this.sceneGraphBuilder.add(octreeWrapper, sg);
                octree.parenthood.put(sg, octant);
                if (this.scene.index() != null) {
                    this.scene.index().addToIndex(sg);
                    this.scene.index().addToHipMap(sg);
                }
                this.nLoadedStars += set.pointData.size();
                octant.add(new OctreeObjectView(sg));
                this.touch(octant);
                octant.setStatus(LoadStatus.LOADED);
                octant.updateCountsWithNumber(data.size());
                this.addLoadedInfo(octant.pageId, octant.countObjects());
            }
        };
        if (immediate) {
            populate.run();
        } else {
            GaiaSky.postRunnable(populate);
        }
        return true;
    }

    public void unloadOctant(OctreeNode octant, Entity octreeWrapper) {
        List<IOctreeObject> objects = octant.objects;
        if (objects != null) {
            GaiaSky.postRunnable(() -> {
                OctreeNode octreeNode = octant;
                synchronized (octreeNode) {
                    try {
                        int unloaded = 0;
                        Octree octree = (Octree)Mapper.octree.get(octreeWrapper);
                        for (IOctreeObject octreeObject : objects) {
                            OctreeObjectView object = (OctreeObjectView)octreeObject;
                            int count = object.getStarCount();
                            object.dispose();
                            object.setOctant(null);
                            octree.removeParenthood(object.getEntity());
                            if (GaiaSky.instance != null && GaiaSky.instance.scene != null) {
                                GaiaSky.instance.scene.index().remove(object.getEntity());
                            }
                            this.nLoadedStars -= count;
                            unloaded += count;
                        }
                        objects.clear();
                        octant.setStatus(LoadStatus.NOT_LOADED);
                        octant.updateCountsWithNumber(unloaded);
                    }
                    catch (Exception e) {
                        logger.error("Error disposing octant's objects " + octant.pageId, e);
                        logger.info(Settings.APPLICATION_NAME + " will attempt to continue");
                    }
                }
            });
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case PAUSE_BACKGROUND_LOADING: {
                this.loadingPaused = true;
                this.clearQueue();
                logger.info("Background data loading thread paused");
                break;
            }
            case RESUME_BACKGROUND_LOADING: {
                this.loadingPaused = false;
                this.clearQueue();
                logger.info("Background data loading thread resumed");
                break;
            }
            case CLEAR_OCTANT_QUEUE: {
                this.clearQueue();
                break;
            }
            case DISPOSE: {
                if (this.daemon == null) break;
                this.daemon.stopDaemon(false);
                break;
            }
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    protected static class OctreeLoaderThread
    extends ServiceThread {
        private final Entity octreeWrapper;
        private final Array<OctreeNode> toLoad;
        private final AtomicBoolean abort;

        public OctreeLoaderThread(Entity aow, OctreeLoader loader) {
            this.octreeWrapper = aow;
            this.toLoad = new Array();
            this.abort = new AtomicBoolean(false);
            this.task = () -> {
                while (!loader.toLoadQueue.isEmpty()) {
                    this.toLoad.clear();
                    for (int i = 0; loader.toLoadQueue.peek() != null && i <= 5; ++i) {
                        OctreeNode octant = loader.toLoadQueue.poll();
                        this.toLoad.add((Object)octant);
                    }
                    if (this.toLoad.size > 0) {
                        try {
                            loader.loadOctants(this.toLoad, this.octreeWrapper, false, this.abort);
                        }
                        catch (Exception e) {
                            logger.debug(I18n.msg("notif.loadingoctants.queue.clear"));
                        }
                    }
                    int nUnloaded = 0;
                    int nStars = loader.nLoadedStars;
                    if (this.running.get() && (long)nStars >= loader.maxLoadedStars) {
                        OctreeNode octant;
                        do {
                            if ((octant = loader.toUnloadQueue.poll()) == null || octant.objects == null || octant.getStatus() != LoadStatus.LOADED) continue;
                            loader.unloadOctant(octant, this.octreeWrapper);
                        } while (octant == null || octant.objects == null || octant.objects.isEmpty() || !((double)(nStars - (nUnloaded += octant.objects.getFirst().getStarCount())) < (double)loader.maxLoadedStars * 0.85));
                    }
                    GaiaSky.postRunnable(() -> EventManager.publish(Event.CONSTELLATION_UPDATE_CMD, this, GaiaSky.instance.scene));
                }
                this.abort.set(false);
            };
        }

        public void abort() {
            this.abort.set(true);
        }
    }
}

