/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.data.api.IOrbitDataProvider;
import gaiasky.data.util.OrbitDataLoader;
import gaiasky.data.util.PointCloudData;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Trajectory;
import gaiasky.scene.component.Verts;
import gaiasky.scene.entity.TrajectoryUtils;
import gaiasky.scene.view.VertsView;
import gaiasky.util.Logger;
import gaiasky.util.concurrent.ServiceThread;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

public class OrbitRefresher
implements IObserver {
    protected static final int MAX_LOAD_CHUNK = 5;
    private static final Logger.Log logger = Logger.getLogger(OrbitRefresher.class);
    private static final int LOAD_QUEUE_MAX_SIZE = 15;
    private final Queue<OrbitDataLoader.OrbitDataLoaderParameters> toLoadQueue = new ArrayBlockingQueue<OrbitDataLoader.OrbitDataLoaderParameters>(15);
    private final OrbitUpdaterThread daemon;
    private final TrajectoryUtils utils;

    public OrbitRefresher(String threadName, TrajectoryUtils utils) {
        this.utils = utils;
        this.daemon = new OrbitUpdaterThread(this);
        this.daemon.setDaemon(true);
        this.daemon.setName(threadName);
        this.daemon.setPriority(1);
        this.daemon.start();
        EventManager.instance.subscribe((IObserver)this, Event.DISPOSE, Event.ORBIT_REFRESH_CMD);
    }

    public void queue(OrbitDataLoader.OrbitDataLoaderParameters params) {
        boolean loadingPaused = false;
        if (!loadingPaused && this.toLoadQueue.size() < 14) {
            this.toLoadQueue.remove((Object)params);
            this.toLoadQueue.add(params);
            if (params.entity != null) {
                ((Trajectory)Mapper.trajectory.get((Entity)params.entity)).refreshing = true;
            }
            this.daemon.wakeUp();
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.DISPOSE && this.daemon != null) {
            this.daemon.stopDaemon(false);
        } else if (event == Event.ORBIT_REFRESH_CMD && this.utils != null) {
            Entity entity = (Entity)data[0];
            Trajectory trajectory = (Trajectory)Mapper.trajectory.get(entity);
            Verts verts = (Verts)Mapper.verts.get(entity);
            this.utils.refreshOrbit(trajectory, verts, true);
        }
    }

    protected static class OrbitUpdaterThread
    extends ServiceThread {
        private final Array<OrbitDataLoader.OrbitDataLoaderParameters> toLoad;
        private final TrajectoryUtils utils = new TrajectoryUtils();

        public OrbitUpdaterThread(OrbitRefresher orbitRefresher) {
            this.toLoad = new Array();
            this.task = () -> {
                while (!orbitRefresher.toLoadQueue.isEmpty()) {
                    this.toLoad.clear();
                    for (int i = 0; orbitRefresher.toLoadQueue.peek() != null && i <= 5; ++i) {
                        OrbitDataLoader.OrbitDataLoaderParameters param = orbitRefresher.toLoadQueue.poll();
                        this.toLoad.add((Object)param);
                    }
                    if (this.toLoad.size <= 0) continue;
                    for (OrbitDataLoader.OrbitDataLoaderParameters params : this.toLoad) {
                        if (params.entity == null) continue;
                        Entity entity = params.entity;
                        Trajectory trajectory = (Trajectory)Mapper.trajectory.get(entity);
                        try {
                            if (trajectory == null) continue;
                            IOrbitDataProvider objectProvider = trajectory.providerInstance;
                            IOrbitDataProvider currentProvider = Mapper.tagHeliotropic.has(entity) ? objectProvider : objectProvider;
                            currentProvider.load(trajectory.oc.source, params);
                            PointCloudData pcd = currentProvider.getData();
                            GaiaSky.postRunnable(() -> {
                                VertsView vertsView = new VertsView(entity);
                                Body body = (Body)Mapper.body.get(entity);
                                Verts verts = (Verts)Mapper.verts.get(entity);
                                verts.pointCloudData = pcd;
                                this.utils.initOrbitMetadata(body, trajectory, verts);
                                vertsView.markForUpdate();
                                trajectory.refreshing = false;
                            });
                        }
                        catch (Exception e) {
                            trajectory.refreshing = false;
                            logger.debug("Refreshing orbits operation failed.");
                        }
                    }
                }
            };
        }
    }
}

