/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Constructor;
import com.badlogic.gdx.utils.reflect.Method;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import gaiasky.data.JsonLoader;
import gaiasky.data.api.ISceneLoader;
import gaiasky.scene.Scene;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.TextUtils;
import gaiasky.util.coord.IBodyCoordinates;
import gaiasky.util.i18n.I18n;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class SceneJsonLoader {
    private static final Logger.Log logger = Logger.getLogger(SceneJsonLoader.class);
    private static final Map<String, Entity> globalIndex = new HashMap<String, Entity>();

    public static synchronized void loadScene(FileHandle[] jsonFiles, Scene scene) throws FileNotFoundException, ReflectionException {
        logger.info(I18n.msg("notif.loading", I18n.msg("gui.data.json.metadata.files")));
        for (FileHandle fh : jsonFiles) {
            logger.debug(I18n.msg("notif.file.exists", fh.path(), I18n.msg("gui." + fh.exists())));
            if (fh.exists()) continue;
            logger.error(I18n.msg("error.loading.notexistent", fh.path()));
        }
        Array loadedEntities = new Array();
        for (FileHandle jsonFile : jsonFiles) {
            loadedEntities.addAll(SceneJsonLoader.loadJsonFile(jsonFile, scene));
        }
        loadedEntities.forEach(arg_0 -> ((Engine)scene.engine).addEntity(arg_0));
        scene.initializeEntities();
        scene.initializeIndex();
        scene.buildSceneGraph();
    }

    public static synchronized Array<Entity> loadJsonFile(FileHandle jsonFile, Scene scene) throws ReflectionException, FileNotFoundException {
        String datasetDirectory;
        JsonLoader jsonLoader = new JsonLoader();
        Array loadedEntities = new Array();
        JsonReader jsonReader = new JsonReader();
        JsonValue model = jsonReader.parse(jsonFile.read());
        Path dataLocation = Path.of(Settings.settings.data.location, new String[0]);
        Path parent = jsonFile.file().toPath().getParent();
        String string = datasetDirectory = dataLocation.toAbsolutePath().compareTo(parent.toAbsolutePath()) == 0 ? null : parent.getFileName().toString();
        if (model.has("data")) {
            String name = model.get("name") != null ? model.get("name").asString() : null;
            String desc = model.get("description") != null ? model.get("description").asString() : null;
            Long size = model.get("size") != null ? model.get("size").asLong() : -1L;
            Long nObjects = model.get("nobjects") != null ? model.get("nobjects").asLong() : -1L;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("size", size);
            params.put("nobjects", nObjects);
            JsonValue child = model.get((String)"data").child;
            while (child != null) {
                String clazzName = child.getString("loader").replace("gaia.cu9.ari.gaiaorbit", "gaiasky");
                Class clazz = ClassReflection.forName((String)clazzName);
                JsonValue filesJson = child.get("files");
                if (filesJson != null) {
                    String[] files = filesJson.asStringArray();
                    Constructor c = ClassReflection.getConstructor((Class)clazz, (Class[])new Class[0]);
                    ISceneLoader loader = (ISceneLoader)c.newInstance(new Object[0]);
                    loader.setIndex(globalIndex);
                    if (name != null) {
                        loader.setName(name);
                    }
                    if (desc != null) {
                        loader.setDescription(desc);
                    }
                    if (!params.isEmpty()) {
                        loader.setParams(params);
                    }
                    if (child.has("params")) {
                        Map<String, Object> parameterMap = jsonLoader.convertJsonToMap(child.get("params"));
                        loader.setParams(parameterMap);
                    }
                    loader.initialize(files, datasetDirectory, scene);
                    JsonValue curr = filesJson;
                    while (curr.next != null) {
                        curr = curr.next;
                        String nameAttr = curr.name;
                        Object val = null;
                        Class valueClass = null;
                        if (curr.isDouble()) {
                            val = curr.asDouble();
                            valueClass = Double.class;
                        } else if (curr.isString()) {
                            val = curr.asString();
                            valueClass = String.class;
                        } else if (curr.isNumber()) {
                            val = curr.asLong();
                            valueClass = Long.class;
                        }
                        if (val == null) continue;
                        String methodName = "set" + TextUtils.propertyToMethodName(nameAttr);
                        Method m = SceneJsonLoader.searchMethod(methodName, valueClass, clazz);
                        if (m != null) {
                            m.invoke((Object)loader, new Object[]{val});
                            continue;
                        }
                        logger.error("ERROR: No method " + methodName + "(" + valueClass.getName() + ") in class " + String.valueOf(clazz) + " or its superclass/interfaces.");
                    }
                    Array<Entity> data = loader.loadData();
                    loadedEntities.addAll(data);
                }
                child = child.next;
            }
        } else {
            JsonLoader loader = new JsonLoader(globalIndex);
            loader.initialize(new String[]{jsonFile.file().getAbsolutePath()}, scene);
            Array<Entity> data = loader.loadData();
            loadedEntities.addAll(data);
        }
        return loadedEntities;
    }

    private static Method searchMethod(String methodName, Class<?> clazz, Class<?> source) {
        Method m = null;
        try {
            m = ClassReflection.getMethod(source, (String)methodName, (Class[])new Class[]{clazz});
        }
        catch (ReflectionException e) {
            try {
                if (methodName.contains("setCoordinates")) {
                    m = ClassReflection.getMethod(source, (String)methodName, (Class[])new Class[]{IBodyCoordinates.class});
                }
            }
            catch (ReflectionException e1) {
                logger.error(e1);
            }
        }
        return m;
    }
}

