/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import gaiasky.data.AbstractSceneLoader;
import gaiasky.scene.Archetype;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Cluster;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.ProperMotion;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Quadruple;
import gaiasky.util.math.Vector2D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.parse.Parser;
import gaiasky.util.ucd.UCDParser;
import gaiasky.util.units.Quantity;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.jafama.FastMath;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.formats.AsciiTableBuilder;
import uk.ac.starlink.table.formats.CsvTableBuilder;
import uk.ac.starlink.util.DataSource;

@Deprecated
public class StarClusterLoader
extends AbstractSceneLoader {
    private static final Logger.Log logger = Logger.getLogger(StarClusterLoader.class);
    boolean active = true;
    private Archetype archetype;
    private int numLoaded = 0;
    private final float[] clusterColor = new float[]{0.93f, 0.93f, 0.3f, 1.0f};
    private Array<Entity> clusters;

    public void setColor(double[] clusterColor) {
        this.clusterColor[0] = (float)clusterColor[0];
        this.clusterColor[1] = (float)clusterColor[1];
        this.clusterColor[2] = (float)clusterColor[2];
        this.clusterColor[3] = clusterColor.length > 3 ? (float)clusterColor[3] : 1.0f;
    }

    @Override
    public Array<Entity> loadData() {
        this.clusters = new Array();
        this.archetype = this.scene.archetypes().get("gaiasky.scenegraph.StarCluster");
        if (this.active) {
            this.numLoaded = 0;
            if (this.filePaths != null) {
                for (String file : this.filePaths) {
                    FileHandle f = Settings.settings.data.dataFileHandle(file);
                    try (InputStream is = f.read();){
                        try {
                            this.loadClustersCsv(is, this.clusters);
                        }
                        catch (IOException e) {
                            logger.error(e);
                        }
                    }
                    catch (IOException e) {
                        logger.error(e);
                    }
                }
            } else if (this.dataSource != null) {
                try {
                    this.loadClustersStil(this.dataSource, this.clusters);
                }
                catch (IOException e) {
                    logger.error(e);
                }
            }
        }
        logger.info(I18n.msg("notif.catalog.init", this.numLoaded));
        return this.clusters;
    }

    public Array<Entity> getClusters() {
        return this.clusters;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public void setDescription(String description) {
    }

    @Override
    public void setParams(Map<String, Object> params) {
        Object col;
        if (params.containsKey("color") && (col = params.get("color")).getClass().isArray()) {
            double[] color = (double[])col;
            this.setColor(color);
        }
    }

    private void loadClustersStil(DataSource ds, Array<Entity> list) throws IOException {
        StarTableFactory factory = new StarTableFactory();
        List builders = factory.getDefaultBuilders();
        builders.add(new CsvTableBuilder());
        builders.add(new AsciiTableBuilder());
        StarTable table = factory.makeStarTable(ds);
        Map<ClusterProperties, Integer> indices = this.parseHeader(table);
        if (!this.checkIndices(indices)) {
            logger.error("At least 'ra', 'dec', 'pllx'|'parallax', 'dist'|'distance', 'radius' and 'name' are needed, please check your columns!");
            return;
        }
        RowSequence rs = table.getRowSequence();
        while (rs.next()) {
            Object[] row = rs.getRow();
            String[] names = this.parseName(row[indices.get((Object)ClusterProperties.NAME)].toString());
            double ra = this.getDouble(row, ClusterProperties.RA, indices, table, "deg");
            double rarad = FastMath.toRadians((double)ra);
            double dec = this.getDouble(row, ClusterProperties.DEC, indices, table, "deg");
            double decrad = FastMath.toRadians((double)dec);
            double distpc = 0.0;
            if (indices.containsKey((Object)ClusterProperties.DIST)) {
                distpc = this.getDouble(row, ClusterProperties.DIST, indices, table, "pc");
            } else if (indices.containsKey((Object)ClusterProperties.PLLX)) {
                distpc = 1000.0 / this.getDouble(row, ClusterProperties.PLLX, indices, table, "mas");
            }
            double dist = distpc * Constants.PC_TO_U;
            double mualphastar = this.getDouble(row, ClusterProperties.PMRA, indices, table, "mas/yr");
            double mudelta = this.getDouble(row, ClusterProperties.PMDE, indices, table, "mas/yr");
            double radvel = this.getDouble(row, ClusterProperties.RV, indices, table, "km/s");
            double radius = this.getDouble(row, ClusterProperties.RADIUS, indices, table, "deg");
            int nstars = this.getInteger(row, ClusterProperties.NSTARS, indices);
            this.addCluster(names, ra, rarad, dec, decrad, dist, distpc, mualphastar, mudelta, radvel, radius, nstars, list);
        }
    }

    private void loadClustersCsv(InputStream data, Array<Entity> list) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(data));
        String header = br.readLine();
        Map<ClusterProperties, Integer> indices = this.parseHeader(header);
        if (!this.checkIndices(indices)) {
            logger.error("At least 'ra', 'dec', 'pllx'|'dist', 'radius' and 'name' are needed, please check your columns!");
            return;
        }
        while ((line = br.readLine()) != null) {
            String[] tokens = line.split(",");
            String[] names = this.parseName(tokens[indices.get((Object)ClusterProperties.NAME)]);
            double ra = this.getDouble(tokens, ClusterProperties.RA, indices);
            double raRad = FastMath.toRadians((double)ra);
            double dec = this.getDouble(tokens, ClusterProperties.DEC, indices);
            double decRad = FastMath.toRadians((double)dec);
            double distPc = 0.0;
            if (indices.containsKey((Object)ClusterProperties.DIST)) {
                distPc = this.getDouble(tokens, ClusterProperties.DIST, indices);
            } else if (indices.containsKey((Object)ClusterProperties.PLLX)) {
                distPc = 1000.0 / this.getDouble(tokens, ClusterProperties.PLLX, indices);
            }
            double distInternal = distPc * Constants.PC_TO_U;
            double muAlphaStar = this.getDouble(tokens, ClusterProperties.PMRA, indices);
            double muDelta = this.getDouble(tokens, ClusterProperties.PMDE, indices);
            double radVel = this.getDouble(tokens, ClusterProperties.RV, indices);
            double radiusDeg = this.getDouble(tokens, ClusterProperties.RADIUS, indices);
            int nStars = this.getInteger(tokens, ClusterProperties.NSTARS, indices);
            this.addCluster(names, ra, raRad, dec, decRad, distInternal, distPc, muAlphaStar, muDelta, radVel, radiusDeg, nStars, list);
        }
    }

    private void addCluster(String[] names, double ra, double raRad, double dec, double decRad, double dist, double distPc, double muAlphaStar, double muDelta, double radVel, double radiusDeg, int nStars, Array<Entity> list) {
        Vector3Q pos = Coordinates.sphericalToCartesian(raRad, decRad, Quadruple.from(dist), new Vector3Q());
        Vector3D pmv = Coordinates.properMotionsToCartesian(muAlphaStar, muDelta, radVel, FastMath.toRadians((double)ra), FastMath.toRadians((double)dec), distPc, new Vector3D());
        Vector3D posSph = new Vector3D((float)ra, (float)dec, (float)dist);
        Vector3 pmSph = new Vector3((float)muAlphaStar, (float)muDelta, (float)radVel);
        Entity entity = this.archetype.createEntity();
        Base base = (Base)Mapper.base.get(entity);
        base.setNames(names);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        graph.setParent(this.parentName != null ? this.parentName : "MWSC");
        Body body = (Body)Mapper.body.get(entity);
        body.setPos(pos);
        body.posSph = new Vector2D(posSph.x, posSph.y);
        body.setColor(Arrays.copyOf(this.clusterColor, this.clusterColor.length));
        body.setLabelColor(Arrays.copyOf(this.clusterColor, this.clusterColor.length));
        ProperMotion pm = (ProperMotion)Mapper.pm.get(entity);
        pm.pm = pmv.put(new Vector3());
        pm.pmSph = pmSph;
        pm.hasPm = true;
        Cluster cluster = (Cluster)Mapper.cluster.get(entity);
        cluster.radiusDeg = radiusDeg;
        cluster.numStars = nStars;
        cluster.dist = posSph.z;
        list.add((Object)entity);
        ++this.numLoaded;
    }

    private String[] parseName(String name) {
        String[] names = name.split("\\|");
        for (int i = 0; i < names.length; ++i) {
            names[i] = names[i].strip().replace("_", " ");
        }
        return names;
    }

    private String get(String[] tokens, ClusterProperties prop, Map<ClusterProperties, Integer> indices) {
        return !indices.containsKey((Object)prop) || tokens[indices.get((Object)prop)].isEmpty() ? null : tokens[indices.get((Object)prop)];
    }

    private Object get(Object[] row, ClusterProperties prop, Map<ClusterProperties, Integer> indices) {
        return !indices.containsKey((Object)prop) || row[indices.get((Object)prop)] == null ? null : row[indices.get((Object)prop)];
    }

    private double getDouble(String[] tokens, ClusterProperties prop, Map<ClusterProperties, Integer> indices) {
        String s = this.get(tokens, prop, indices);
        if (s != null) {
            return Parser.parseDouble(s);
        }
        return 0.0;
    }

    private double getDouble(Object[] row, ClusterProperties prop, Map<ClusterProperties, Integer> indices, StarTable table, String defaultUnit) {
        Integer idx = indices.get((Object)prop);
        if (idx != null) {
            ColumnInfo col = table.getColumnInfo(idx.intValue());
            String unit = col.getUnitString() != null && !col.getUnitString().isBlank() ? col.getUnitString() : defaultUnit;
            Object obj = this.get(row, prop, indices);
            if (obj != null) {
                double val = ((Number)obj).doubleValue();
                if (Quantity.Angle.isAngle(unit)) {
                    Quantity.Angle angle = new Quantity.Angle(val, unit);
                    return angle.get(Quantity.Angle.AngleUnit.valueOf(defaultUnit.toUpperCase(Locale.ROOT)));
                }
                if (Quantity.Length.isLength(unit)) {
                    Quantity.Length length = new Quantity.Length(val, unit);
                    return length.get(Quantity.Length.LengthUnit.valueOf(defaultUnit.toUpperCase(Locale.ROOT)));
                }
                return val;
            }
        }
        return 0.0;
    }

    private int getInteger(String[] tokens, ClusterProperties properties, Map<ClusterProperties, Integer> indices) {
        String s = this.get(tokens, properties, indices);
        if (s != null) {
            return Parser.parseInt(s);
        }
        return 0;
    }

    private int getInteger(Object[] row, ClusterProperties properties, Map<ClusterProperties, Integer> indices) {
        Object s = this.get(row, properties, indices);
        if (s != null) {
            return ((Number)s).intValue();
        }
        return 0;
    }

    private Map<ClusterProperties, Integer> parseHeader(String header) {
        HashMap<ClusterProperties, Integer> indices = new HashMap<ClusterProperties, Integer>();
        if ((header = header.strip()).startsWith("#")) {
            header = header.substring(1);
        }
        String[] tokens = header.split(",");
        int i = 0;
        for (String token : tokens) {
            if (UCDParser.isName(token)) {
                indices.put(ClusterProperties.NAME, i);
            } else if (UCDParser.isRa(token)) {
                indices.put(ClusterProperties.RA, i);
            } else if (UCDParser.isDec(token)) {
                indices.put(ClusterProperties.DEC, i);
            } else if (UCDParser.isDist(token)) {
                indices.put(ClusterProperties.DIST, i);
            } else if (UCDParser.isPllx(token)) {
                indices.put(ClusterProperties.PLLX, i);
            } else if (UCDParser.isPmra(token)) {
                indices.put(ClusterProperties.PMRA, i);
            } else if (UCDParser.isPmde(token)) {
                indices.put(ClusterProperties.PMDE, i);
            } else if (UCDParser.isRadvel(token)) {
                indices.put(ClusterProperties.RV, i);
            } else if (UCDParser.isRadius(token)) {
                indices.put(ClusterProperties.RADIUS, i);
            } else if (UCDParser.isNstars(token)) {
                indices.put(ClusterProperties.NSTARS, i);
            }
            ++i;
        }
        return indices;
    }

    private boolean checkIndices(Map<ClusterProperties, Integer> indices) {
        return indices.containsKey((Object)ClusterProperties.RA) && indices.containsKey((Object)ClusterProperties.DEC) && (indices.containsKey((Object)ClusterProperties.DIST) || indices.containsKey((Object)ClusterProperties.PLLX)) && indices.containsKey((Object)ClusterProperties.RADIUS) && indices.containsKey((Object)ClusterProperties.NAME);
    }

    private Map<ClusterProperties, Integer> parseHeader(StarTable table) {
        HashMap<ClusterProperties, Integer> indices = new HashMap<ClusterProperties, Integer>();
        int nColumns = table.getColumnCount();
        for (int i = 0; i < nColumns; ++i) {
            ColumnInfo ci = table.getColumnInfo(i);
            String cName = ci.getName();
            if (UCDParser.isName(cName)) {
                indices.put(ClusterProperties.NAME, i);
                continue;
            }
            if (UCDParser.isRa(cName)) {
                indices.put(ClusterProperties.RA, i);
                continue;
            }
            if (UCDParser.isDec(cName)) {
                indices.put(ClusterProperties.DEC, i);
                continue;
            }
            if (UCDParser.isDist(cName)) {
                indices.put(ClusterProperties.DIST, i);
                continue;
            }
            if (UCDParser.isPllx(cName)) {
                indices.put(ClusterProperties.PLLX, i);
                continue;
            }
            if (UCDParser.isPmra(cName)) {
                indices.put(ClusterProperties.PMRA, i);
                continue;
            }
            if (UCDParser.isPmde(cName)) {
                indices.put(ClusterProperties.PMDE, i);
                continue;
            }
            if (UCDParser.isRadvel(cName)) {
                indices.put(ClusterProperties.RV, i);
                continue;
            }
            if (UCDParser.isRadius(cName)) {
                indices.put(ClusterProperties.RADIUS, i);
                continue;
            }
            if (!UCDParser.isNstars(cName)) continue;
            indices.put(ClusterProperties.NSTARS, i);
        }
        return indices;
    }

    private static enum ClusterProperties {
        NAME,
        RA,
        DEC,
        DIST,
        PLLX,
        PMRA,
        PMDE,
        RV,
        RADIUS,
        NSTARS;

    }
}

