/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.group;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.LongMap;
import gaiasky.data.api.IStarGroupDataProvider;
import gaiasky.data.group.BinaryDataProvider;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.TextUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.io.ByteBufferInputStream;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.parse.Parser;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ForkJoinPool;
import java.util.zip.GZIPInputStream;

public abstract class AbstractStarGroupDataProvider
implements IStarGroupDataProvider {
    protected static Logger.Log logger;
    protected final int parallelism;
    protected Map<String, Object> params;
    protected Map<ColId, Integer> indexMap;
    protected List<IParticleRecord> list;
    protected LongMap<double[]> sphericalPositions;
    protected LongMap<float[]> colors;
    protected long[] countsPerMag;
    protected Matrix4D transform;
    protected Set<Long> mustLoadIds = null;
    protected List<AdditionalCols> additional;
    protected String[] additionalFiles = null;
    protected Double ruwe = Double.NaN;
    protected double distCap = Double.MAX_VALUE;
    protected double parallaxErrorFactorFaint = 0.125;
    protected double parallaxErrorFactorBright = 0.25;
    protected boolean adaptiveParallax = true;
    protected double parallaxZeroPoint = 0.0;
    protected boolean magCorrections = false;
    protected int fileNumberCap = -1;
    protected int starNumberCap = -1;

    public AbstractStarGroupDataProvider() {
        try (ForkJoinPool p = ForkJoinPool.commonPool();){
            this.parallelism = p.getParallelism();
        }
    }

    public ColId colIdFromStr(String name) {
        return switch (name) {
            case "source_id", "sourceid" -> ColId.sourceid;
            case "hip" -> ColId.hip;
            case "names", "name" -> ColId.names;
            case "ra" -> ColId.ra;
            case "dec", "de" -> ColId.dec;
            case "plx", "pllx", "parallax" -> ColId.pllx;
            case "ra_e", "ra_err", "ra_error" -> ColId.ra_err;
            case "dec_e", "dec_err", "dec_error", "de_e", "de_err", "de_error" -> ColId.dec_err;
            case "plx_e", "plx_err", "plx_error", "pllx_e", "pllx_err", "pllx_error" -> ColId.pllx_err;
            case "pmra" -> ColId.pmra;
            case "pmdec", "pmde" -> ColId.pmdec;
            case "radvel", "rv" -> ColId.radvel;
            case "radvel_err", "radvel_e", "rv_err", "rv_e" -> ColId.radvel_err;
            case "gmag", "appmag" -> ColId.gmag;
            case "bpmag", "bp" -> ColId.bpmag;
            case "rpmag", "rp" -> ColId.rpmag;
            case "bp-rp", "bp_rp" -> ColId.bp_rp;
            case "col_idx", "b_v", "b-v" -> ColId.col_idx;
            case "ref_epoch" -> ColId.ref_epoch;
            case "ruwe" -> ColId.ruwe;
            case "teff", "t_eff", "T_eff" -> ColId.teff;
            case "ag" -> ColId.ag;
            case "ebp_min_rp" -> ColId.ebp_min_rp;
            case "geodist" -> ColId.geodist;
            default -> null;
        };
    }

    protected int idx(ColId colId) {
        if (this.indexMap != null && this.indexMap.containsKey((Object)colId)) {
            return this.indexMap.get((Object)colId);
        }
        return -1;
    }

    protected boolean hasCol(ColId colId) {
        return this.indexMap != null && this.indexMap.containsKey((Object)colId) && this.indexMap.get((Object)colId) >= 0;
    }

    protected boolean hasAdditional(ColId col, Long sourceId) {
        Double val = this.getAdditionalValue(col, sourceId);
        return val != null && !Double.isNaN(val) && !Double.isInfinite(val);
    }

    protected boolean hasAdditionalColumn(ColId col) {
        if (this.additional == null) {
            return false;
        }
        for (AdditionalCols add : this.additional) {
            if (add == null || !add.hasCol(col)) continue;
            return true;
        }
        return false;
    }

    protected Double getAdditionalValue(ColId col, Long sourceId) {
        if (this.additional == null) {
            return null;
        }
        for (AdditionalCols add : this.additional) {
            Double d;
            if (add == null || !add.hasCol(col) || (d = add.get(col, sourceId)) == null) continue;
            return d;
        }
        return null;
    }

    protected void initLists(FileHandle f) {
        try {
            int lines = this.countLines(f);
            this.initLists(lines - 1);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    protected void initLists(int elems) {
        this.list = this.parallelism > 1 ? Collections.synchronizedList(new ArrayList(elems)) : new ArrayList<IParticleRecord>(elems);
    }

    protected void initLists() {
        this.initLists(1000);
        this.sphericalPositions = new LongMap();
        this.colors = new LongMap();
    }

    @Override
    public List<IParticleRecord> loadData(String file) {
        return this.loadData(file, 1.0);
    }

    protected boolean mustLoad(long id) {
        return this.mustLoadIds != null && this.mustLoadIds.contains(id);
    }

    protected boolean acceptParallax(double appMag, double parallax, double parallaxError) {
        if (this.hasAdditionalColumn(ColId.geodist)) {
            return true;
        }
        if (!Double.isFinite(appMag)) {
            return false;
        }
        if (this.adaptiveParallax && appMag < 13.1) {
            return parallax >= 0.0 && parallaxError < parallax * this.parallaxErrorFactorBright && parallaxError <= 1.0;
        }
        return parallax >= 0.0 && parallaxError < parallax * this.parallaxErrorFactorFaint && parallaxError <= 1.0;
    }

    protected float getRuweValue(long sourceId, String[] tokens) {
        if (this.hasCol(ColId.ruwe)) {
            return Parser.parseFloat(tokens[this.idx(ColId.ruwe)]);
        }
        Double ruwe = this.getAdditionalValue(ColId.ruwe, sourceId);
        if (ruwe == null || ruwe.isInfinite() || ruwe.isNaN()) {
            return Float.NaN;
        }
        return ruwe.floatValue();
    }

    protected double getGeoDistance(long sourceId) {
        Double geodist = this.getAdditionalValue(ColId.geodist, sourceId);
        if (geodist == null || geodist.isInfinite() || geodist.isNaN()) {
            return -1.0;
        }
        return geodist;
    }

    protected boolean acceptDistance(double distance) {
        return distance <= this.distCap;
    }

    protected int countLines(FileHandle f) throws IOException {
        BufferedInputStream is = new BufferedInputStream(f.read());
        return this.countLines(is);
    }

    @Override
    public void setColumns(String columns) {
    }

    @Override
    public void setMustLoadIds(Set<Long> ids) {
        this.mustLoadIds = ids;
    }

    protected int countLines(InputStream is) throws IOException {
        byte[] c = new byte[1024];
        int count = 0;
        int readChars = 0;
        boolean empty = true;
        while ((readChars = is.read(c)) != -1) {
            empty = false;
            for (int i = 0; i < readChars; ++i) {
                if (c[i] != 10) continue;
                ++count;
            }
        }
        is.close();
        return count == 0 && !empty ? 1 : count;
    }

    protected void dumpToDisk(List<IParticleRecord> data, String filename, String format) {
        if (format.equals("bin")) {
            this.dumpToDiskBin(data, filename);
        } else if (format.equals("csv")) {
            this.dumpToDiskCsv(data, filename);
        }
    }

    protected void dumpToDiskBin(List<IParticleRecord> data, String filename) {
        BinaryDataProvider io = new BinaryDataProvider();
        try {
            int n = data.size();
            io.writeData(data, new FileOutputStream(filename));
            logger.info("File " + filename + " written with " + n + " stars");
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    protected void dumpToDiskCsv(List<IParticleRecord> data, String filename) {
        String sep = "' ";
        try {
            PrintWriter writer = new PrintWriter(filename, StandardCharsets.UTF_8);
            writer.println("name(s), x[km], y[km], z[km], absmag, appmag, r, g, b");
            Vector3D gal = new Vector3D();
            int n = 0;
            for (IParticleRecord star : data) {
                float[] col = (float[])this.colors.get(star.id());
                double x = star.z();
                double y = -star.x();
                double z = star.y();
                gal.set(x, y, z).scl(Constants.U_TO_KM);
                gal.mul(Coordinates.equatorialToGalactic());
                writer.println(TextUtils.concatenate("|", star.names()) + sep + x + sep + y + sep + z + sep + star.absMag() + sep + star.appMag() + sep + col[0] + sep + col[1] + sep + col[2]);
                ++n;
            }
            writer.close();
            logger.info("File " + filename + " written with " + n + " stars");
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    @Override
    public LongMap<float[]> getColors() {
        return this.colors;
    }

    @Override
    public void setParallaxErrorFactorFaint(double parallaxErrorFactor) {
        this.parallaxErrorFactorFaint = parallaxErrorFactor;
    }

    @Override
    public void setParallaxErrorFactorBright(double parallaxErrorFactor) {
        this.parallaxErrorFactorBright = parallaxErrorFactor;
    }

    @Override
    public void setAdaptiveParallax(boolean adaptive) {
        this.adaptiveParallax = adaptive;
    }

    @Override
    public void setParallaxZeroPoint(double parallaxZeroPoint) {
        this.parallaxZeroPoint = parallaxZeroPoint;
    }

    @Override
    public void setMagCorrections(boolean magCorrections) {
        this.magCorrections = magCorrections;
    }

    @Override
    public long[] getCountsPerMag() {
        return this.countsPerMag;
    }

    @Override
    public void setAdditionalFiles(String additionalFiles) {
        if (additionalFiles != null && !additionalFiles.isBlank()) {
            this.additionalFiles = additionalFiles.split(",");
            this.additional = new ArrayList<AdditionalCols>();
            if (this.additionalFiles.length > 0) {
                this.loadAdditional();
            }
        }
    }

    @Override
    public void setDistanceCap(double distCap) {
        this.distCap = distCap;
    }

    @Override
    public void setRUWECap(double RUWE) {
        this.ruwe = RUWE;
    }

    private void loadAdditional() {
        for (String additionalFile : this.additionalFiles) {
            AdditionalCols addit = new AdditionalCols();
            addit.indices = new HashMap<String, Integer>();
            addit.values = new TreeMap();
            logger.info("Loading additional columns from " + additionalFile);
            Path f = Paths.get(additionalFile, new String[0]);
            this.loadAdditional(f, addit);
            this.additional.add(addit);
            logger.info(addit.indices.size() + " additional columns loaded for " + addit.values.size() + " stars");
        }
    }

    private void loadAdditional(Path f, AdditionalCols addit) {
        if (Files.isDirectory(f, LinkOption.NOFOLLOW_LINKS)) {
            File[] files = f.toFile().listFiles();
            assert (files != null);
            int nFiles = files.length;
            int mod = nFiles / 20;
            int i = 1;
            for (File file : files) {
                if (nFiles > 60 && i % mod == 0) {
                    logger.info("Loading file " + i + "/" + nFiles);
                }
                this.loadAdditional(file.toPath(), addit);
                ++i;
            }
        } else {
            try {
                this.loadAdditionalFile(f, addit);
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
    }

    private void loadAdditionalFile(Path f, AdditionalCols additionalCols) throws RuntimeException {
        try (RandomAccessFile raf = new RandomAccessFile(f.toFile(), "r");){
            String line;
            FileChannel fc = raf.getChannel();
            MappedByteBuffer mem = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            InputStream data = new ByteBufferInputStream(mem);
            if (f.toString().endsWith(".gz")) {
                data = new GZIPInputStream(data);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(data));
            String additionalSplit = ",|\\s+";
            String[] header = br.readLine().strip().split(additionalSplit);
            int i = 0;
            for (String col : header) {
                col = col.strip();
                if (i == 0 && !col.equals(ColId.sourceid.name())) {
                    logger.error("First column: " + col + ", should be: " + ColId.sourceid.name());
                    throw new RuntimeException("Additional columns file must contain a sourceid in the first column");
                }
                if (i > 0 && !additionalCols.indices.containsKey(col)) {
                    additionalCols.indices.put(col, i - 1);
                }
                ++i;
            }
            int nCols = header.length - 1;
            i = 0;
            while ((line = br.readLine()) != null) {
                String[] tokens = line.split(additionalSplit);
                Long sourceId = Parser.parseLong(tokens[0].trim());
                double[] vals = new double[nCols];
                for (int j = 1; j <= nCols; ++j) {
                    double val;
                    vals[j - 1] = tokens[j] != null && !tokens[j].strip().isBlank() ? (val = Parser.parseDouble(tokens[j].strip())) : Double.NaN;
                }
                additionalCols.values.put(sourceId, vals);
                ++i;
            }
            br.close();
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    @Override
    public void setFileNumberCap(int cap) {
        this.fileNumberCap = cap;
    }

    @Override
    public void setStarNumberCap(int starNumberCap) {
        this.starNumberCap = starNumberCap;
    }

    @Override
    public void setOutputFormatVersion(int version) {
    }

    @Override
    public void setProviderParams(Map<String, Object> params) {
        this.params = params;
    }

    @Override
    public void setTransformMatrix(Matrix4D transform) {
        this.transform = transform;
    }

    public static enum ColId {
        sourceid,
        hip,
        names,
        ra,
        dec,
        pllx,
        ra_err,
        dec_err,
        pllx_err,
        pmra,
        pmdec,
        radvel,
        pmra_err,
        pmdec_err,
        radvel_err,
        gmag,
        bpmag,
        rpmag,
        bp_rp,
        col_idx,
        ref_epoch,
        teff,
        radius,
        ag,
        ebp_min_rp,
        ruwe,
        geodist;

    }

    public static class AdditionalCols {
        Map<String, Integer> indices;
        TreeMap<Long, double[]> values;

        public boolean hasCol(ColId col) {
            return this.indices != null && this.indices.containsKey(col.name());
        }

        public Double get(ColId col, Long sourceid) {
            try {
                if (this.hasCol(col)) {
                    return this.values.get(sourceid)[this.indices.get(col.name())];
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

