/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.group;

import gaiasky.data.api.BinaryIO;
import gaiasky.data.group.AbstractStarGroupDataProvider;
import gaiasky.data.group.BinaryVersion0;
import gaiasky.data.group.BinaryVersion1;
import gaiasky.data.group.BinaryVersion2;
import gaiasky.data.group.BinaryVersion3;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public class BinaryDataProvider
extends AbstractStarGroupDataProvider {
    public static int DEFAULT_OUTPUT_VERSION;
    public static int MIN_OUTPUT_VERSION;
    public static int MAX_OUTPUT_VERSION;
    private final BinaryIO[] binaryVersions = new BinaryIO[4];
    private int outputVersion = -1;

    public BinaryDataProvider() {
        this.binaryVersions[0] = new BinaryVersion0();
        this.binaryVersions[1] = new BinaryVersion1();
        this.binaryVersions[2] = new BinaryVersion2();
        this.binaryVersions[3] = new BinaryVersion3();
    }

    @Override
    public List<IParticleRecord> loadData(String file, double factor) {
        logger.info(I18n.msg("notif.datafile", file));
        this.loadDataMapped(file, factor);
        logger.info(I18n.msg("notif.nodeloader", this.list.size(), file));
        return this.list;
    }

    @Override
    public List<IParticleRecord> loadData(InputStream is, double factor) {
        this.list = this.readData(is, factor);
        return this.list;
    }

    public void writeData(List<IParticleRecord> data, OutputStream out) {
        int version = this.outputVersion < MIN_OUTPUT_VERSION || this.outputVersion > MAX_OUTPUT_VERSION ? DEFAULT_OUTPUT_VERSION : this.outputVersion;
        this.writeData(data, out, version);
    }

    public void writeData(List<IParticleRecord> data, OutputStream out, int version) {
        try (DataOutputStream data_out = new DataOutputStream(out);){
            try {
                if (version >= 2) {
                    data_out.writeInt(-1);
                    data_out.writeInt(version);
                }
                data_out.writeInt(data.size());
                for (IParticleRecord sb : data) {
                    this.binaryVersions[version].writeParticleRecord(sb, data_out);
                }
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
        catch (IOException e) {
            logger.error(e);
        }
    }

    public List<IParticleRecord> readData(InputStream in, double factor) {
        ArrayList<IParticleRecord> data = null;
        try (DataInputStream data_in = new DataInputStream(in);){
            try {
                int version = 1;
                data_in.mark(0);
                int versionToken = data_in.readInt();
                if (versionToken < 0) {
                    version = data_in.readInt();
                } else {
                    data_in.reset();
                }
                int size = data_in.readInt();
                data = new ArrayList<IParticleRecord>(size);
                for (int i = 0; i < size; ++i) {
                    data.add(this.binaryVersions[version].readParticleRecord(data_in, factor));
                }
            }
            catch (IOException e) {
                logger.error(e);
            }
        }
        catch (IOException e) {
            logger.error(e);
        }
        return data;
    }

    @Override
    public List<IParticleRecord> loadDataMapped(String file, double factor) {
        List list;
        RandomAccessFile raf = new RandomAccessFile(Settings.settings.data.dataFile(file), "r");
        try {
            FileChannel fc = raf.getChannel();
            MappedByteBuffer mem = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            int version = 1;
            mem.mark();
            int versionToken = mem.getInt();
            if (versionToken < 0) {
                version = mem.getInt();
            } else {
                mem.reset();
            }
            int size = mem.getInt();
            this.list = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                this.list.add(this.binaryVersions[version].readParticleRecord(mem, factor));
            }
            fc.close();
            list = this.list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    raf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.error(e);
                return null;
            }
        }
        raf.close();
        return list;
    }

    public List<IParticleRecord> loadDataMapped(String file, double factor, int versionHint) {
        List list;
        RandomAccessFile raf = new RandomAccessFile(Settings.settings.data.dataFile(file), "r");
        try {
            FileChannel fc = raf.getChannel();
            MappedByteBuffer mem = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            int version = versionHint;
            mem.mark();
            int versionToken = mem.getInt();
            if (versionToken < 0) {
                version = mem.getInt();
            } else {
                mem.reset();
            }
            int size = mem.getInt();
            this.list = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                this.list.add(this.binaryVersions[version].readParticleRecord(mem, factor));
            }
            fc.close();
            list = this.list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    raf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.error(e);
                return null;
            }
        }
        raf.close();
        return list;
    }

    @Override
    public void setOutputFormatVersion(int version) {
        this.outputVersion = version;
    }

    static {
        logger = Logger.getLogger(BinaryDataProvider.class);
        DEFAULT_OUTPUT_VERSION = 3;
        MIN_OUTPUT_VERSION = 0;
        MAX_OUTPUT_VERSION = DEFAULT_OUTPUT_VERSION;
    }
}

