/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.group;

import gaiasky.data.api.BinaryIO;
import gaiasky.data.group.reader.IDataReader;
import gaiasky.data.group.reader.InputStreamDataReader;
import gaiasky.data.group.reader.MappedBufferDataReader;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.record.ParticleStar;
import gaiasky.util.Constants;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;

public abstract class BinaryIOBase
implements BinaryIO {
    protected final int nDoubles;
    protected final int nFloats;
    protected boolean hipId;
    protected boolean tychoIds;

    protected BinaryIOBase(int nDoubles, int nFloats, boolean hipId, boolean tychoIds) {
        this.hipId = hipId;
        this.tychoIds = tychoIds;
        this.nDoubles = nDoubles;
        this.nFloats = nFloats;
    }

    @Override
    public IParticleRecord readParticleRecord(MappedByteBuffer mem, double factor) throws IOException {
        return this.readParticleRecord(new MappedBufferDataReader(mem), factor);
    }

    @Override
    public IParticleRecord readParticleRecord(DataInputStream in, double factor) throws IOException {
        return this.readParticleRecord(new InputStreamDataReader(in), factor);
    }

    public IParticleRecord readParticleRecord(IDataReader in, double factor) throws IOException {
        String[] names;
        int idx;
        int i;
        double[] dataD = new double[3];
        float[] dataF = new float[12];
        int floatOffset = 0;
        for (i = 0; i < this.nDoubles; ++i) {
            if (i < dataD.length) {
                dataD[i] = in.readDouble();
                int n = i;
                dataD[n] = dataD[n] * (factor * Constants.DISTANCE_SCALE_FACTOR);
                continue;
            }
            idx = i - dataD.length;
            dataF[idx] = (float)in.readDouble();
            floatOffset = idx + 1;
        }
        for (i = 0; i < this.nFloats; ++i) {
            idx = i + floatOffset;
            dataF[idx] = in.readFloat();
            if (idx > 2 && idx != 9) continue;
            int n = idx;
            dataF[n] = dataF[n] * (float)Constants.DISTANCE_SCALE_FACTOR;
        }
        if (this.hipId) {
            dataF[10] = in.readInt();
        }
        if (this.tychoIds) {
            in.readInt();
            in.readInt();
            in.readInt();
        }
        long id = in.readLong();
        int nameLength = in.readInt();
        if (nameLength == 0) {
            names = new String[]{Long.toString(id)};
        } else {
            StringBuilder namesConcat = new StringBuilder();
            for (int i2 = 0; i2 < nameLength; ++i2) {
                namesConcat.append(in.readChar());
            }
            names = namesConcat.toString().split("\\|");
        }
        return new ParticleStar(id, names, dataD[0], dataD[1], dataD[2], dataF[3], dataF[4], dataF[5], dataF[0], dataF[1], dataF[2], dataF[6], dataF[7], dataF[8], dataF[9], (int)dataF[10], dataF[11], null);
    }
}

