/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.group;

import gaiasky.data.api.BinaryIO;
import gaiasky.data.api.IParticleGroupDataProvider;
import gaiasky.data.group.DatasetOptions;
import gaiasky.data.group.reader.IDataReader;
import gaiasky.data.group.reader.InputStreamDataReader;
import gaiasky.data.group.reader.MappedBufferDataReader;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.record.Particle;
import gaiasky.scene.record.ParticleExt;
import gaiasky.scene.record.ParticleType;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector3D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jafama.FastMath;

public class BinaryPointDataProvider
implements IParticleGroupDataProvider,
BinaryIO {
    protected static Logger.Log logger = Logger.getLogger(BinaryPointDataProvider.class);
    private int particleNumberCap = -1;
    protected List<IParticleRecord> list;
    private final AtomicBoolean extra = new AtomicBoolean();
    private final Vector3D aux3d1 = new Vector3D();
    private final Vector3D aux3d2 = new Vector3D();

    public void setDatasetOptions(DatasetOptions datasetOptions) {
    }

    @Override
    public List<IParticleRecord> loadData(String file) {
        return this.loadData(file, 1.0);
    }

    @Override
    public List<IParticleRecord> loadData(String file, double factor) {
        logger.info(I18n.msg("notif.datafile", file));
        this.loadDataMapped(file, factor);
        logger.info(I18n.msg("notif.nodeloader", this.list.size(), file));
        return this.list;
    }

    @Override
    public List<IParticleRecord> loadData(InputStream is, double factor) {
        this.list = this.readData(is, factor);
        return this.list;
    }

    public List<IParticleRecord> readData(InputStream in, double factor) {
        ArrayList<IParticleRecord> data = null;
        try (DataInputStream data_in = new DataInputStream(in);){
            try {
                data_in.mark(0);
                int size = data_in.readInt();
                boolean extra = data_in.readBoolean();
                this.extra.set(extra);
                data = new ArrayList<IParticleRecord>(size);
                for (int i = 0; i < size; ++i) {
                    if (this.particleNumberCap >= 0 && i >= this.particleNumberCap) continue;
                    data.add(this.readParticleRecord(data_in, factor));
                }
            }
            catch (IOException e) {
                logger.error(e);
            }
        }
        catch (IOException e) {
            logger.error(e);
        }
        return data;
    }

    @Override
    public List<IParticleRecord> loadDataMapped(String file, double factor) {
        List<IParticleRecord> list;
        RandomAccessFile raf = new RandomAccessFile(Settings.settings.data.dataFile(file), "r");
        try {
            FileChannel fc = raf.getChannel();
            MappedByteBuffer mem = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            mem.mark();
            int size = mem.getInt();
            boolean extra = mem.get() == 1;
            this.extra.set(extra);
            this.list = new ArrayList<IParticleRecord>(size);
            for (int i = 0; i < size; ++i) {
                if (this.particleNumberCap >= 0 && i >= this.particleNumberCap) continue;
                this.list.add(this.readParticleRecord(mem, factor));
            }
            fc.close();
            list = this.list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    raf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.error(e);
                return null;
            }
        }
        raf.close();
        return list;
    }

    @Override
    public void setFileNumberCap(int cap) {
    }

    @Override
    public void setStarNumberCap(int cap) {
        this.particleNumberCap = cap;
    }

    @Override
    public void setProviderParams(Map<String, Object> params) {
    }

    @Override
    public void setTransformMatrix(Matrix4D matrix) {
    }

    @Override
    public IParticleRecord readParticleRecord(MappedByteBuffer mem, double factor) throws IOException {
        return this.readParticleRecord(new MappedBufferDataReader(mem), factor);
    }

    @Override
    public IParticleRecord readParticleRecord(DataInputStream in, double factor) throws IOException {
        return this.readParticleRecord(new InputStreamDataReader(in), factor);
    }

    public IParticleRecord readParticleRecord(IDataReader in, double factor) throws IOException {
        float size;
        String[] names;
        ParticleType pType = this.extra.get() ? ParticleType.PARTICLE_EXT : ParticleType.PARTICLE;
        long id = in.readLong();
        int nameLength = in.readInt();
        if (nameLength == 0) {
            names = new String[]{Long.toString(id)};
        } else {
            StringBuilder namesConcat = new StringBuilder();
            for (int i = 0; i < nameLength; ++i) {
                namesConcat.append(in.readChar());
            }
            names = namesConcat.toString().split("\\|");
        }
        double alphaDeg = in.readDouble();
        double deltaDeg = in.readDouble();
        double distPc = in.readDouble();
        Vector3D pos = Coordinates.sphericalToCartesian(alphaDeg * (Math.PI / 180), deltaDeg * (Math.PI / 180), distPc * Constants.PC_TO_U, this.aux3d1);
        pos.scl(factor);
        float muAlpha = 0.0f;
        float muDelta = 0.0f;
        float radVel = 0.0f;
        if (this.extra.get()) {
            muAlpha = in.readFloat();
            muDelta = in.readFloat();
            radVel = in.readFloat();
        }
        Vector3D velocityVector = Coordinates.properMotionsToCartesian(muAlpha, muDelta, radVel, FastMath.toRadians((double)alphaDeg), FastMath.toRadians((double)deltaDeg), distPc, this.aux3d2);
        float appMag = this.extra.get() ? in.readFloat() : 15.0f;
        float absMag = (float)AstroUtils.apparentToAbsoluteMagnitude(distPc, appMag);
        float color = this.extra.get() ? in.readFloat() : Float.NaN;
        if (this.extra.get()) {
            size = in.readFloat();
        } else {
            double sizePc = AstroUtils.absoluteMagnitudeToPseudoSize(absMag);
            size = (float)sizePc;
        }
        Record p = null;
        switch (pType) {
            case PARTICLE: {
                p = new Particle(id, names, pos.x, pos.y, pos.z, null);
                break;
            }
            case PARTICLE_EXT: {
                p = new ParticleExt(id, names, pos.x, pos.y, pos.z, muAlpha, muDelta, radVel, (float)velocityVector.x, (float)velocityVector.y, (float)velocityVector.z, appMag, absMag, color, size, null);
            }
        }
        return p;
    }

    public void writeData(List<IParticleRecord> data, OutputStream out, boolean extra) {
        try (DataOutputStream dataOut = new DataOutputStream(out);){
            try {
                dataOut.writeInt(data.size());
                dataOut.writeBoolean(extra);
                this.extra.set(extra);
                for (IParticleRecord sb : data) {
                    this.writeParticleRecord(sb, dataOut);
                }
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
        catch (IOException e) {
            logger.error(e);
        }
    }

    @Override
    public void writeParticleRecord(IParticleRecord sb, DataOutputStream out) throws IOException {
        out.writeLong(sb.id());
        if (sb.names().length == 1 && sb.names()[0].equals(Long.toString(sb.id()))) {
            out.writeInt(0);
        } else {
            String namesConcat = sb.namesConcat();
            if (namesConcat == null || namesConcat.isEmpty()) {
                out.writeInt(0);
            } else {
                out.writeInt(namesConcat.length());
                out.writeChars(namesConcat);
            }
        }
        Vector3D cartPos = sb.pos(this.aux3d1);
        Vector3D sphPos = Coordinates.cartesianToSpherical(cartPos, this.aux3d2);
        out.writeDouble(sphPos.x * 57.29577951308232);
        out.writeDouble(sphPos.y * 57.29577951308232);
        out.writeDouble(sb.distance() * Constants.U_TO_PC);
        if (this.extra.get()) {
            out.writeFloat(sb.muAlpha());
            out.writeFloat(sb.muDelta());
            out.writeFloat(sb.radVel());
            out.writeFloat(sb.appMag());
            out.writeFloat(sb.color());
            out.writeFloat(sb.size());
        }
    }
}

