/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.group;

import gaiasky.data.api.BinaryIO;
import gaiasky.data.group.reader.IDataReader;
import gaiasky.data.group.reader.InputStreamDataReader;
import gaiasky.data.group.reader.MappedBufferDataReader;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.record.ParticleStar;
import gaiasky.util.Constants;
import gaiasky.util.parse.Parser;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.util.Arrays;
import java.util.List;

public class BinaryVersion3
implements BinaryIO {
    protected BinaryVersion3() {
    }

    @Override
    public IParticleRecord readParticleRecord(MappedByteBuffer mem, double factor) throws IOException {
        return this.readParticleRecord(new MappedBufferDataReader(mem), factor);
    }

    @Override
    public IParticleRecord readParticleRecord(DataInputStream in, double factor) throws IOException {
        return this.readParticleRecord(new InputStreamDataReader(in), factor);
    }

    public IParticleRecord readParticleRecord(IDataReader in, double factor) throws IOException {
        String name2;
        String[] names;
        double[] dataD = new double[3];
        float[] dataF = new float[12];
        int floatOffset = 0;
        int i = 0;
        while (i < 3) {
            dataD[i] = in.readDouble();
            int n = i++;
            dataD[n] = dataD[n] * (factor * Constants.DISTANCE_SCALE_FACTOR);
        }
        for (i = 0; i < 11; ++i) {
            int idx = i + floatOffset;
            dataF[idx] = in.readFloat();
            if (idx > 2 && idx != 9) continue;
            int n = idx;
            dataF[n] = dataF[n] * (float)Constants.DISTANCE_SCALE_FACTOR;
        }
        dataF[11] = dataF[10];
        dataF[10] = -1.0f;
        long id = in.readLong();
        int nameLength = in.readInt();
        if (nameLength == 0) {
            names = new String[]{Long.toString(id)};
        } else {
            StringBuilder namesConcat = new StringBuilder();
            for (int i2 = 0; i2 < nameLength; ++i2) {
                namesConcat.append(in.readChar());
            }
            names = namesConcat.toString().split("\\|");
        }
        List<String> hipName = Arrays.stream(names).filter(name -> name.startsWith("HIP ")).toList();
        if (!hipName.isEmpty() && (name2 = hipName.get(0).trim()).length() > 4) {
            try {
                dataF[10] = Parser.parseIntException(name2.substring(4));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new ParticleStar(id, names, dataD[0], dataD[1], dataD[2], dataF[3], dataF[4], dataF[5], dataF[0], dataF[1], dataF[2], dataF[6], dataF[7], dataF[8], dataF[9], (int)dataF[10], dataF[11], null);
    }

    @Override
    public void writeParticleRecord(IParticleRecord sb, DataOutputStream out) throws IOException {
        out.writeDouble(sb.x());
        out.writeDouble(sb.y());
        out.writeDouble(sb.z());
        out.writeFloat(sb.vx());
        out.writeFloat(sb.vy());
        out.writeFloat(sb.vz());
        out.writeFloat(sb.muAlpha());
        out.writeFloat(sb.muDelta());
        out.writeFloat(sb.radVel());
        out.writeFloat(sb.appMag());
        out.writeFloat(sb.absMag());
        out.writeFloat(sb.color());
        out.writeFloat(sb.size());
        out.writeFloat(sb.tEff());
        out.writeLong(sb.id());
        String namesConcat = sb.namesConcat();
        if (namesConcat == null || namesConcat.isEmpty()) {
            out.writeInt(0);
        } else {
            out.writeInt(namesConcat.length());
            out.writeChars(namesConcat);
        }
    }
}

