/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.group;

import gaiasky.render.ComponentTypes;

public class DatasetOptions {
    public DatasetLoadType type;
    public double profileDecay;
    public double[] particleColor;
    public double particleColorNoise;
    public double particleSize;
    public double[] particleSizeLimits;
    public String modelType = "quad";
    public String modelPrimitive = "GL_TRIANGLES";
    public String[] textures;
    public ComponentTypes.ComponentType ct;
    public double magnitudeScale;
    public String catalogName;
    public double[] labelColor;
    public double[] fadeIn;
    public double[] fadeOut;
    public int numLabels;
    public boolean renderSetLabel = false;
    public boolean initializeCatalogInfo = true;

    public static DatasetOptions getStarDatasetOptions(String datasetName, double magnitudeScale, double[] labelColor, double[] fadeIn, double[] fadeOut) {
        DatasetOptions datasetOptions = new DatasetOptions();
        datasetOptions.type = DatasetLoadType.STARS;
        datasetOptions.catalogName = datasetName;
        datasetOptions.labelColor = labelColor;
        datasetOptions.magnitudeScale = magnitudeScale;
        datasetOptions.fadeIn = fadeIn;
        datasetOptions.fadeOut = fadeOut;
        return datasetOptions;
    }

    public static DatasetOptions getParticleDatasetOptions(String datasetName, double profileDecay, double[] particleColor, double colorNoise, double[] labelColor, double particleSize, double[] particleSizeLimits, ComponentTypes.ComponentType ct, double[] fadeIn, double[] fadeOut) {
        DatasetOptions datasetOptions = new DatasetOptions();
        datasetOptions.type = DatasetLoadType.PARTICLES;
        datasetOptions.catalogName = datasetName;
        datasetOptions.profileDecay = profileDecay;
        datasetOptions.particleColor = particleColor;
        datasetOptions.particleColorNoise = colorNoise;
        datasetOptions.labelColor = labelColor;
        datasetOptions.particleSize = particleSize;
        datasetOptions.particleSizeLimits = particleSizeLimits;
        datasetOptions.ct = ct;
        datasetOptions.fadeIn = fadeIn;
        datasetOptions.fadeOut = fadeOut;
        return datasetOptions;
    }

    public static DatasetOptions getStarClusterDatasetOptions(String datasetName, double[] particleColor, double[] labelColor, ComponentTypes.ComponentType ct, double[] fadeIn, double[] fadeOut) {
        DatasetOptions datasetOptions = new DatasetOptions();
        datasetOptions.type = DatasetLoadType.PARTICLES_EXT;
        datasetOptions.catalogName = datasetName;
        datasetOptions.particleColor = particleColor;
        datasetOptions.labelColor = labelColor;
        datasetOptions.ct = ct;
        datasetOptions.particleSizeLimits = new double[]{0.0, 1.57};
        datasetOptions.fadeIn = fadeIn;
        datasetOptions.fadeOut = fadeOut;
        datasetOptions.modelType = "icosphere";
        datasetOptions.modelPrimitive = "GL_LINES";
        return datasetOptions;
    }

    public static DatasetOptions getVariableStarDatasetOptions(String datasetName, double magnitudeScale, double[] labelColor, ComponentTypes.ComponentType ct, double[] fadeIn, double[] fadeOut) {
        DatasetOptions datasetOptions = new DatasetOptions();
        datasetOptions.type = DatasetLoadType.VARIABLES;
        datasetOptions.catalogName = datasetName;
        datasetOptions.labelColor = labelColor;
        datasetOptions.magnitudeScale = magnitudeScale;
        datasetOptions.ct = ct;
        datasetOptions.fadeIn = fadeIn;
        datasetOptions.fadeOut = fadeOut;
        return datasetOptions;
    }

    public static enum DatasetLoadType {
        PARTICLES,
        PARTICLES_EXT,
        STARS,
        CLUSTERS,
        VARIABLES;


        public boolean isSelectable() {
            return this != PARTICLES;
        }
    }
}

