/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.group;

import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.tree.LoadStatus;
import gaiasky.util.tree.OctreeNode;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jafama.FastMath;

public class MetadataBinaryIO {
    private static final Logger.Log logger = Logger.getLogger(MetadataBinaryIO.class);
    public Map<Long, Pair<OctreeNode, long[]>> nodesMap;

    public OctreeNode readMetadata(InputStream in) {
        return this.readMetadata(in, null);
    }

    public OctreeNode readMetadata(InputStream in, LoadStatus status) {
        this.nodesMap = new HashMap<Long, Pair<OctreeNode, long[]>>();
        DataInputStream data_in = new DataInputStream(in);
        try {
            int size;
            OctreeNode root = null;
            int token = data_in.readInt();
            int version = 0;
            if (token < 0) {
                version = data_in.readInt();
                size = data_in.readInt();
            } else {
                size = token;
            }
            int maxDepth = 0;
            for (int idx = 0; idx < size; ++idx) {
                try {
                    long pageId = version == 0 ? (long)data_in.readInt() : data_in.readLong();
                    float x = (float)((double)data_in.readFloat() * Constants.DISTANCE_SCALE_FACTOR);
                    float y = (float)((double)data_in.readFloat() * Constants.DISTANCE_SCALE_FACTOR);
                    float z = (float)((double)data_in.readFloat() * Constants.DISTANCE_SCALE_FACTOR);
                    float hsx = (float)((double)(data_in.readFloat() / 2.0f) * Constants.DISTANCE_SCALE_FACTOR);
                    float hsy = (float)((double)(data_in.readFloat() / 2.0f) * Constants.DISTANCE_SCALE_FACTOR);
                    float hsz = (float)((double)(data_in.readFloat() / 2.0f) * Constants.DISTANCE_SCALE_FACTOR);
                    long[] childrenIds = new long[8];
                    for (int i = 0; i < 8; ++i) {
                        childrenIds[i] = version == 0 ? (long)data_in.readInt() : data_in.readLong();
                    }
                    int depth = data_in.readInt();
                    int nObjects = data_in.readInt();
                    int ownObjects = data_in.readInt();
                    int childrenCount = data_in.readInt();
                    maxDepth = FastMath.max((int)maxDepth, (int)depth);
                    OctreeNode node = new OctreeNode(pageId, x, y, z, hsx, hsy, hsz, childrenCount, nObjects, ownObjects, depth);
                    this.nodesMap.put(pageId, new Pair<OctreeNode, long[]>(node, childrenIds));
                    if (status != null) {
                        node.setStatus(status);
                    }
                    if (depth != 0) continue;
                    root = node;
                    continue;
                }
                catch (EOFException eof) {
                    logger.error(eof);
                }
            }
            OctreeNode.maxDepth = maxDepth;
            if (root != null) {
                root.resolveChildren(this.nodesMap);
            } else {
                logger.error(new RuntimeException("No root node in visualization-metadata"));
            }
            return root;
        }
        catch (IOException e) {
            logger.error(e);
            return null;
        }
    }

    public OctreeNode readMetadataMapped(String file) {
        return this.readMetadataMapped(file, null);
    }

    public OctreeNode readMetadataMapped(String file, LoadStatus status) {
        OctreeNode octreeNode;
        this.nodesMap = new HashMap<Long, Pair<OctreeNode, long[]>>();
        RandomAccessFile f = new RandomAccessFile(Settings.settings.data.dataFile(file), "r");
        try {
            int size;
            FileChannel fc = f.getChannel();
            MappedByteBuffer mem = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            OctreeNode root = null;
            int token = mem.getInt();
            int version = 0;
            if (token < 0) {
                version = mem.getInt();
                size = mem.getInt();
            } else {
                size = token;
            }
            int maxDepth = 0;
            for (int idx = 0; idx < size; ++idx) {
                try {
                    long pageId = version == 0 ? (long)mem.getInt() : mem.getLong();
                    float x = (float)((double)mem.getFloat() * Constants.DISTANCE_SCALE_FACTOR);
                    float y = (float)((double)mem.getFloat() * Constants.DISTANCE_SCALE_FACTOR);
                    float z = (float)((double)mem.getFloat() * Constants.DISTANCE_SCALE_FACTOR);
                    float hsx = (float)((double)(mem.getFloat() / 2.0f) * Constants.DISTANCE_SCALE_FACTOR);
                    mem.position(mem.position() + 4);
                    mem.position(mem.position() + 4);
                    long[] childrenIds = new long[8];
                    for (int i = 0; i < 8; ++i) {
                        childrenIds[i] = version == 0 ? (long)mem.getInt() : mem.getLong();
                    }
                    int depth = mem.getInt();
                    int nObjects = mem.getInt();
                    int ownObjects = mem.getInt();
                    int childrenCount = mem.getInt();
                    maxDepth = FastMath.max((int)maxDepth, (int)depth);
                    float hsy = hsx;
                    float hsz = hsx;
                    OctreeNode node = new OctreeNode(pageId, x, y, z, hsx, hsy, hsz, childrenCount, nObjects, ownObjects, depth);
                    this.nodesMap.put(pageId, new Pair<OctreeNode, long[]>(node, childrenIds));
                    if (status != null) {
                        node.setStatus(status);
                    }
                    if (depth != 0) continue;
                    root = node;
                    continue;
                }
                catch (BufferUnderflowException bue) {
                    logger.error(bue);
                }
            }
            OctreeNode.maxDepth = maxDepth;
            if (root != null) {
                root.resolveChildren(this.nodesMap);
            } else {
                logger.error(new RuntimeException("No root node in visualization-metadata"));
            }
            fc.close();
            octreeNode = root;
        }
        catch (Throwable throwable) {
            try {
                try {
                    f.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.error(e);
                return null;
            }
        }
        f.close();
        return octreeNode;
    }

    public void writeMetadata(OctreeNode root, OutputStream out) {
        ArrayList<OctreeNode> nodes = new ArrayList<OctreeNode>();
        this.toList(root, nodes);
        DataOutputStream data_out = new DataOutputStream(out);
        try {
            data_out.writeInt(nodes.size());
            for (OctreeNode node : nodes) {
                data_out.writeInt((int)node.pageId);
                data_out.writeFloat((float)node.centre.x);
                data_out.writeFloat((float)node.centre.y);
                data_out.writeFloat((float)node.centre.z);
                data_out.writeFloat((float)node.size.x);
                data_out.writeFloat((float)node.size.y);
                data_out.writeFloat((float)node.size.z);
                for (int i = 0; i < 8; ++i) {
                    data_out.writeInt((int)(node.children[i] != null ? node.children[i].pageId : -1L));
                }
                data_out.writeInt(node.depth);
                data_out.writeInt(node.numObjectsRec);
                data_out.writeInt(node.numObjects);
                data_out.writeInt(node.numChildren);
            }
            data_out.close();
            out.close();
        }
        catch (IOException e) {
            logger.error(e);
        }
    }

    public void toList(OctreeNode node, List<OctreeNode> nodes) {
        nodes.add(node);
        for (OctreeNode child : node.children) {
            if (child == null) continue;
            this.toList(child, nodes);
        }
    }
}

