/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.group;

import gaiasky.data.api.IParticleGroupDataProvider;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.record.ParticleVector;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.parse.Parser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class PointDataProvider
implements IParticleGroupDataProvider {
    private static final Logger.Log logger = Logger.getLogger(PointDataProvider.class);
    private Matrix4D transform;
    private final Vector3D aux = new Vector3D();

    @Override
    public List<IParticleRecord> loadData(String file) {
        return this.loadData(file, 1.0);
    }

    @Override
    public List<IParticleRecord> loadData(String file, double factor) {
        List<IParticleRecord> pointData;
        InputStream is = Settings.settings.data.dataFileHandle(file).read();
        if (file.endsWith(".gz")) {
            try {
                is = new GZIPInputStream(Settings.settings.data.dataFileHandle(file).read());
            }
            catch (IOException e) {
                logger.error("File ends with '.gz' (" + file + ") but is not a Gzipped file!", e);
            }
        }
        if ((pointData = this.loadData(is, factor)) != null) {
            logger.info(I18n.msg("notif.nodeloader", pointData.size(), file));
        }
        return pointData;
    }

    @Override
    public List<IParticleRecord> loadData(InputStream is, double factor) {
        ArrayList<IParticleRecord> pointData = new ArrayList<IParticleRecord>();
        try (InputStream inputStream = is;){
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("#")) continue;
                try {
                    String[] tokens = line.split("\\s+");
                    int tokensLength = tokens.length;
                    double[] point = new double[tokensLength];
                    for (int j = 0; j < tokensLength; ++j) {
                        point[j] = j < 3 ? Parser.parseDouble(tokens[j]) * factor : Parser.parseDouble(tokens[j]);
                    }
                    if (this.transform != null) {
                        this.aux.set(point);
                        this.aux.mul(this.transform);
                        point[0] = this.aux.x;
                        point[1] = this.aux.y;
                        point[2] = this.aux.z;
                    }
                    pointData.add(new ParticleVector(point));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            br.close();
        }
        catch (Exception e) {
            logger.error(e);
            return null;
        }
        return pointData;
    }

    @Override
    public void setFileNumberCap(int cap) {
    }

    @Override
    public void setStarNumberCap(int cap) {
    }

    @Override
    public void setProviderParams(Map<String, Object> params) {
    }

    @Override
    public void setTransformMatrix(Matrix4D matrix) {
        this.transform = matrix;
    }

    @Override
    public List<IParticleRecord> loadDataMapped(String file, double factor) {
        return null;
    }
}

