/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.group;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.LongMap;
import com.badlogic.gdx.utils.ObjectMap;
import gaiasky.data.group.AbstractStarGroupDataProvider;
import gaiasky.data.group.DatasetOptions;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.record.Particle;
import gaiasky.scene.record.ParticleExt;
import gaiasky.scene.record.ParticleStar;
import gaiasky.scene.record.ParticleVariable;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.TextUtils;
import gaiasky.util.color.BVToTeffBallesteros;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.LinearInterpolator;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Vector2D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.parse.Parser;
import gaiasky.util.ucd.UCD;
import gaiasky.util.ucd.UCDParser;
import gaiasky.util.units.Position;
import gaiasky.util.units.Quantity;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import net.jafama.FastMath;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.formats.AsciiTableBuilder;
import uk.ac.starlink.table.formats.CsvTableBuilder;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;

public class STILDataProvider
extends AbstractStarGroupDataProvider {
    private static final String[] forbiddenNameValues;
    private StarTableFactory factory;
    private long objectId = 1L;
    private DatasetOptions datasetOptions;
    private List<ColumnInfo> columnInfoList;

    public STILDataProvider() {
        try {
            java.util.logging.Logger.getLogger("uk.ac.starlink").setLevel(Level.WARNING);
            java.util.logging.Logger.getLogger("org.astrogrid").setLevel(Level.WARNING);
            this.factory = new StarTableFactory();
            this.countsPerMag = new long[22];
            this.initLists();
        }
        catch (Exception e) {
            this.factory = null;
            logger.error(e);
        }
    }

    public void setDatasetOptions(DatasetOptions datasetOptions) {
        this.datasetOptions = datasetOptions;
    }

    @Override
    public List<IParticleRecord> loadData(String file, double factor) {
        logger.info(I18n.msg("notif.datafile", file));
        try {
            this.loadData((DataSource)new FileDataSource(Settings.settings.data.dataFile(file)), factor);
        }
        catch (Exception e1) {
            try {
                logger.info("File " + file + " not found in data folder, trying relative path");
                this.loadData((DataSource)new FileDataSource(file), factor);
            }
            catch (Exception e2) {
                logger.error(e1);
                logger.error(e2);
            }
        }
        logger.info(I18n.msg("notif.nodeloader", this.list.size(), file));
        return this.list;
    }

    private Pair<UCD, Double> getDoubleUcd(Array<UCD> UCDs, Object[] row) {
        for (UCD ucd : UCDs) {
            try {
                double num = ((Number)row[ucd.index]).doubleValue();
                if (Double.isNaN(num)) {
                    throw new Exception();
                }
                return new Pair<UCD, Double>(ucd, num);
            }
            catch (Exception e0) {
                try {
                    double num = Parser.parseDouble((String)row[ucd.index]);
                    if (Double.isNaN(num)) {
                        throw new Exception();
                    }
                    return new Pair<UCD, Double>(ucd, num);
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    private Pair<UCD, double[]> getDoubleArrayUcd(Array<UCD> UCDs, Object[] row) {
        for (UCD ucd : UCDs) {
            try {
                double[] nums = (double[])row[ucd.index];
                return new Pair<UCD, double[]>(ucd, nums);
            }
            catch (Exception e0) {
                try {
                    double[] nums = Parser.parseDoubleArray((String)row[ucd.index]);
                    return new Pair<UCD, double[]>(ucd, nums);
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    private Pair<UCD, String> getStringUcd(Array<UCD> UCDs, Object[] row) {
        for (UCD ucd : UCDs) {
            try {
                String str = row[ucd.index].toString().strip();
                return new Pair<UCD, String>(ucd, str);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private Pair<UCD, String>[] getAllStringsUcd(Array<UCD> UCDs, Object[] row) {
        Array strings = new Array(false, 2);
        for (UCD ucd : UCDs) {
            try {
                String str = row[ucd.index].toString().strip();
                strings.add(new Pair<UCD, String>(ucd, str));
            }
            catch (Exception exception) {}
        }
        Pair[] result = new Pair[strings.size];
        int i = 0;
        for (Pair value : strings) {
            result[i++] = value;
        }
        return result;
    }

    public List<IParticleRecord> loadData(DataSource ds, double factor) {
        return this.loadData(ds, factor, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IParticleRecord> loadData(DataSource ds, double factor, Runnable preCallback, BiConsumer<Long, Long> updateCallback, Runnable postCallback) {
        block77: {
            try {
                if (this.factory == null) break block77;
                List builders = this.factory.getDefaultBuilders();
                builders.add(new CsvTableBuilder());
                builders.add(new AsciiTableBuilder());
                if (preCallback != null) {
                    preCallback.run();
                }
                StarTable table = this.factory.makeStarTable(ds);
                long count = table.getRowCount();
                this.initLists((int)count);
                UCDParser ucdParser = new UCDParser();
                ucdParser.parse(table);
                int numColumns = table.getColumnCount();
                if (this.columnInfoList == null) {
                    this.columnInfoList = new ArrayList<ColumnInfo>(numColumns);
                } else {
                    this.columnInfoList.clear();
                }
                for (int i = 0; i < numColumns; ++i) {
                    this.columnInfoList.add(table.getColumnInfo(i));
                }
                if (this.datasetOptions != null && (ucdParser.hasPm || ucdParser.hasSize || ucdParser.hasColor) && (this.datasetOptions.type == null || this.datasetOptions.type == DatasetOptions.DatasetLoadType.PARTICLES)) {
                    this.datasetOptions.type = DatasetOptions.DatasetLoadType.PARTICLES_EXT;
                }
                boolean isStars = this.datasetOptions == null || this.isAnyType(DatasetOptions.DatasetLoadType.VARIABLES, DatasetOptions.DatasetLoadType.STARS);
                int resampledLightCurves = 0;
                int noPeriods = 0;
                if (ucdParser.hasPos) {
                    BVToTeffBallesteros bvToTEff = new BVToTeffBallesteros();
                    int nInvalidParallaxes = 0;
                    long i = 0L;
                    long step = FastMath.max((long)1L, (long)FastMath.round((double)((double)count / 100.0)));
                    RowSequence rs = table.getRowSequence();
                    while (rs.next()) {
                        Object[] row = rs.getRow();
                        try {
                            String[] names;
                            int hipIndex;
                            Object hipNum;
                            long id;
                            float colorPacked;
                            Pair<UCD, Double> tEffPair;
                            int k;
                            Pair<UCD, Double> colPair;
                            Pair<UCD, Double> appMagPair;
                            Vector3D pm;
                            String unitC;
                            Pair<Object, Double> c;
                            Pair<UCD, Double> a = this.getDoubleUcd(ucdParser.POS1, row);
                            Pair<UCD, Double> b = this.getDoubleUcd(ucdParser.POS2, row);
                            Pair<UCD, Double> pos3 = this.getDoubleUcd(ucdParser.POS3, row);
                            if (ucdParser.POS3.isEmpty() || pos3 == null || pos3.getSecond() == null || !Double.isFinite(pos3.getSecond())) {
                                c = new Pair<Object, Double>(null, 0.04);
                                unitC = "mas";
                                ++nInvalidParallaxes;
                            } else {
                                c = this.getDoubleUcd(ucdParser.POS3, row);
                                assert (c != null);
                                unitC = ((UCD)c.getFirst()).unit;
                            }
                            assert (a != null);
                            assert (b != null);
                            Position.PositionType pt = ucdParser.getPositionType(a.getFirst(), b.getFirst(), (UCD)c.getFirst());
                            if (pt.isParallax() && (c.getSecond() == null || c.getSecond().isNaN() || c.getSecond() <= 0.0)) {
                                c.setSecond(0.04);
                                unitC = "mas";
                                ++nInvalidParallaxes;
                            }
                            Position p = new Position(a.getSecond(), a.getFirst().unit, b.getSecond(), b.getFirst().unit, c.getSecond(), unitC, pt);
                            p.realPosition.scl(factor);
                            double distPc = p.realPosition.len();
                            if (pt.isParallax() && c.getSecond() <= 0.0 || !Double.isFinite(distPc) || distPc < 0.0) break;
                            p.realPosition.scl(Constants.PC_TO_U);
                            if (this.transform != null) {
                                p.realPosition.mul(this.transform);
                            }
                            Vector3D sph = new Vector3D();
                            Coordinates.cartesianToSpherical(p.realPosition, sph);
                            double muAlphaStar = 0.0;
                            double muDelta = 0.0;
                            double radVel = 0.0;
                            if (pt == Position.PositionType.EQ_SPH_DIST || pt == Position.PositionType.EQ_SPH_PLX) {
                                Pair<UCD, Double> pma = this.getDoubleUcd(ucdParser.PMRA, row);
                                Pair<UCD, Double> pmb = this.getDoubleUcd(ucdParser.PMDEC, row);
                                Pair<UCD, Double> pmc = this.getDoubleUcd(ucdParser.RADVEL, row);
                                muAlphaStar = pma != null ? pma.getSecond() : 0.0;
                                muDelta = pmb != null ? pmb.getSecond() : 0.0;
                                radVel = pmc != null ? pmc.getSecond() : Double.NaN;
                                double radVelValue = Double.isFinite(radVel) ? radVel : 0.0;
                                double raRad = new Quantity.Angle((double)a.getSecond(), a.getFirst().unit).get(Quantity.Angle.AngleUnit.RAD);
                                double decRad = new Quantity.Angle((double)b.getSecond(), b.getFirst().unit).get(Quantity.Angle.AngleUnit.RAD);
                                pm = Coordinates.properMotionsToCartesian(muAlphaStar, muDelta, radVelValue, raRad, decRad, distPc, new Vector3D());
                            } else {
                                pm = new Vector3D(Vector3D.Zero);
                            }
                            double appMag = !ucdParser.MAG.isEmpty() ? ((appMagPair = this.getDoubleUcd(ucdParser.MAG, row)) == null ? 15.0 : appMagPair.getSecond()) : 15.0;
                            double magScl = isStars && this.datasetOptions != null ? this.datasetOptions.magnitudeScale : 0.0;
                            double absMag = AstroUtils.apparentToAbsoluteMagnitude(distPc, appMag -= magScl);
                            double sizePc = AstroUtils.absoluteMagnitudeToPseudoSize(absMag);
                            if (!ucdParser.SIZE.isEmpty()) {
                                if (!isStars) {
                                    Pair<UCD, Double> sizePair = this.getDoubleUcd(ucdParser.SIZE, row);
                                    UCD sizeUcd = sizePair.getFirst();
                                    if (sizeUcd != null && sizeUcd.unit != null) {
                                        if (Quantity.Angle.isAngle(sizeUcd.unit)) {
                                            double sa = new Quantity.Angle((double)sizePair.getSecond(), sizePair.getFirst().unit).get(Quantity.Angle.AngleUnit.RAD);
                                            sizePc = FastMath.tan((double)sa) * distPc;
                                        } else if (Quantity.Length.isLength(sizeUcd.unit)) {
                                            sizePc = new Quantity.Length((double)sizePair.getSecond(), sizePair.getFirst().unit).get(Quantity.Length.LengthUnit.PC);
                                        }
                                    } else {
                                        sizePc = sizePair.getSecond().floatValue();
                                    }
                                    if (TextUtils.containsOrMatches(UCDParser.radiusColNames, sizeUcd.colName, true)) {
                                        sizePc *= 2.0;
                                    }
                                }
                            } else if (!isStars) {
                                Object value;
                                double maxSizePc = 3.0;
                                if (this.params != null && this.params.containsKey("maxSizePc") && (value = this.params.get("maxSizePc")) instanceof Number) {
                                    Number n = (Number)value;
                                    maxSizePc = n.doubleValue();
                                }
                                sizePc = MathUtilsDouble.clamp(sizePc, 1.0E-8, maxSizePc);
                            }
                            float colorIndex = !ucdParser.COL.isEmpty() ? ((colPair = this.getDoubleUcd(ucdParser.COL, row)) == null ? 0.656f : colPair.getSecond().floatValue()) : (isStars ? 0.656f : Float.NaN);
                            float[] variMags = null;
                            double[] variTimes = null;
                            double pf = 0.0;
                            int nVari = 0;
                            if (ucdParser.hasVariability) {
                                Pair<UCD, Double> period = this.getDoubleUcd(ucdParser.VARI_PERIOD, row);
                                if (!ucdParser.hasPeriod || period == null || !Double.isFinite(period.getSecond())) {
                                    ++noPeriods;
                                    continue;
                                }
                                pf = period.getSecond();
                                Pair<UCD, double[]> variMagsPair = this.getDoubleArrayUcd(ucdParser.VARI_MAGS, row);
                                assert (variMagsPair != null);
                                double[] variMagsDouble = variMagsPair.getSecond();
                                nVari = variMagsDouble.length;
                                variMags = new float[nVari];
                                Pair<UCD, double[]> variTimesPair = this.getDoubleArrayUcd(ucdParser.VARI_TIMES, row);
                                assert (variTimesPair != null);
                                variTimes = variTimesPair.getSecond();
                                double[] auxMags = variMagsDouble;
                                double[] auxTimes = variTimes;
                                ArrayList<Double> magnitudesList = new ArrayList<Double>();
                                ArrayList<Double> timesList = new ArrayList<Double>();
                                int idx = 0;
                                for (double mag : auxMags) {
                                    if (Double.isFinite(mag)) {
                                        magnitudesList.add(mag - magScl);
                                        timesList.add(auxTimes[idx]);
                                    }
                                    ++idx;
                                }
                                variMagsDouble = magnitudesList.stream().mapToDouble(Double::doubleValue).toArray();
                                variTimes = timesList.stream().mapToDouble(Double::doubleValue).toArray();
                                nVari = variMagsDouble.length;
                                ArrayList<Vector2D> list = new ArrayList<Vector2D>(nVari);
                                for (k = 0; k < nVari; ++k) {
                                    double phase = (variTimes[k] - variTimes[0]) % pf;
                                    list.add(new Vector2D(phase, variMagsDouble[k]));
                                }
                                list.sort(Comparator.comparingDouble(o -> o.x));
                                for (k = 0; k < nVari; ++k) {
                                    Vector2D point = (Vector2D)list.get(k);
                                    variTimes[k] = point.x + variTimes[0];
                                    variMagsDouble[k] = point.y;
                                }
                                int MAX_VARI = 20;
                                if (variMagsDouble.length > 20) {
                                    nVari = 20;
                                    double t0 = variTimes[0];
                                    double tn = variTimes[variTimes.length - 1];
                                    double tStep = (tn - t0) / (double)(nVari - 1);
                                    LinearInterpolator linearInterpolator = new LinearInterpolator(variTimes, variMagsDouble);
                                    variMagsDouble = new double[nVari];
                                    variTimes = new double[nVari];
                                    for (idx = 0; idx < nVari; ++idx) {
                                        double t;
                                        variTimes[idx] = t = t0 + tStep * (double)idx;
                                        variMagsDouble[idx] = linearInterpolator.value(t);
                                    }
                                    ++resampledLightCurves;
                                }
                                assert (variMags.length == variTimes.length);
                                for (int j = 0; j < variMagsDouble.length; ++j) {
                                    double variAbsoluteMag = AstroUtils.apparentToAbsoluteMagnitude(distPc, variMagsDouble[j]);
                                    variMags[j] = (float)AstroUtils.absoluteMagnitudeToPseudoSize(variAbsoluteMag);
                                }
                            }
                            float tEff = !ucdParser.TEFF.isEmpty() ? ((tEffPair = this.getDoubleUcd(ucdParser.TEFF, row)) != null ? tEffPair.getSecond().floatValue() : (float)bvToTEff.bvToTeff(colorIndex)) : (float)bvToTEff.bvToTeff(colorIndex);
                            float[] rgb = null;
                            if (Float.isFinite(colorIndex)) {
                                rgb = ColorUtils.BVtoRGB(colorIndex);
                                colorPacked = Color.toFloatBits((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)1.0f);
                            } else if (Float.isFinite(tEff)) {
                                rgb = ColorUtils.tEffToRGB_harre(tEff);
                                colorPacked = Color.toFloatBits((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)1.0f);
                            } else {
                                colorPacked = Float.NaN;
                            }
                            boolean idIsNotNumber = false;
                            int hip = -1;
                            if (!ucdParser.ID.isEmpty()) {
                                Pair<UCD, String> idPair = this.getStringUcd(ucdParser.ID, row);
                                assert (idPair != null);
                                try {
                                    id = Parser.parseLongException(idPair.getSecond());
                                    if (isStars && idPair.getFirst().colName.equalsIgnoreCase("hip")) {
                                        hip = (int)id;
                                    }
                                }
                                catch (NumberFormatException e) {
                                    id = ++this.objectId;
                                    idIsNotNumber = true;
                                }
                            } else {
                                id = ++this.objectId;
                            }
                            if (hip < 0 && this.hasCol(AbstractStarGroupDataProvider.ColId.hip) && (hipNum = row[hipIndex = this.idx(AbstractStarGroupDataProvider.ColId.hip)]) instanceof Integer) {
                                Integer hn = (Integer)hipNum;
                                hip = hn;
                            }
                            if (ucdParser.NAME.isEmpty()) {
                                if (idIsNotNumber) {
                                    Pair<UCD, String> idPair = this.getStringUcd(ucdParser.ID, row);
                                    names = new String[]{idPair.getSecond()};
                                } else {
                                    names = new String[]{Long.toString(id)};
                                }
                            } else {
                                Pair<UCD, String>[] namePairs = this.getAllStringsUcd(ucdParser.NAME, row);
                                Array namesArray = new Array(false, namePairs.length);
                                for (Pair<UCD, String> pair : namePairs) {
                                    String[] currNames;
                                    for (String actualName : currNames = pair.getSecond().split("\\|")) {
                                        if (actualName == null || actualName.isEmpty() || TextUtils.contains(forbiddenNameValues, actualName, true)) continue;
                                        namesArray.add((Object)actualName);
                                    }
                                }
                                names = new String[namesArray.size];
                                k = 0;
                                for (String n : namesArray) {
                                    names[k++] = n;
                                }
                                if (names.length == 0) {
                                    names = new String[]{Long.toString(id)};
                                }
                            }
                            if (rgb != null) {
                                this.colors.put(id, (Object)rgb);
                            }
                            this.sphericalPositions.put(id, (Object)new double[]{sph.x, sph.y, sph.z});
                            if (this.datasetOptions == null || this.datasetOptions.type == DatasetOptions.DatasetLoadType.STARS || this.datasetOptions.type == DatasetOptions.DatasetLoadType.VARIABLES) {
                                int appMagClamp;
                                ObjectMap<UCD, Object> extraAttributes = this.addExtraAttributes(ucdParser, row);
                                if (ucdParser.TEFF.isEmpty()) {
                                    UCD tEffUCD = new UCD("phys.temperature.effective", "teff", "K", -1);
                                    extraAttributes = this.initExtraAttributes(extraAttributes);
                                    extraAttributes.put((Object)tEffUCD, (Object)Float.valueOf(tEff));
                                } else {
                                    extraAttributes = this.initExtraAttributes(extraAttributes);
                                    extraAttributes.put((Object)((UCD)ucdParser.TEFF.first()), (Object)Float.valueOf(tEff));
                                }
                                pr = this.datasetOptions != null && this.datasetOptions.type == DatasetOptions.DatasetLoadType.VARIABLES || variMags != null ? new ParticleVariable(id, names, p.realPosition.x, p.realPosition.y, p.realPosition.z, (float)muAlphaStar, (float)muDelta, (float)radVel, (float)pm.x, (float)pm.y, (float)pm.z, (float)appMag, (float)absMag, colorPacked, (float)sizePc, hip, tEff, nVari, pf, variMags, variTimes, extraAttributes) : new ParticleStar(id, names, p.realPosition.x, p.realPosition.y, p.realPosition.z, (float)muAlphaStar, (float)muDelta, (float)radVel, (float)pm.x, (float)pm.y, (float)pm.z, (float)appMag, (float)absMag, colorPacked, (float)sizePc, hip, tEff, extraAttributes);
                                this.list.add(pr);
                                int n = appMagClamp = (int)MathUtilsDouble.clamp(appMag, 0.0, 21.0);
                                this.countsPerMag[n] = this.countsPerMag[n] + 1L;
                            } else if (this.datasetOptions.type == DatasetOptions.DatasetLoadType.PARTICLES) {
                                ObjectMap<UCD, Object> extraAttributes = this.addExtraAttributes(ucdParser, row);
                                pr = new Particle(id, names, (float)p.realPosition.x, (float)p.realPosition.y, (float)p.realPosition.z, extraAttributes);
                                this.list.add(pr);
                            } else if (this.datasetOptions.type == DatasetOptions.DatasetLoadType.PARTICLES_EXT) {
                                ObjectMap<UCD, Object> extraAttributes = this.addExtraAttributes(ucdParser, row);
                                pr = new ParticleExt(id, names, p.realPosition.x, p.realPosition.y, p.realPosition.z, (float)muAlphaStar, (float)muDelta, (float)radVel, (float)pm.x, (float)pm.y, (float)pm.z, (float)appMag, (float)absMag, colorPacked, (float)(sizePc * Constants.PC_TO_U), extraAttributes);
                                this.list.add(pr);
                            }
                        }
                        catch (Exception e) {
                            logger.debug(e);
                            logger.debug(I18n.msg("debug.parse.row.skip", i));
                        }
                        if (updateCallback == null || ++i % step != 0L) continue;
                        updateCallback.accept(i, count);
                    }
                    if (nInvalidParallaxes > 0) {
                        logger.warn(I18n.msg("warn.star.parallax", nInvalidParallaxes, 0.04));
                    }
                    if (resampledLightCurves > 0) {
                        logger.warn(I18n.msg("warn.star.vari.resample", resampledLightCurves, 20));
                    }
                    if (noPeriods > 0) {
                        logger.warn(I18n.msg("warn.star.vari.noperiod", noPeriods));
                    }
                    break block77;
                }
                String msg = I18n.msg("error.star.noposition");
                logger.error(msg);
                EventManager.instance.post(Event.POST_POPUP_NOTIFICATION, this, msg);
            }
            catch (Exception e) {
                logger.error(e);
            }
            finally {
                if (postCallback != null) {
                    postCallback.run();
                }
            }
        }
        return this.list;
    }

    @Override
    protected boolean hasCol(AbstractStarGroupDataProvider.ColId colId) {
        for (ColumnInfo ci : this.columnInfoList) {
            if (!ci.getName().equals(colId.name())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int idx(AbstractStarGroupDataProvider.ColId colId) {
        int idx = 0;
        for (ColumnInfo ci : this.columnInfoList) {
            if (ci.getName().equals(colId.name())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    private ObjectMap<UCD, Object> initExtraAttributes(ObjectMap<UCD, Object> extra) {
        if (extra == null) {
            extra = new ObjectMap(5);
        }
        return extra;
    }

    private ObjectMap<UCD, Object> addExtraAttributes(UCDParser ucdParser, Object[] row) {
        ObjectMap extraAttributes = null;
        for (UCD extra : ucdParser.extra) {
            Object val = row[extra.index];
            if (extraAttributes == null) {
                extraAttributes = new ObjectMap((int)((float)ucdParser.extra.size * 1.25f), 0.8f);
            }
            extraAttributes.put((Object)extra, val);
        }
        return extraAttributes;
    }

    private boolean isOfType(DatasetOptions.DatasetLoadType type) {
        return this.datasetOptions != null && this.datasetOptions.type != null && this.datasetOptions.type == type;
    }

    private boolean isAnyType(DatasetOptions.DatasetLoadType ... types) {
        for (DatasetOptions.DatasetLoadType type : types) {
            if (!this.isOfType(type)) continue;
            return true;
        }
        return false;
    }

    public List<ColumnInfo> getColumnInfoList() {
        return this.columnInfoList;
    }

    @Override
    public List<IParticleRecord> loadData(InputStream is, double factor) {
        return null;
    }

    @Override
    public List<IParticleRecord> loadDataMapped(String file, double factor) {
        return null;
    }

    @Override
    public void setFileNumberCap(int cap) {
    }

    @Override
    public LongMap<float[]> getColors() {
        return null;
    }

    @Override
    public void setParallaxErrorFactorFaint(double parallaxErrorFactor) {
    }

    @Override
    public void setParallaxErrorFactorBright(double parallaxErrorFactor) {
    }

    @Override
    public void setParallaxZeroPoint(double parallaxZeroPoint) {
    }

    @Override
    public void setMagCorrections(boolean magCorrections) {
    }

    @Override
    public void setProviderParams(Map<String, Object> params) {
        super.setProviderParams(params);
        this.datasetOptionsFromParameters();
    }

    private void datasetOptionsFromParameters() {
        if (this.params != null) {
            DatasetOptions dOps = new DatasetOptions();
            if (this.params.containsKey("catalogName")) {
                dOps.catalogName = (String)this.params.get("catalogName");
            }
            if (this.params.containsKey("type")) {
                String typeStr = (String)this.params.get("type");
                dOps.type = DatasetOptions.DatasetLoadType.valueOf(typeStr.toUpperCase(Locale.ROOT));
            }
            if (this.params.containsKey("labelColor")) {
                dOps.labelColor = (double[])this.params.get("labelColor");
            }
            if (this.params.containsKey("magnitudeScale")) {
                dOps.magnitudeScale = (Double)this.params.get("magnitudeScale");
            }
            if (this.params.containsKey("fadeIn")) {
                dOps.fadeIn = (double[])this.params.get("fadeIn");
            }
            if (this.params.containsKey("fadeOut")) {
                dOps.fadeOut = (double[])this.params.get("fadeOut");
            }
            this.datasetOptions = dOps;
        }
    }

    static {
        logger = Logger.getLogger(STILDataProvider.class);
        forbiddenNameValues = new String[]{"-", "...", "nop", "nan", "?", "_", "x", "n/a"};
    }
}

