/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.orbit;

import gaiasky.data.util.PointCloudData;
import gaiasky.util.Constants;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.math.Vector3D;
import gaiasky.util.parse.Parser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Timestamp;
import java.time.Instant;

public class FileDataLoader {
    public long parseTime(String token) {
        try {
            Timestamp t = Timestamp.valueOf(token.replace('_', ' '));
            return t.getTime();
        }
        catch (Exception e) {
            double jd = Parser.parseDouble(token);
            return AstroUtils.julianDateToInstant(jd).toEpochMilli();
        }
    }

    public PointCloudData load(InputStream data) throws Exception {
        String line;
        PointCloudData orbitData = new PointCloudData();
        BufferedReader br = new BufferedReader(new InputStreamReader(data));
        long last = 0L;
        while ((line = br.readLine()) != null) {
            long t;
            String[] tokens;
            if ((line = line.trim()).isBlank() || line.startsWith("#") || (tokens = line.split("\\s+")).length < 4 || (t = this.parseTime(tokens[0].trim())) == last) continue;
            Vector3D pos = new Vector3D(this.parsed(tokens[1]), this.parsed(tokens[2]), this.parsed(tokens[3]));
            pos.scl(Constants.KM_TO_U);
            orbitData.addPoint(pos, Instant.ofEpochMilli(t));
            last = t;
        }
        br.close();
        return orbitData;
    }

    protected float parsef(String str) {
        return Parser.parseFloat(str);
    }

    protected double parsed(String str) {
        return Parser.parseDouble(str);
    }

    protected int parsei(String str) {
        return Parser.parseInt(str);
    }
}

