/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.orbit;

import gaiasky.data.util.PointCloudData;
import gaiasky.util.Constants;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector3D;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Timestamp;
import java.util.Calendar;

public class FileDataLoaderEclipticJulianTime {
    public PointCloudData load(InputStream data) throws Exception {
        String line;
        PointCloudData orbitData = new PointCloudData();
        BufferedReader br = new BufferedReader(new InputStreamReader(data));
        Timestamp last = new Timestamp(0L);
        while ((line = br.readLine()) != null) {
            String[] tokens;
            if (line.isEmpty() || line.startsWith("#") || (tokens = line.split("\\s+")).length < 4) continue;
            Timestamp t = new Timestamp(this.getTime(tokens[0]));
            Matrix4D transform = new Matrix4D();
            transform.scl(Constants.KM_TO_U);
            if (t.equals(last)) continue;
            Vector3D pos = new Vector3D(this.parseDouble(tokens[1]), this.parseDouble(tokens[2]), this.parseDouble(tokens[3]));
            pos.mul(transform);
            orbitData.addPoint(pos, t.toInstant());
            last.setTime(t.getTime());
        }
        br.close();
        return orbitData;
    }

    protected float parseFloat(String str) {
        return Float.parseFloat(str);
    }

    protected double parseDouble(String str) {
        return Double.parseDouble(str);
    }

    protected int parseInt(String str) {
        return Integer.parseInt(str);
    }

    private long getTime(String jds) {
        double jd = Double.parseDouble(jds);
        long[] dt = AstroUtils.getCalendarDay(jd);
        Calendar cld = Calendar.getInstance();
        cld.set((int)dt[0], (int)dt[1], (int)dt[2], (int)dt[3], (int)dt[4], (int)dt[5]);
        return cld.getTimeInMillis();
    }
}

