/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.orbit;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Files;
import com.badlogic.gdx.files.FileHandle;
import gaiasky.data.orbit.OrbitDataWriter;
import gaiasky.data.util.PointCloudData;
import gaiasky.gui.main.ConsoleLogger;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SettingsManager;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector3D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.Instant;
import java.util.Calendar;

public class HeliotropicOrbitDataLoader {
    static Logger.Log logger = Logger.getLogger(HeliotropicOrbitDataLoader.class);
    int count = 0;
    long maxMsSep = 43200000L;

    public static void main(String[] args) {
        HeliotropicOrbitDataLoader l = new HeliotropicOrbitDataLoader();
        try {
            String ASSETS_LOC = Settings.ASSETS_LOC;
            new ConsoleLogger();
            Gdx.files = new Lwjgl3Files();
            SettingsManager.initialize(new FileInputStream(ASSETS_LOC + "/conf/config.yaml"), new FileInputStream(ASSETS_LOC + "/dummyversion"));
            I18n.initialize(new FileHandle(ASSETS_LOC + "/i18n/gsbundle"), new FileHandle(ASSETS_LOC + "/i18n/objects"));
            String inputFile = System.getProperty("user.home") + "/Downloads/orbit.JWST.heliotropic.csv";
            String outputFile = System.getProperty("user.home") + "/Downloads/orbit.JWST.dat";
            PointCloudData od = l.load(new FileInputStream(inputFile));
            logger.info("Loaded and converted " + od.getNumPoints() + " orbit data points: " + inputFile);
            OrbitDataWriter.writeOrbitData(outputFile, od);
            logger.info("Results written successfully: " + outputFile);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public PointCloudData load(InputStream data) throws Exception {
        String line;
        PointCloudData orbitData = new PointCloudData();
        BufferedReader br = new BufferedReader(new InputStreamReader(data));
        Instant previousAddedTime = null;
        int lineNum = 1;
        while ((line = br.readLine()) != null) {
            if (lineNum > 1 && !line.isEmpty() && !line.startsWith("#")) {
                String[] tokens = line.split(",");
                try {
                    boolean add;
                    double jd = this.parsed(tokens[0]);
                    Instant time = AstroUtils.julianDateToInstant(jd);
                    Vector3D pos = new Vector3D(this.parsed(tokens[2]), this.parsed(tokens[3]), -this.parsed(tokens[1]));
                    Vector3D posHel = this.correctSunLongitude(pos, time);
                    pos.mul(Coordinates.eqToEcl());
                    posHel.mul(Coordinates.eqToEcl());
                    boolean bl = add = this.count == 0 || previousAddedTime == null || time.toEpochMilli() - previousAddedTime.toEpochMilli() >= this.maxMsSep;
                    if (add) {
                        orbitData.addPoint(posHel.x * Constants.KM_TO_U, posHel.y * Constants.KM_TO_U, posHel.z * Constants.KM_TO_U, time);
                        previousAddedTime = time;
                    }
                    ++this.count;
                }
                catch (Exception e) {
                    logger.error("Error loading line: " + this.count);
                }
            }
            ++lineNum;
        }
        br.close();
        return orbitData;
    }

    protected float parsef(String str) {
        return Float.parseFloat(str);
    }

    protected double parsed(String str) {
        return Double.parseDouble(str);
    }

    protected int parsei(String str) {
        return Integer.parseInt(str);
    }

    protected Vector3D correctSunLongitude(Vector3D pos, Instant t) {
        Vector3D upDirection = new Vector3D(0.0, 1.0, 0.0);
        upDirection.mul(Coordinates.eclToEq());
        return pos.cpy().rotate(upDirection, AstroUtils.getSunLongitude(t) - 0.0);
    }

    private float getYearFraction(int year, int month, int day, int hour, int min, int sec) {
        return (float)year + (float)month / 12.0f + (float)day / 365.242f + (float)hour / 8765.81f + (float)min / 525949.0f + (float)sec / 3.155694E7f;
    }

    private float getYearFraction(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        return this.getYearFraction(year, month, day, hour, min, sec);
    }

    public void writeDistVsTimeData(String filePath, PointCloudData data) throws Exception {
        File file = new File(filePath);
        if (file.exists() && !file.delete()) {
            logger.warn("Could not delete file: " + String.valueOf(file));
        }
        if (!file.exists() && !file.createNewFile()) {
            logger.warn("Could not create file: " + String.valueOf(file));
        }
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write("#time[ms] time[year] dist[km]");
        bw.newLine();
        long iniTime = -1L;
        int n = data.samples.size();
        for (int i = 0; i < n; ++i) {
            long time;
            PointCloudData.PointSample p = data.samples.get(i);
            Vector3D pos = new Vector3D(p.x(), p.y(), p.z());
            long t = p.toEpochMilli();
            long l = time = iniTime < 0L ? 0L : t - iniTime;
            if (time == 0L) {
                iniTime = t;
            }
            float timeYearFraction = this.getYearFraction(iniTime + time);
            bw.write(time + " " + timeYearFraction + " " + pos.len());
            bw.newLine();
        }
        bw.close();
    }
}

