/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.orbit;

import com.badlogic.ashley.core.Entity;
import gaiasky.data.api.IOrbitDataProvider;
import gaiasky.data.util.OrbitDataLoader;
import gaiasky.data.util.PointCloudData;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Trajectory;
import gaiasky.util.Logger;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.time.Instant;
import net.jafama.FastMath;

public class OrbitBodyDataProvider
implements IOrbitDataProvider {
    private static final String writeDataPath = "/tmp/";
    private static final boolean writeData = false;
    private int i = 1;
    private PointCloudData data;
    private PointCloudData data0;
    private PointCloudData data1;
    private Trajectory trajectory;
    private final Vector3Q aux1 = new Vector3Q();
    private final Vector3D aux2 = new Vector3D();

    @Override
    public void initialize(Entity entity, Trajectory trajectory) {
        this.trajectory = trajectory;
    }

    private PointCloudData getNextData(int numSamples) {
        this.i = (this.i + 1) % 2;
        if (this.i == 0) {
            if (this.data0 == null) {
                this.data0 = new PointCloudData(numSamples);
            } else {
                this.data0.clear();
            }
            return this.data0;
        }
        if (this.data1 == null) {
            this.data1 = new PointCloudData(numSamples);
        } else {
            this.data1.clear();
        }
        return this.data1;
    }

    @Override
    public void load(String file, OrbitDataLoader.OrbitDataLoaderParameters parameter) {
        Entity body;
        gaiasky.scene.component.Coordinates coordinates;
        if (this.trajectory.body != null && (coordinates = (gaiasky.scene.component.Coordinates)Mapper.coordinates.get(body = this.trajectory.body)) != null && coordinates.coordinates != null) {
            Instant d;
            double period = parameter.orbitalPeriod * 0.999;
            int numSamples = parameter.numSamples > 0 ? parameter.numSamples : (int)(300.0 * period / 365.0);
            numSamples = FastMath.max((int)200, (int)FastMath.min((int)2000, (int)numSamples));
            this.data = this.getNextData(numSamples);
            String bodyDesc = parameter.name;
            double last = 0.0;
            double cumulative = 0.0;
            long orbitalMs = (long)(period * 8.64E7);
            long stepMs = orbitalMs / (long)numSamples;
            if (parameter.force) {
                d = Instant.ofEpochMilli(parameter.ini.getTime());
                parameter.setForce(false);
            } else {
                d = this.trajectory.refreshRate >= 0.0 ? Instant.ofEpochMilli(parameter.ini.getTime() - (long)((double)orbitalMs * this.trajectory.refreshRate)) : (period > 40000.0 ? Instant.ofEpochMilli(parameter.ini.getTime() - (long)((double)orbitalMs * 0.8)) : (parameter.entity != null && ((Base)Mapper.base.get((Entity)parameter.entity)).ct.isEnabled(ComponentTypes.ComponentType.Moons) ? Instant.ofEpochMilli(parameter.ini.getTime() - (long)((double)orbitalMs * 0.4)) : Instant.ofEpochMilli(parameter.ini.getTime())));
            }
            long t = 0L;
            for (int i = 0; i <= numSamples; ++i) {
                coordinates.coordinates.getEclipticCartesianCoordinates(d, this.aux1);
                Coordinates.cartesianToSpherical(this.aux1, this.aux2);
                double eclX = this.aux2.x;
                if (last == 0.0) {
                    last = FastMath.toDegrees((double)eclX);
                }
                last = FastMath.toDegrees((double)eclX);
                if ((cumulative += FastMath.toDegrees((double)eclX) - last) > 359.0 || (double)(t + stepMs) > period * 8.64E7) break;
                this.aux1.mul(Coordinates.eclToEq());
                this.data.addPoint(this.aux1.x.doubleValue(), this.aux1.y.doubleValue(), this.aux1.z.doubleValue(), d);
                d = Instant.ofEpochMilli(d.toEpochMilli() + stepMs);
                t += stepMs;
            }
            PointCloudData.PointSample f = this.data.samples.getFirst();
            this.data.addPoint(f.x(), f.y(), f.z(), d);
            Logger.getLogger(this.getClass()).info(I18n.msg("notif.orbitdataof.loaded", parameter.name, this.data.getNumPoints()));
        }
    }

    @Override
    public void load(String file, OrbitDataLoader.OrbitDataLoaderParameters source, boolean newMethod) {
        this.load(file, source);
    }

    @Override
    public PointCloudData getData() {
        return this.data;
    }
}

