/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.orbit;

import gaiasky.data.util.PointCloudData;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class OrbitDataWriter {
    private static final Logger.Log logger = Logger.getLogger(OrbitDataWriter.class);

    public static void writeOrbitData(String filePath, PointCloudData data) throws IOException {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH:mm:ss").withLocale(Locale.US).withZone(ZoneOffset.UTC);
        File f = new File(filePath);
        if (f.exists() && f.isFile() && !f.delete()) {
            logger.warn("Could not delete file: " + String.valueOf(f));
        }
        if (f.isDirectory()) {
            throw new RuntimeException("File is directory: " + filePath);
        }
        if (!f.createNewFile()) {
            logger.warn("Could not create file: " + String.valueOf(f));
        }
        FileWriter fw = new FileWriter(filePath);
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write("#time X Y Z");
        bw.newLine();
        int n = data.samples.size();
        for (int i = 0; i < n; ++i) {
            PointCloudData.PointSample p = data.samples.get(i);
            bw.write(df.format(p.toInstant()) + " " + p.x() * Constants.U_TO_KM + " " + p.y() * Constants.U_TO_KM + " " + p.z() * Constants.U_TO_KM);
            bw.newLine();
        }
        bw.flush();
        bw.close();
    }
}

