/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.orbit;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import gaiasky.data.api.IOrbitDataProvider;
import gaiasky.data.orbit.FileDataLoaderEclipticJulianTime;
import gaiasky.data.util.OrbitDataLoader;
import gaiasky.data.util.PointCloudData;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.scene.component.Trajectory;
import gaiasky.util.Settings;

public class OrbitFileDataEclipticJulianTimeProvider
implements IOrbitDataProvider {
    private PointCloudData data;

    @Override
    public void initialize(Entity entity, Trajectory trajectory) {
    }

    @Override
    public void load(String file, OrbitDataLoader.OrbitDataLoaderParameters parameter) {
        FileDataLoaderEclipticJulianTime odl = new FileDataLoaderEclipticJulianTime();
        try {
            FileHandle f = Settings.settings.data.dataFileHandle(file);
            this.data = odl.load(f.read());
            EventManager.publish(Event.ORBIT_DATA_LOADED, this, this.data, file);
        }
        catch (Exception e) {
            Gdx.app.error(OrbitFileDataEclipticJulianTimeProvider.class.getName(), e.getMessage());
        }
    }

    @Override
    public void load(String file, OrbitDataLoader.OrbitDataLoaderParameters parameter, boolean newMethod) {
        this.load(file, parameter);
    }

    @Override
    public PointCloudData getData() {
        return this.data;
    }
}

