/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.orbit;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.files.FileHandle;
import gaiasky.data.api.IOrbitDataProvider;
import gaiasky.data.orbit.FileDataLoader;
import gaiasky.data.util.OrbitDataLoader;
import gaiasky.data.util.PointCloudData;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.scene.component.Trajectory;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.io.GzipUtils;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class OrbitFileDataProvider
implements IOrbitDataProvider {
    private PointCloudData data;

    @Override
    public void initialize(Entity entity, Trajectory trajectory) {
    }

    @Override
    public void load(String file, OrbitDataLoader.OrbitDataLoaderParameters parameter) {
        if (file != null) {
            FileDataLoader odl = new FileDataLoader();
            FileHandle f = Settings.settings.data.dataFileHandle(file);
            try {
                boolean isGzip = false;
                try (InputStream fis = f.read();){
                    isGzip = GzipUtils.isGZipped(fis);
                }
                fis = f.read();
                InputStream is = isGzip ? new GZIPInputStream(fis) : fis;
                this.data = odl.load(is);
                if (parameter.multiplier != 1.0) {
                    int n = this.data.samples.size();
                    for (int i = 0; i < n; ++i) {
                        PointCloudData.PointSample p = this.data.samples.get(i);
                        this.data.samples.set(i, new PointCloudData.PointSample(p.x() * parameter.multiplier, p.y() * parameter.multiplier, p.z() * parameter.multiplier, p.seconds(), p.nanos()));
                    }
                }
                EventManager.publish(Event.ORBIT_DATA_LOADED, this, this.data, file);
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).error(e);
            }
        }
    }

    @Override
    public void load(String file, OrbitDataLoader.OrbitDataLoaderParameters parameter, boolean newMethod) {
        this.load(file, parameter);
    }

    @Override
    public PointCloudData getData() {
        return this.data;
    }
}

