/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.orbit;

import com.badlogic.ashley.core.Entity;
import gaiasky.data.api.IOrbitDataProvider;
import gaiasky.data.util.OrbitDataLoader;
import gaiasky.data.util.PointCloudData;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.scene.component.Trajectory;
import gaiasky.scene.record.OrbitComponent;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector3D;
import java.time.Instant;
import java.util.Comparator;
import net.jafama.FastMath;

public class OrbitalParametersProvider
implements IOrbitDataProvider {
    private PointCloudData data;

    @Override
    public void initialize(Entity entity, Trajectory trajectory) {
    }

    @Override
    public void load(String file, OrbitDataLoader.OrbitDataLoaderParameters parameter) {
        this.load(file, parameter, false);
    }

    @Override
    public void load(String file, OrbitDataLoader.OrbitDataLoaderParameters parameter, boolean newMethod) {
        if (newMethod) {
            try {
                switch (parameter.sampling) {
                    case TIME: {
                        this.sampleOrbitInTime(parameter);
                        break;
                    }
                    case NU: {
                        this.sampleOrbitInNu(parameter);
                    }
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).error(e);
            }
        } else {
            this.loadOld(file, parameter);
        }
    }

    private void sampleOrbitInTime(OrbitDataLoader.OrbitDataLoaderParameters parameter) {
        OrbitComponent params = parameter.orbitalParamaters;
        Vector3D out = new Vector3D();
        double period = params.period;
        double epoch = params.epoch;
        this.data = new PointCloudData();
        this.data.period = period;
        double tStep = period / ((double)parameter.numSamples - 1.0);
        double t = 0.0;
        for (int i = 0; i < parameter.numSamples; ++i) {
            params.loadDataPoint(out, t);
            Instant time = AstroUtils.julianDateToInstant(epoch + t);
            if (i == parameter.numSamples - 1) {
                double sx = this.data.getX(0);
                double sy = this.data.getY(0);
                double sz = this.data.getZ(0);
                this.data.addPoint(sx, sy, sz, time);
            } else {
                this.data.addPoint(out.x, out.y, out.z, time);
            }
            t += tStep;
        }
    }

    private void sampleOrbitInNu(OrbitDataLoader.OrbitDataLoaderParameters parameter) {
        OrbitComponent params = parameter.orbitalParamaters;
        Vector3D out = new Vector3D();
        double period = params.period;
        this.data = new PointCloudData();
        this.data.period = period;
        double nu0 = params.timeToTrueAnomaly(0.0);
        double nuStep = Math.PI * 2 / (double)(parameter.numSamples - 1);
        double nu = nu0;
        for (int i = 0; i < parameter.numSamples; ++i) {
            params.loadDataPointNu(out, nu);
            double dtDays = params.trueAnomalyToTime(nu);
            Instant time = AstroUtils.julianDateToInstant(params.epoch + dtDays);
            if (i == parameter.numSamples - 1) {
                double sx = this.data.getX(0);
                double sy = this.data.getY(0);
                double sz = this.data.getZ(0);
                this.data.addPoint(sx, sy, sz, time);
            } else {
                this.data.addPoint(out.x, out.y, out.z, time);
            }
            nu += nuStep;
        }
        this.data.samples.sort(Comparator.comparing(PointCloudData.PointSample::seconds));
    }

    public void loadOld(String file, OrbitDataLoader.OrbitDataLoaderParameters parameter) {
        OrbitComponent params = parameter.orbitalParamaters;
        if (params == null) {
            return;
        }
        try {
            double a = params.semiMajorAxis;
            double f = params.e * params.semiMajorAxis;
            double b = FastMath.sqrt((double)(Math.pow(a, 2.0) - FastMath.pow((double)f, (double)2.0)));
            int nSamples = FastMath.min((int)Math.max(50, (int)(a * 0.01)), (int)100);
            double step = 360.0 / (double)nSamples;
            Vector3D[] samples = new Vector3D[nSamples + 1];
            int i = 0;
            for (double angledeg = 0.0; angledeg < 360.0; angledeg += step) {
                Vector3D point;
                double angleRad = FastMath.toRadians((double)angledeg);
                samples[i] = point = new Vector3D(b * FastMath.sin((double)angleRad), 0.0, a * FastMath.cos((double)angleRad));
                ++i;
            }
            samples[i] = samples[0].cpy();
            Matrix4D transform = new Matrix4D();
            transform.scl(Constants.KM_TO_U);
            this.data = new PointCloudData();
            for (Vector3D point : samples) {
                point.mul(transform);
                this.data.addPoint(point.x, point.y, point.z, Instant.now());
            }
            EventManager.publish(Event.ORBIT_DATA_LOADED, this, this.data, parameter.name);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error(e);
        }
    }

    @Override
    public PointCloudData getData() {
        return this.data;
    }
}

