/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.orientation;

import com.badlogic.ashley.core.Entity;
import gaiasky.GaiaSky;
import gaiasky.data.api.OrientationServer;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.util.math.QuaternionDouble;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.time.Instant;
import java.util.Date;

public class LVLHOrientationServer
implements OrientationServer {
    protected final QuaternionDouble lastOrientation = new QuaternionDouble();
    protected final String objectName;
    protected Entity object;
    protected Entity parent;
    protected final Vector3Q a;
    protected final Vector3Q b;
    protected final Vector3Q c;
    protected final Vector3Q lastPos;
    protected final Vector3D up;
    protected final Vector3D dir;
    protected final Vector3D side;
    protected final Vector3D lastDir;
    protected boolean initialized = false;

    public LVLHOrientationServer(String objectName) {
        this.objectName = objectName.substring(objectName.lastIndexOf("/") + 1);
        this.a = new Vector3Q();
        this.b = new Vector3Q();
        this.c = new Vector3Q();
        this.lastPos = new Vector3Q();
        this.up = new Vector3D();
        this.dir = new Vector3D();
        this.side = new Vector3D();
        this.lastDir = new Vector3D();
    }

    private void lazyInitialize() {
        if (!this.initialized) {
            Scene scene = GaiaSky.instance.scene;
            this.object = scene.getEntity(this.objectName);
            if (this.object != null) {
                GraphNode graph;
                Entity obj = this.object;
                do {
                    graph = (GraphNode)Mapper.graph.get(obj);
                } while (!Mapper.celestial.has(obj = graph.parent));
                this.parent = obj;
            }
            this.initialized = true;
        }
    }

    @Override
    public QuaternionDouble updateOrientation(Date date) {
        return this.updateOrientation(date.toInstant());
    }

    @Override
    public QuaternionDouble updateOrientation(Instant instant) {
        this.lazyInitialize();
        if (this.object != null && this.parent != null) {
            this.a.set(((Body)Mapper.body.get((Entity)this.object)).pos);
            if (!this.lastPos.equals(this.a)) {
                this.lastPos.sub(this.a).nor().put(this.dir).scl(-1.0);
                this.lastDir.set(this.dir);
                this.lastPos.set(this.a);
            } else {
                this.dir.set(this.lastDir);
            }
            this.a.put(this.up).nor();
            this.side.set(this.up).crs(this.dir).nor();
            this.lastOrientation.fromAxes(this.dir, this.side, this.up).nor();
        }
        return this.lastOrientation;
    }

    @Override
    public QuaternionDouble getCurrentOrientation() {
        return this.lastOrientation;
    }

    @Override
    public boolean hasOrientation() {
        return true;
    }
}

