/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.orientation;

import com.badlogic.gdx.utils.Array;
import gaiasky.data.api.OrientationServer;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.QuaternionDouble;
import gaiasky.util.parse.Parser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Date;

public abstract class QuaternionInterpolationOrientationServer
implements OrientationServer {
    private static final String gscFileSeparatorRegex = "[\\s,]+";
    private final Array<Pair<Instant, QuaternionDouble>> data;
    protected final QuaternionDouble lastOrientation = new QuaternionDouble();

    public QuaternionInterpolationOrientationServer(String dataFile) {
        Path path = Paths.get(Settings.settings.data.dataFile(dataFile), new String[0]);
        this.data = this.initialize(path);
    }

    private Array<Pair<Instant, QuaternionDouble>> initialize(Path path) {
        Array array;
        block16: {
            if (!Files.exists(path, new LinkOption[0])) {
                throw new RuntimeException(I18n.msg("error.file.exists", path.toString()));
            }
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                throw new RuntimeException(I18n.msg("error.file.isdir", path.toString()));
            }
            if (!Files.isReadable(path)) {
                throw new RuntimeException(I18n.msg("error.file.read", path.toString()));
            }
            array = new Array();
            try {
                BufferedReader is = new BufferedReader(new InputStreamReader(Files.newInputStream(path, new OpenOption[0])));
                block11: while (true) {
                    String line;
                    while ((line = is.readLine()) != null) {
                        boolean comment = (line = line.strip()).startsWith("#");
                        if (comment) continue;
                        try {
                            Instant time;
                            String[] tokens = line.split(gscFileSeparatorRegex);
                            try {
                                time = Instant.ofEpochMilli(Parser.parseLongException(tokens[0]));
                            }
                            catch (NumberFormatException ignored) {
                                time = Instant.parse(tokens[0]);
                            }
                            QuaternionDouble q = new QuaternionDouble(Parser.parseDouble(tokens[1]), Parser.parseDouble(tokens[2]), Parser.parseDouble(tokens[3]), Parser.parseDouble(tokens[4]));
                            array.add(new Pair<Instant, QuaternionDouble>(time, q));
                            continue block11;
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                    }
                    break block16;
                    {
                        continue block11;
                        break;
                    }
                    break;
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return array;
    }

    private int findStartIndex(Instant instant) {
        if (this.data != null && !this.data.isEmpty()) {
            if (this.data.size > 1) {
                if (instant.compareTo((Instant)((Pair)this.data.get(0)).getFirst()) <= 0) {
                    return 0;
                }
                if (instant.compareTo((Instant)((Pair)this.data.get(this.data.size - 1)).getFirst()) >= 0) {
                    return this.data.size - 1;
                }
                for (int i = 1; i < this.data.size; ++i) {
                    Pair i0 = (Pair)this.data.get(i - 1);
                    Pair i1 = (Pair)this.data.get(i);
                    if (instant.compareTo((Instant)i0.getFirst()) < 0 || instant.compareTo((Instant)i1.getFirst()) >= 0) continue;
                    return i - 1;
                }
            } else {
                return 0;
            }
        }
        return -1;
    }

    @Override
    public QuaternionDouble updateOrientation(Date date) {
        return this.updateOrientation(date.toInstant());
    }

    @Override
    public QuaternionDouble updateOrientation(Instant instant) {
        int idx = this.findStartIndex(instant);
        if (idx >= 0) {
            if (idx == this.data.size - 1) {
                this.lastOrientation.set((QuaternionDouble)((Pair)this.data.get(this.data.size - 1)).getSecond());
                return this.lastOrientation;
            }
            Pair d0 = (Pair)this.data.get(idx);
            Pair d1 = (Pair)this.data.get(idx + 1);
            long t0 = ((Instant)d0.getFirst()).toEpochMilli();
            long t1 = ((Instant)d1.getFirst()).toEpochMilli();
            QuaternionDouble q0 = (QuaternionDouble)d0.getSecond();
            QuaternionDouble q1 = (QuaternionDouble)d1.getSecond();
            double alpha = (double)(instant.toEpochMilli() - t0) / (double)(t1 - t0);
            return this.interpolate(q0, q1, alpha);
        }
        return null;
    }

    protected abstract QuaternionDouble interpolate(QuaternionDouble var1, QuaternionDouble var2, double var3);

    @Override
    public QuaternionDouble getCurrentOrientation() {
        return this.lastOrientation;
    }

    @Override
    public boolean hasOrientation() {
        return this.data != null && !this.data.isEmpty();
    }
}

