/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.util;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import gaiasky.data.api.IOrbitDataProvider;
import gaiasky.data.util.PointCloudData;
import gaiasky.scene.component.Trajectory;
import gaiasky.scene.record.OrbitComponent;
import gaiasky.util.Logger;
import java.util.Date;

public class OrbitDataLoader
extends AsynchronousAssetLoader<PointCloudData, OrbitDataLoaderParameters> {
    PointCloudData data;

    public OrbitDataLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, OrbitDataLoaderParameters parameters) {
        return null;
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, OrbitDataLoaderParameters parameters) {
        try {
            IOrbitDataProvider provider = (IOrbitDataProvider)ClassReflection.newInstance(parameters.providerClass);
            provider.load(fileName, parameters);
            this.data = provider.getData();
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass()).error(e);
        }
    }

    public PointCloudData loadSync(AssetManager manager, String fileName, FileHandle file, OrbitDataLoaderParameters parameter) {
        return this.data;
    }

    public static class OrbitDataLoaderParameters
    extends AssetLoaderParameters<PointCloudData> {
        public Date ini;
        public double orbitalPeriod;
        public double multiplier = 1.0;
        public int numSamples;
        public Trajectory.OrbitSamplingStrategy sampling;
        public String name;
        public OrbitComponent orbitalParamaters;
        public Entity entity;
        public boolean force = false;
        Class<? extends IOrbitDataProvider> providerClass;

        public OrbitDataLoaderParameters(Class<? extends IOrbitDataProvider> providerClass) {
            this.providerClass = providerClass;
        }

        public OrbitDataLoaderParameters(String name, Class<? extends IOrbitDataProvider> providerClass, double orbitalPeriod, int numSamples, Trajectory.OrbitSamplingStrategy sampling) {
            this(providerClass);
            this.name = name;
            this.orbitalPeriod = orbitalPeriod;
            this.numSamples = numSamples;
            this.sampling = sampling;
        }

        public OrbitDataLoaderParameters(String name, Class<? extends IOrbitDataProvider> providerClass, OrbitComponent orbitalParameters, double multiplier) {
            this(providerClass);
            this.name = name;
            this.orbitalParamaters = orbitalParameters;
            this.multiplier = multiplier;
        }

        public OrbitDataLoaderParameters(String name, Class<? extends IOrbitDataProvider> providerClass, OrbitComponent orbitalParameters, double multiplier, int numSamples, Trajectory.OrbitSamplingStrategy sampling) {
            this(providerClass);
            this.name = name;
            this.orbitalParamaters = orbitalParameters;
            this.multiplier = multiplier;
            this.numSamples = numSamples;
            this.sampling = sampling;
        }

        public OrbitDataLoaderParameters(Class<? extends IOrbitDataProvider> providerClass, String name, Date ini, double orbitalPeriod, int numSamples, Trajectory.OrbitSamplingStrategy sampling) {
            this(providerClass);
            this.name = name;
            this.ini = ini;
            this.orbitalPeriod = orbitalPeriod;
            this.numSamples = numSamples;
            this.sampling = sampling;
        }

        public OrbitDataLoaderParameters(Class<? extends IOrbitDataProvider> providerClass, String name, Date ini, double orbitalPeriod) {
            this(providerClass, name, ini, orbitalPeriod, -1, Trajectory.OrbitSamplingStrategy.TIME);
        }

        public void setIni(Date date) {
            this.ini = date;
        }

        public void setOrbitalPeriod(double period) {
            this.orbitalPeriod = period;
        }

        public void setForce(Boolean force) {
            this.force = force;
        }
    }
}

