/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.util;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import gaiasky.data.api.OrientationServer;
import gaiasky.util.Logger;

public class OrientationServerLoader
extends AsynchronousAssetLoader<OrientationServer, OrientationServerParameters> {
    private static final Logger.Log logger = Logger.getLogger(OrientationServerLoader.class);
    OrientationServer server;

    public OrientationServerLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, OrientationServerParameters parameter) {
        try {
            String className = parameter.loaderClass;
            if (className == null || className.isBlank()) {
                logger.error("Orientation server loader class name is null or blank");
                throw new RuntimeException("Orientation server loader class name is null or blank");
            }
            Class<?> c = Class.forName(className);
            this.server = (OrientationServer)c.getDeclaredConstructor(String.class).newInstance(fileName);
        }
        catch (Exception e) {
            logger.error("Error creating orientation server from class: " + parameter.loaderClass);
            throw new RuntimeException(e);
        }
    }

    public OrientationServer loadSync(AssetManager manager, String fileName, FileHandle file, OrientationServerParameters parameter) {
        return this.server;
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, OrientationServerParameters parameter) {
        return null;
    }

    public static class OrientationServerParameters
    extends AssetLoaderParameters<OrientationServer> {
        public String loaderClass;

        public OrientationServerParameters(String loaderClass) {
            this.loaderClass = loaderClass;
        }
    }
}

