/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.util;

import com.badlogic.gdx.math.Vector3;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.time.Instant;
import java.util.ArrayList;
import net.jafama.FastMath;

public class PointCloudData
implements Cloneable {
    private static final ThreadLocal<Vector3D> vec0 = ThreadLocal.withInitial(Vector3D::new);
    private static final ThreadLocal<Vector3D> vec1 = ThreadLocal.withInitial(Vector3D::new);
    public ArrayList<PointSample> samples;
    public double period = -1.0;
    private Instant start;
    private Instant end;

    public PointCloudData() {
        this(16);
    }

    public PointCloudData(int capacity) {
        this.samples = new ArrayList(capacity);
    }

    public void set(int index, double x, double y, double z) {
        if (index < this.samples.size() && index >= 0) {
            this.samples.set(index, new PointSample(x, y, z));
        }
    }

    public void setX(int index, double x) {
        if (index < this.samples.size() && index >= 0) {
            PointSample p = this.samples.get(index);
            this.samples.set(index, new PointSample(x, p.y, p.z, p.seconds, p.nanos));
        }
    }

    public void setY(int index, double y) {
        if (index < this.samples.size() && index >= 0) {
            PointSample p = this.samples.get(index);
            this.samples.set(index, new PointSample(p.x, y, p.z, p.seconds, p.nanos));
        }
    }

    public void setZ(int index, double z) {
        if (index < this.samples.size() && index >= 0) {
            PointSample p = this.samples.get(index);
            this.samples.set(index, new PointSample(p.x, p.y, z, p.seconds, p.nanos));
        }
    }

    public void clear() {
        this.samples.clear();
    }

    public boolean isEmpty() {
        return this.samples.isEmpty();
    }

    public boolean hasTime() {
        return this.samples != null && !this.samples.isEmpty() && this.samples.getFirst().seconds > Long.MIN_VALUE;
    }

    public void addPoints(double[] points) {
        if (points.length % 3 == 0) {
            int nPoints = points.length / 3;
            for (int i = 0; i < nPoints; ++i) {
                PointSample sample = new PointSample(points[i * 3], points[i * 3 + 1], points[i * 3 + 2], Long.MIN_VALUE, 0);
                this.samples.add(sample);
            }
        }
    }

    public void addPoint(Vector3D point, Instant t) {
        this.samples.add(new PointSample(point, t));
    }

    public void addPoint(Vector3D point) {
        this.samples.add(new PointSample(point));
    }

    public void addPoint(double x, double y, double z, long seconds, int nano) {
        this.samples.add(new PointSample(x, y, z, seconds, nano));
    }

    public void addPoint(double x, double y, double z, Instant t) {
        this.samples.add(new PointSample(x, y, z, t.getEpochSecond(), t.getNano()));
    }

    public void addPoint(double x, double y, double z) {
        this.samples.add(new PointSample(x, y, z));
    }

    public void loadPoint(Vector3D v, int index) {
        this.samples.get(index).put(v);
    }

    public void loadPoint(Vector3Q v, int index) {
        this.samples.get(index).put(v);
    }

    public int getNumPoints() {
        return this.samples.size();
    }

    public double getX(int index) {
        return this.samples.get((int)index).x;
    }

    public double getY(int index) {
        return this.samples.get((int)index).y;
    }

    public double getZ(int index) {
        return this.samples.get((int)index).z;
    }

    public void setPoint(Vector3D v, int index) {
        this.samples.set(index, new PointSample(v));
    }

    public Instant getDate(int index) {
        return this.samples.get(index).toInstant();
    }

    public Instant getStart() {
        if (this.start == null) {
            this.start = this.samples.getFirst().toInstant();
        }
        return this.start;
    }

    public long getStartMs() {
        return this.getStart().toEpochMilli();
    }

    public Instant getEnd() {
        if (this.end == null) {
            this.end = this.samples.getLast().toInstant();
        }
        return this.end;
    }

    public long getEndMs() {
        return this.getEnd().toEpochMilli();
    }

    public void loadPointF(Vector3 v, int index) {
        this.samples.get(index).put(v);
    }

    public boolean loadPoint(Vector3D v, Instant instant) {
        return this.loadPoint(v, instant.toEpochMilli());
    }

    public boolean loadPoint(Vector3Q v, Instant instant) {
        return this.loadPoint(v, instant.toEpochMilli());
    }

    public boolean loadPoint(Vector3D v, long timeMs) {
        int idx = this.binarySearch(this.samples, timeMs);
        if (idx < 0 || idx >= this.samples.size()) {
            return false;
        }
        if (this.samples.get(idx).toEpochMilli() == timeMs) {
            this.samples.get(idx).put(v);
        } else {
            Vector3D v0 = vec0.get();
            Vector3D v1 = vec1.get();
            this.loadPoint(v0, idx);
            this.loadPoint(v1, idx + 1);
            long t0 = this.samples.get(idx).toEpochMilli();
            long t1 = this.samples.get(idx + 1).toEpochMilli();
            double scl = (double)(timeMs - t0) / (double)(t1 - t0);
            v.set(v1.sub(v0).scl(scl).add(v0));
        }
        return true;
    }

    public boolean loadPoint(Vector3Q v, long timeMs) {
        int idx = this.binarySearch(this.samples, timeMs);
        if (idx < 0 || idx >= this.samples.size()) {
            return false;
        }
        if (this.samples.get(idx).toEpochMilli() == timeMs) {
            this.samples.get(idx).put(v);
        } else {
            Vector3D v0 = vec0.get();
            Vector3D v1 = vec1.get();
            this.loadPoint(v0, idx);
            this.loadPoint(v1, idx + 1);
            long t0 = this.samples.get(idx).toEpochMilli();
            long t1 = this.samples.get(idx + 1).toEpochMilli();
            double scl = (double)(timeMs - t0) / (double)(t1 - t0);
            v.set(v1.sub(v0).scl(scl).add(v0));
        }
        return true;
    }

    public Instant getWrapTime(Instant instant) {
        return Instant.ofEpochMilli(this.getWrapTimeMs(instant));
    }

    public long getWrapTimeMs(Instant instant) {
        long c = instant.toEpochMilli();
        long s = this.getStartMs();
        long e = this.getEndMs();
        long ep = e - s;
        long cp = c - s;
        long wrapCurrentTime = ep > 0L ? (cp % ep + ep) % ep : 0L;
        return wrapCurrentTime + s;
    }

    public int getIndex(Instant instant) {
        return this.binarySearch(this.samples, this.getWrapTimeMs(instant));
    }

    public int getIndex(long wrappedTimeMs) {
        return this.binarySearch(this.samples, wrappedTimeMs);
    }

    private int binarySearch(ArrayList<PointSample> samples, Instant elem) {
        return this.binarySearch(samples, elem.toEpochMilli());
    }

    private int binarySearch(ArrayList<PointSample> samples, long time) {
        if (time >= samples.getFirst().toEpochMilli() && time <= samples.getLast().toEpochMilli()) {
            return this.binarySearch(samples, time, 0, samples.size() - 1);
        }
        return -1;
    }

    private int binarySearch(ArrayList<PointSample> samples, long time, int i0, int i1) {
        if (i0 > i1) {
            return -1;
        }
        if (i0 == i1) {
            if (samples.get(i0).toEpochMilli() > time) {
                return i0 - 1;
            }
            return i0;
        }
        int mid = (i0 + i1) / 2;
        if (samples.get(mid).toEpochMilli() == time) {
            return mid;
        }
        if (samples.get(mid).toEpochMilli() < time) {
            return this.binarySearch(samples, time, mid + 1, i1);
        }
        return this.binarySearch(samples, time, i0, mid);
    }

    public PointCloudData clone() {
        try {
            PointCloudData clone = (PointCloudData)super.clone();
            clone.samples = new ArrayList<PointSample>(this.samples);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public record PointSample(double x, double y, double z, long seconds, int nanos) {
        public PointSample(double x, double y, double z) {
            this(x, y, z, Long.MIN_VALUE, 0);
        }

        public PointSample(Vector3D v) {
            this(v.x, v.y, v.z, Long.MIN_VALUE, 0);
        }

        public PointSample(double x, double y, double z, Instant t) {
            this(x, y, z, t.getEpochSecond(), t.getNano());
        }

        public PointSample(Vector3D v, Instant t) {
            this(v.x, v.y, v.z, t.getEpochSecond(), t.getNano());
        }

        public void put(Vector3 v) {
            v.set((float)this.x, (float)this.y, (float)this.z);
        }

        public void put(Vector3D v) {
            v.set(this.x, this.y, this.z);
        }

        public void put(Vector3Q v) {
            v.set(this.x, this.y, this.z);
        }

        public long toEpochMilli() {
            if (this.seconds < 0L && this.nanos > 0) {
                long millis = FastMath.multiplyExact((long)(this.seconds + 1L), (int)1000);
                long adjustment = this.nanos / 1000000 - 1000;
                return FastMath.addExact((long)millis, (long)adjustment);
            }
            long millis = FastMath.multiplyExact((long)this.seconds, (int)1000);
            return FastMath.addExact((long)millis, (long)(this.nanos / 1000000));
        }

        public Instant toInstant() {
            return Instant.ofEpochSecond(this.seconds, this.nanos);
        }
    }
}

