/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.data.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.data.SceneJsonLoader;
import gaiasky.scene.Scene;
import gaiasky.util.CrashReporter;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public class SceneLoader
extends AsynchronousAssetLoader<Scene, SceneLoaderParameters> {
    private static final Logger.Log logger = Logger.getLogger(SceneLoader.class);
    private Scene scene;

    public SceneLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, SceneLoaderParameters parameter) {
        Array filePaths = new Array((Object[])parameter.files);
        Path dataFolder = Paths.get(Settings.settings.data.location, new String[0]);
        File[] autoloadFiles = dataFolder.toFile().listFiles((dir, name) -> name != null && name.startsWith("autoload-") && name.endsWith(".json"));
        Objects.requireNonNull(autoloadFiles, "Your data folder does not point to a valid directory: " + String.valueOf(dataFolder));
        for (File autoloadFile : autoloadFiles) {
            filePaths.add((Object)autoloadFile.getAbsolutePath().replace("\\\\", "/"));
        }
        FileHandle[] fileHandles = new FileHandle[filePaths.size];
        for (int i = 0; i < filePaths.size; ++i) {
            fileHandles[i] = this.resolve((String)filePaths.get(i));
        }
        try {
            this.scene = new Scene();
            this.scene.initialize();
            SceneJsonLoader.loadScene(fileHandles, this.scene);
        }
        catch (Exception e) {
            GaiaSky.postRunnable(() -> {
                CrashReporter.reportCrash(e, logger);
                Gdx.app.exit();
            });
        }
        logger.info(I18n.msg("notif.render.init"));
    }

    public Scene loadSync(AssetManager manager, String fileName, FileHandle file, SceneLoaderParameters parameter) {
        return this.scene;
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, SceneLoaderParameters parameter) {
        return null;
    }

    public static class SceneLoaderParameters
    extends AssetLoaderParameters<Scene> {
        public String[] files;

        public SceneLoaderParameters(String[] files) {
            this.files = files;
        }
    }
}

