/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.desktop;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Files;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import com.badlogic.gdx.utils.Array;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import gaiasky.ErrorDialog;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.main.ConsoleLogger;
import gaiasky.gui.main.KeyBindings;
import gaiasky.render.ScreenModeCmd;
import gaiasky.rest.RESTServer;
import gaiasky.util.CrashReporter;
import gaiasky.util.GlobalResources;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SettingsManager;
import gaiasky.util.SettingsMorph;
import gaiasky.util.SlaveManager;
import gaiasky.util.SysUtils;
import gaiasky.util.camera.rec.Camcorder;
import gaiasky.util.i18n.I18n;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.Map;
import net.jafama.FastMath;
import org.yaml.snakeyaml.Yaml;

public class GaiaSkyDesktop
implements IObserver {
    private static final Logger.Log logger = Logger.getLogger(GaiaSkyDesktop.class);
    private static final int MIN_JAVA_VERSION = 21;
    private static final int DEFAULT_OPENGL_MAJOR = 4;
    private static final int DEFAULT_OPENGL_MINOR = 1;
    private static final int XR_OPENGL_MINOR = 5;
    private static final String DEFAULT_OPENGL = "4.1";
    private static final int MIN_OPENGL_MAJOR = 3;
    private static final int MIN_OPENGL_MINOR = 3;
    private static final String MIN_OPENGL = "3.3";
    private static final int MIN_GLSL_MAJOR = 3;
    private static final int MIN_GLSL_MINOR = 3;
    private static final String MIN_GLSL = "3.3";
    private static boolean REST_ENABLED;
    private static CLIArgs cliArgs;
    private static PrintStream out;
    private GaiaSky gs;

    public GaiaSkyDesktop() {
        EventManager.instance.subscribe((IObserver)this, Event.SCENE_LOADED, Event.DISPOSE);
    }

    private static void printUsage(JCommander jc) {
        jc.usage();
    }

    public static void main(String[] args) {
        Thread.currentThread().setName("gaiasky-main-thread");
        out = new PrintStream((OutputStream)System.out, true, StandardCharsets.UTF_8);
        cliArgs = new CLIArgs();
        JCommander jc = JCommander.newBuilder().addObject((Object)cliArgs).build();
        jc.setProgramName("gaiasky");
        try {
            jc.parse(args);
            if (GaiaSkyDesktop.cliArgs.help) {
                GaiaSkyDesktop.printUsage(jc);
                return;
            }
        }
        catch (Exception e) {
            out.print("gaiasky: bad program arguments\n\n");
            GaiaSkyDesktop.printUsage(jc);
            return;
        }
        int statusCode = 0;
        try {
            GaiaSkyDesktop.javaVersionCheck();
            GaiaSkyDesktop.experimentalCheck();
            if (GaiaSkyDesktop.cliArgs.propertiesFile != null && !GaiaSkyDesktop.cliArgs.propertiesFile.isEmpty()) {
                System.setProperty("properties.file", GaiaSkyDesktop.cliArgs.propertiesFile);
            }
            if (GaiaSkyDesktop.cliArgs.assetsLocation != null && !GaiaSkyDesktop.cliArgs.assetsLocation.isEmpty()) {
                System.setProperty("assets.location", GaiaSkyDesktop.cliArgs.assetsLocation);
            }
            if (GaiaSkyDesktop.cliArgs.vr) {
                Settings.APPLICATION_NAME = Settings.APPLICATION_NAME + " VR";
            }
            GaiaSkyDesktop gaiaSkyDesktop = new GaiaSkyDesktop();
            Gdx.files = new Lwjgl3Files();
            SysUtils.mkdirs();
            String props = System.getProperty("properties.file");
            if (props == null || props.isEmpty()) {
                boolean bl = GaiaSkyDesktop.initConfigFile(GaiaSkyDesktop.cliArgs.vr);
            }
            SettingsManager.initialize(GaiaSkyDesktop.cliArgs.vr);
            I18n.initialize(Gdx.files.internal("i18n/gsbundle"), Gdx.files.internal("i18n/objects"));
            if (GaiaSkyDesktop.cliArgs.safeMode && !Settings.settings.program.safeMode) {
                Settings.settings.program.safeMode = true;
                Settings.settings.program.safeModeFlag = true;
            }
            if (GaiaSkyDesktop.cliArgs.noSafeMode) {
                Settings.settings.program.safeMode = false;
            }
            I18n.initialize(Gdx.files.absolute(Settings.ASSETS_LOC + File.separator + "i18n/gsbundle"), Gdx.files.absolute(Settings.ASSETS_LOC + File.separator + "i18n/objects"));
            if (GaiaSkyDesktop.cliArgs.version) {
                out.println(Settings.getShortApplicationName());
                if (GaiaSkyDesktop.cliArgs.asciiArt) {
                    String line;
                    BufferedReader ascii = new BufferedReader(new InputStreamReader(Gdx.files.internal("icon/gsascii.txt").read()));
                    out.println();
                    while ((line = ascii.readLine()) != null) {
                        out.println(line);
                    }
                }
                out.println();
                out.println(I18n.msg("gui.help.license"));
                out.println(I18n.msg("gui.help.writtenby", "Toni Sagrist\u00e0 Sell\u00e9s", "tsagrista@ari.uni-heidelberg.de"));
                out.println();
                out.println(I18n.msg("gui.help.homepage") + "\t<https://gaiasky.space>");
                out.println(I18n.msg("gui.help.docs") + "\t\t<http://docs.gaiasky.space>");
                out.println(I18n.msg("gui.help.repo") + "\t<https://codeberg.org/gaiasky/gaiasky>");
                out.println();
                out.println(I18n.msg("gui.help.javaversion") + " " + System.getProperty("java.vm.version"));
                out.println();
                out.println("ZAH/DLR/BWT/DPAC");
                return;
            }
            Logger.level = GaiaSkyDesktop.cliArgs.debug ? Logger.LoggerLevel.DEBUG : Logger.LoggerLevel.INFO;
            ConsoleLogger consoleLogger = new ConsoleLogger();
            SlaveManager.initialize();
            ScreenModeCmd.initialize();
            Camcorder.initialize();
            KeyBindings.initialize();
            boolean bl = REST_ENABLED = Settings.settings.program.net.restPort >= 0;
            if (REST_ENABLED) {
                RESTServer.initialize(Settings.settings.program.net.restPort);
            }
            consoleLogger.dispose();
            gaiaSkyDesktop.init();
            CrashReporter.writeLastSessionLog(logger);
        }
        catch (Exception e) {
            CrashReporter.reportCrash(e, logger);
            statusCode = 1;
        }
        System.exit(statusCode);
    }

    private static void checkLogger(ConsoleLogger consoleLogger) {
        EventManager.instance.clearAllSubscriptions();
        consoleLogger.subscribe();
    }

    private static boolean initConfigFile(boolean vr) throws IOException {
        Path userFolderConfFile = SysUtils.getConfigDir().resolve(SettingsManager.getConfigFileName(vr));
        Path confFolder = Settings.assetsPath("conf");
        Path internalFolderConfFile = confFolder.resolve(SettingsManager.getConfigFileName(vr));
        boolean overwrite = false;
        boolean userConfExists = Files.exists(userFolderConfFile, new LinkOption[0]);
        if (userConfExists) {
            Yaml yaml = new Yaml();
            Map userProps = (Map)yaml.load(Files.newInputStream(userFolderConfFile, new OpenOption[0]));
            int internalVersion = 0;
            if (Files.exists(internalFolderConfFile, new LinkOption[0])) {
                Map internalProps = (Map)yaml.load(Files.newInputStream(internalFolderConfFile, new OpenOption[0]));
                internalVersion = (Integer)internalProps.get("configVersion");
            }
            if (userProps == null) {
                out.println("Your current configuration file is corrupted! Overwriting...");
                userConfExists = false;
                overwrite = true;
            } else if (!userProps.containsKey("configVersion")) {
                out.println("Configuration file version not found, overwriting with new version (" + internalVersion + ")");
                overwrite = true;
            } else if ((Integer)userProps.get("configVersion") < internalVersion) {
                out.println("Configuration file version mismatch, overwriting with new version: found " + String.valueOf(userProps.get("version")) + ", required " + internalVersion);
                overwrite = true;
            }
        } else {
            try {
                Path propertiesFile = SysUtils.getConfigDir().resolve(vr ? "global.vr.properties" : "global.properties");
                if (Files.exists(propertiesFile, new LinkOption[0])) {
                    out.println("Old configuration file detected!");
                    out.println("    -> Converting " + String.valueOf(propertiesFile) + " to " + String.valueOf(userFolderConfFile));
                    SettingsMorph.morphSettings(propertiesFile, userFolderConfFile);
                    Files.move(propertiesFile, SysUtils.getConfigDir().resolve(vr ? "global.vr.properties.old" : "global.properties.old"), new CopyOption[0]);
                    userConfExists = true;
                }
            }
            catch (Exception propertiesFile) {
                // empty catch block
            }
        }
        if (overwrite || !userConfExists) {
            if (Files.exists(confFolder, new LinkOption[0]) && Files.isDirectory(confFolder, new LinkOption[0])) {
                if (Files.exists(userFolderConfFile, new LinkOption[0]) && userFolderConfFile.toFile().length() > 0L) {
                    Path backup = userFolderConfFile.getParent().resolve(String.valueOf(userFolderConfFile.getFileName()) + "." + LocalDateTime.now().toString().replaceAll("[^a-zA-Z0-9_.\\-]", "_"));
                    GlobalResources.copyFile(userFolderConfFile, backup, true);
                }
                GlobalResources.copyFile(internalFolderConfFile, userFolderConfFile, overwrite);
            } else {
                logger.warn("Configuration folder does not exist: " + String.valueOf(confFolder));
            }
        }
        String props = userFolderConfFile.toAbsolutePath().toString();
        System.setProperty("properties.file", props);
        return overwrite || !userConfExists;
    }

    private static void javaVersionCheck() {
        double jv = SysUtils.getJavaVersion();
        if (jv < 21.0) {
            out.println("========================== ERROR ==============================");
            out.println("You are using Java " + jv + ", which is unsupported by Gaia Sky");
            out.println("             Please, use at least Java 21");
            out.println("===============================================================");
        }
    }

    private static void experimentalCheck() {
        if (GaiaSkyDesktop.cliArgs.externalView) {
            out.println("============================ WARNING ================================");
            out.println("The -e/--externalview feature is experimental and may cause problems!");
            out.println("=====================================================================");
            out.println();
        }
    }

    private void init() {
        this.launchMainApp();
    }

    public void launchMainApp() {
        ConsoleLogger consoleLogger = new ConsoleLogger();
        Lwjgl3ApplicationConfiguration cfg = new Lwjgl3ApplicationConfiguration();
        Settings s = Settings.settings;
        cfg.setTitle(Settings.APPLICATION_NAME);
        cfg.disableAudio(true);
        if (!GaiaSkyDesktop.cliArgs.vr) {
            double screenDiagonalPixels;
            int[] resolution = SysUtils.getDisplayResolution();
            if (resolution != null && resolution.length == 2 && resolution[0] > 0 && resolution[1] > 0 && (screenDiagonalPixels = FastMath.sqrt((double)(Math.pow(resolution[0], 2.0) + FastMath.pow((double)resolution[1], (double)2.0)))) < 1600.0) {
                s.graphics.fullScreen.active = true;
                s.graphics.fullScreen.resolution[0] = resolution[0];
                s.graphics.fullScreen.resolution[1] = resolution[1];
            }
            if (s.graphics.fullScreen.active) {
                int[] fullScreenResolution = s.graphics.fullScreen.resolution;
                Array.ArrayIterator modes = Lwjgl3ApplicationConfiguration.getDisplayModes();
                if (GaiaSkyDesktop.cliArgs.debug) {
                    logger.debug("Full screen resolution in config file: " + fullScreenResolution[0] + "x" + fullScreenResolution[1]);
                    logger.debug("Supported full screen modes:");
                    int modeIndex = 1;
                    for (Array.ArrayIterator displayMode : modes) {
                        logger.debug("  " + modeIndex++ + ". " + displayMode.toString());
                    }
                }
                Graphics.DisplayMode myMode = null;
                Array fittingModes = new Array();
                for (Graphics.DisplayMode mode : modes) {
                    if (mode.height != fullScreenResolution[1] || mode.width != fullScreenResolution[0]) continue;
                    fittingModes.add((Object)mode);
                }
                if (fittingModes.size == 1) {
                    myMode = (Graphics.DisplayMode)fittingModes.get(0);
                } else if (fittingModes.size > 1) {
                    for (Graphics.DisplayMode fittingMode : fittingModes) {
                        if (myMode == null) {
                            myMode = fittingMode;
                            continue;
                        }
                        if (s.graphics.fullScreen.bitDepth > 0 && fittingMode.bitsPerPixel == s.graphics.fullScreen.bitDepth && s.graphics.fullScreen.refreshRate > 0 && fittingMode.refreshRate == s.graphics.fullScreen.refreshRate) {
                            myMode = fittingMode;
                            break;
                        }
                        if (fittingMode.refreshRate <= myMode.refreshRate) continue;
                        myMode = fittingMode;
                    }
                }
                logger.debug("Using full screen mode: " + String.valueOf(myMode));
                if (myMode == null) {
                    logger.warn(I18n.msg("error.fullscreen.notfound", fullScreenResolution[0], fullScreenResolution[1]));
                    cfg.setWindowedMode(s.graphics.getScreenWidth(), s.graphics.getScreenHeight());
                    cfg.setResizable(s.graphics.resizable);
                } else {
                    cfg.setFullscreenMode(myMode);
                    s.graphics.fullScreen.resolution[0] = myMode.width;
                    s.graphics.fullScreen.resolution[1] = myMode.height;
                    s.graphics.fullScreen.bitDepth = myMode.bitsPerPixel;
                    s.graphics.fullScreen.refreshRate = myMode.refreshRate;
                }
            } else {
                this.configureWindowSize(cfg);
                cfg.setResizable(s.graphics.resizable);
            }
            cfg.useVsync(s.graphics.vsync);
        } else {
            cfg.useVsync(false);
            this.configureWindowSize(cfg);
            cfg.setResizable(true);
        }
        if (!SysUtils.isWayland()) {
            if (GaiaSkyDesktop.cliArgs.vr) {
                cfg.setWindowIcon(Files.FileType.Internal, new String[]{"icon/gsvr_round_256.png"});
            } else {
                cfg.setWindowIcon(Files.FileType.Internal, new String[]{"icon/gs_round_256.png"});
            }
        }
        int minor = GaiaSkyDesktop.cliArgs.vr ? 5 : 1;
        cfg.setOpenGLEmulation(Lwjgl3ApplicationConfiguration.GLEmulation.GL30, 4, minor);
        cfg.setHdpiMode(GaiaSkyDesktop.cliArgs.hdpiMode);
        cfg.setInitialVisible(!GaiaSkyDesktop.cliArgs.headless);
        if (GaiaSkyDesktop.cliArgs.debugGpu) {
            cfg.enableGLDebugOutput(true, System.out);
        }
        cfg.setBackBufferConfig(8, 8, 8, 8, 24, 8, 0);
        try {
            if (s.program.safeMode) {
                this.setSafeMode(cfg);
            }
            consoleLogger.unsubscribe();
            this.runGaiaSky(cfg);
        }
        catch (Exception e) {
            GaiaSkyDesktop.checkLogger(consoleLogger);
            logger.error(e);
            if (this.gs != null) {
                this.gs.setCrashed(true);
                try {
                    this.gs.dispose();
                }
                catch (Exception e1) {
                    logger.error(I18n.msg("error.dispose"), e1);
                }
            }
            this.showDialogOGL(e, I18n.msg("error.crash.title"));
        }
    }

    private void configureWindowSize(Lwjgl3ApplicationConfiguration cfg) {
        this.configureWindowSize(cfg, 1.0f, 1.0f);
    }

    private void configureWindowSize(Lwjgl3ApplicationConfiguration cfg, float widthFactor, float heightFactor) {
        int w = Settings.settings.graphics.getScreenWidth();
        int h = Settings.settings.graphics.getScreenHeight();
        if (w <= 0 || h <= 0) {
            int[] wh = SysUtils.getDisplayResolution();
            w = 1920;
            h = 1080;
            if (wh != null && wh.length == 2 && wh[0] > 0 && wh[1] > 0) {
                w = (int)FastMath.max((float)w, (float)((float)wh[0] * 0.85f));
                h = (int)FastMath.max((float)h, (float)((float)wh[1] * 0.85f));
            } else {
                logger.warn(I18n.msg("error.screensize.default", w, h));
            }
            Settings.settings.graphics.resolution[0] = w;
            Settings.settings.graphics.resolution[1] = h;
        }
        Settings.settings.graphics.resolution[0] = (int)((float)Settings.settings.graphics.resolution[0] * widthFactor);
        Settings.settings.graphics.resolution[1] = (int)((float)Settings.settings.graphics.resolution[1] * heightFactor);
        w = (int)((float)w * widthFactor);
        h = (int)((float)h * heightFactor);
        if (cfg != null) {
            cfg.setWindowedMode(w, h);
        }
    }

    private void runGaiaSky(Lwjgl3ApplicationConfiguration cfg) {
        this.gs = new GaiaSky(cliArgs);
        new Lwjgl3Application((ApplicationListener)this.gs, cfg);
    }

    private void setSafeMode(Lwjgl3ApplicationConfiguration cfg) {
        logger.info(I18n.msg("startup.safe.enable", "3.3", "3.3"));
        Settings.settings.scene.renderer.elevation.type = Settings.ElevationType.NONE;
        Settings.settings.program.safeMode = true;
        cfg.setOpenGLEmulation(Lwjgl3ApplicationConfiguration.GLEmulation.GL30, 3, 3);
    }

    private void showDialogOGL(Exception ex, String title) {
        Lwjgl3ApplicationConfiguration cfg = new Lwjgl3ApplicationConfiguration();
        cfg.setHdpiMode(HdpiMode.Pixels);
        cfg.useVsync(true);
        this.configureWindowSize(cfg, 0.8f, 0.9f);
        cfg.setResizable(true);
        cfg.setTitle(title);
        new Lwjgl3Application((ApplicationListener)new ErrorDialog(ex), cfg);
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case SCENE_LOADED: {
                if (!REST_ENABLED) break;
                try {
                    RESTServer.activate();
                }
                catch (IllegalArgumentException | SecurityException e) {
                    logger.error(e);
                }
                break;
            }
            case DISPOSE: {
                if (!REST_ENABLED) break;
                try {
                    RESTServer.dispose();
                }
                catch (IllegalArgumentException | SecurityException e) {
                    logger.error(e);
                }
                break;
            }
        }
    }

    public static class CLIArgs {
        @Parameter(names={"-h", "--help"}, description="Show program options and usage information.", help=true, order=0)
        public boolean help = false;
        @Parameter(names={"-v", "--version"}, description="List Gaia Sky version and relevant information.", order=1)
        public boolean version = false;
        @Parameter(names={"-i", "--ascii-art"}, description="Add nice ascii art to --version information.", order=1)
        public boolean asciiArt = false;
        @Parameter(names={"-s", "--skip-welcome"}, description="Skip the welcome screen if possible (base-data package must be present).", order=2)
        public boolean skipWelcome = false;
        @Parameter(names={"-p", "--properties"}, description="Specify the location of the properties file.", order=4)
        public String propertiesFile = null;
        @Parameter(names={"-a", "--assets"}, description="Specify the location of the assets folder. If not present, the default assets location (in the installation folder) is used.", order=5)
        public String assetsLocation = null;
        @Parameter(names={"-vr", "--openxr"}, description="Launch in Virtual Reality mode. Gaia Sky will attempt to create a VR context through OpenXR. Make sure your OpenXR runtime is running.", order=6)
        public boolean vr = false;
        @Parameter(names={"-e", "--externalview"}, description="Create a window with a view of the scene and no UI.", order=7)
        public boolean externalView = false;
        @Parameter(names={"-n", "--no-script"}, description="Do not start the scripting server. Useful to run more than one Gaia Sky instance at once in the same machine.", order=8)
        public boolean noScriptingServer = false;
        @Parameter(names={"-d", "--debug"}, description="Launch in debug mode. Prints out debug information from Gaia Sky to the logs.", order=9)
        public boolean debug = false;
        @Parameter(names={"-g", "--debug-gpu"}, description="Activate OpenGL debug mode. Prints out debug information from OpenGL to the standard output.", order=10)
        public boolean debugGpu = false;
        @Parameter(names={"--debug-input"}, description="Activate input debug mode. Prints out debug information for all input events (keyboard/mouse/controllers).", order=10)
        public boolean debugInput = false;
        @Parameter(names={"-l", "--headless"}, description="Use headless (windowless) mode, for servers.", order=11)
        public boolean headless = false;
        @Parameter(names={"--safe-mode"}, description="Activate safe graphics mode. This forces the creation of an OpenGL 3.2 context, and disables float buffers and tessellation.", order=12)
        public boolean safeMode = false;
        @Parameter(names={"--no-safe-mode"}, description="Force deactivation of safe graphics mode. Warning: this bypasses internal checks and may break things! Useful to get rid of safe graphics mode in the settings.", order=13)
        public boolean noSafeMode = false;
        @Parameter(names={"--hdpi-mode"}, description="The HDPI mode to use. Defines how HiDPI monitors are handled. Operating systems may have a per-monitor HiDPI scale setting. The operating system may report window width/height and mouse coordinates in a logical coordinate system at a lower resolution than the actual physical resolution. This setting allows you to specify whether you want to work in logical or raw pixel units.", order=14)
        public HdpiMode hdpiMode = HdpiMode.Pixels;
    }
}

