/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.desktop.util;

import gaiasky.util.coord.Coordinates;
import gaiasky.util.math.Vector3D;
import java.util.Scanner;
import net.jafama.FastMath;

public class EqGalTest {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        System.out.print("Enter right ascension [deg]: ");
        double ra = EqGalTest.readFloat(sc);
        System.out.print("Enter declination [deg]: ");
        double dec = EqGalTest.readFloat(sc);
        double dist = 10.0;
        Vector3D pos = Coordinates.sphericalToCartesian(Math.toRadians(ra), FastMath.toRadians((double)dec), dist, new Vector3D());
        Vector3D posGal = new Vector3D(pos);
        posGal.mul(Coordinates.eqToGal());
        Vector3D posGalSph = Coordinates.cartesianToSpherical(posGal, new Vector3D());
        double l = posGalSph.x * 57.29577951308232;
        double b = posGalSph.y * 57.29577951308232;
        System.out.println("Galactic coordinates - l: " + l + ", b: " + b);
    }

    private static float readFloat(Scanner sc) {
        try {
            return sc.nextFloat();
        }
        catch (Exception e) {
            System.err.println("Input is not a valid float");
            System.exit(1);
            return 0.0f;
        }
    }
}

