/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.desktop.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Files;
import gaiasky.util.Settings;
import gaiasky.util.TextUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.properties.CommentedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nFormatter {
    private static final Logger log = LoggerFactory.getLogger(I18nFormatter.class);

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage:");
            System.out.println("    I18nFormatter [REFERENCE_I18N] [OTHER_I18N]");
            System.out.println("Example:");
            System.out.println("    I18nFormatter gsbundle.properties gsbundle_ca.properties");
            return;
        }
        String ASSETS_LOC = Settings.ASSETS_LOC;
        I18n.locale = Locale.getDefault();
        Gdx.files = new Lwjgl3Files();
        Path i18nDir = Path.of(ASSETS_LOC, "i18n");
        Path p0 = i18nDir.resolve(args[0]);
        Path p1 = i18nDir.resolve(args[1]);
        File f0 = p0.toFile();
        File f1 = p1.toFile();
        if (I18nFormatter.checkFile(f0) || I18nFormatter.checkFile(f1)) {
            return;
        }
        try {
            FileInputStream fis0 = new FileInputStream(f0);
            InputStreamReader isr0 = new InputStreamReader((InputStream)fis0, StandardCharsets.UTF_8);
            CommentedProperties props0 = new CommentedProperties();
            props0.load(isr0);
            FileInputStream fis1 = new FileInputStream(f1);
            InputStreamReader isr1 = new InputStreamReader((InputStream)fis1, StandardCharsets.UTF_8);
            Properties props1 = new Properties();
            props1.load(isr1);
            isr0.close();
            isr1.close();
            CommentedProperties outputProperties = props0.clone();
            HashMap<String, String> missing = new HashMap<String, String>();
            Set<Object> keys = props0.keySet();
            for (Object key : keys) {
                String originalVal = props0.getProperty((String)key);
                String val = props1.getProperty((String)key);
                if (val != null && !val.equals(originalVal)) {
                    outputProperties.setProperty((String)key, val);
                    continue;
                }
                log.error("Property not found: " + String.valueOf(key));
                missing.put((String)key, TextUtils.escape(props0.getProperty((String)key)));
            }
            File outFile = f1;
            Files.deleteIfExists(outFile.toPath());
            FileOutputStream fos1 = new FileOutputStream(outFile, true);
            PrintStream ps = new PrintStream((OutputStream)fos1, true, StandardCharsets.UTF_8);
            outputProperties.store(ps, "\ufeff", "UTF-8", missing);
            ps.close();
            log.info("File written to " + outFile.getAbsolutePath());
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
    }

    private static boolean checkFile(File f) {
        if (!f.exists()) {
            log.error("File does not exist: " + String.valueOf(f));
            return true;
        }
        if (!f.isFile()) {
            log.error("Not a file: " + String.valueOf(f));
            return true;
        }
        if (!f.canRead()) {
            log.error("Can not read: " + String.valueOf(f));
            return true;
        }
        return false;
    }
}

