/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.desktop.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Files;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import gaiasky.gui.main.ConsoleLogger;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.TextUtils;
import gaiasky.util.i18n.I18n;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class I18nStatus {
    private static final Logger.Log logger = Logger.getLogger(I18nStatus.class);

    public static void main(String[] args) {
        CLIArgs cliArgs = new CLIArgs();
        JCommander jc = JCommander.newBuilder().addObject((Object)cliArgs).build();
        jc.setProgramName("translationstatus");
        try {
            jc.parse(args);
            if (cliArgs.help) {
                jc.usage();
                return;
            }
        }
        catch (Exception e) {
            System.out.print("bad program arguments\n\n");
            jc.usage();
            return;
        }
        String ASSETS_LOC = Settings.ASSETS_LOC;
        I18n.locale = Locale.getDefault();
        Gdx.files = new Lwjgl3Files();
        new ConsoleLogger();
        DecimalFormat df = new DecimalFormat("0.0#");
        try {
            PathMatcher globalMatcher = FileSystems.getDefault().getPathMatcher("glob:" + cliArgs.bundleFile + "*.properties");
            PathMatcher languageMatcher = FileSystems.getDefault().getPathMatcher("glob:" + cliArgs.bundleFile + "*_*.properties");
            Path i18nDir = Path.of(ASSETS_LOC, "i18n");
            List<Path> candidatePaths = Files.list(i18nDir).toList();
            ArrayList<Path> languagePaths = new ArrayList<Path>();
            Path main = null;
            for (Path p : candidatePaths) {
                Path fileName = p.getFileName();
                if (!globalMatcher.matches(fileName)) continue;
                if (languageMatcher.matches(fileName)) {
                    languagePaths.add(p);
                    logger.info("Language file: " + String.valueOf(fileName));
                    continue;
                }
                main = p;
                logger.info("Main file: " + String.valueOf(fileName));
            }
            if (main == null) {
                logger.error("Main file not found");
                return;
            }
            if (languagePaths.isEmpty()) {
                logger.error("No language files found");
                return;
            }
            FileInputStream is = new FileInputStream(main.toString());
            Properties mainProps = new Properties();
            mainProps.load(is);
            ((InputStream)is).close();
            int totalKeys = mainProps.size();
            logger.info("Total keys: " + totalKeys);
            logger.info("");
            for (Path p : languagePaths) {
                Object keyString;
                StringBuilder sb;
                String name = p.getFileName().toString();
                name = name.substring(0, name.lastIndexOf(".properties"));
                String languageCode = name.substring(name.indexOf("_") + 1);
                String country = null;
                if (languageCode.contains("_")) {
                    country = languageCode.substring(languageCode.indexOf("_") + 1);
                    languageCode = languageCode.substring(0, languageCode.indexOf("_"));
                }
                Locale locale = country == null ? new Locale(languageCode) : new Locale(languageCode, country);
                is = new FileInputStream(p.toString());
                Properties lang = new Properties();
                lang.load(is);
                ((InputStream)is).close();
                int translatedKeys = 0;
                HashSet<Object> missingKeys = new HashSet<Object>();
                Enumeration<Object> mainKeys = mainProps.keys();
                Iterator<Object> it = mainKeys.asIterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    if (lang.containsKey(key)) {
                        ++translatedKeys;
                        continue;
                    }
                    missingKeys.add(key);
                }
                HashSet<Object> unknownKeys = new HashSet<Object>();
                it = lang.keys().asIterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    if (mainProps.containsKey(key)) continue;
                    unknownKeys.add(key);
                }
                int extra = lang.size() - translatedKeys;
                double percentage = 100.0 * ((double)(translatedKeys + extra) / (double)totalKeys);
                int unknownCount = unknownKeys.size();
                logger.info(locale.getDisplayName() + " (" + String.valueOf(locale) + ")");
                logger.info("Translated: " + translatedKeys + "/" + totalKeys + (String)(extra > 0 ? " (+" + extra + " extra)" : ""));
                logger.info(df.format(percentage) + "%");
                if (cliArgs.showUnknown && translatedKeys < lang.size()) {
                    logger.info(unknownCount + " unknown keys:");
                    sb = new StringBuilder();
                    for (Object e : unknownKeys) {
                        sb.append(e).append(" ");
                    }
                    keyString = TextUtils.breakCharacters(sb.toString(), 100);
                    logger.info(keyString);
                }
                if (cliArgs.showUntranslated && missingKeys.size() > 0) {
                    logger.info(missingKeys.size() + " untranslated keys:");
                    sb = new StringBuilder();
                    for (Object e : missingKeys) {
                        sb.append(e).append(" ");
                    }
                    keyString = TextUtils.breakCharacters(sb.toString(), 100);
                    logger.info(keyString);
                }
                logger.info("");
            }
        }
        catch (IOException e) {
            logger.error(e);
        }
    }

    private static class CLIArgs {
        @Parameter(names={"-h", "--help"}, description="Show program options and usage information.", help=true, order=0)
        private boolean help = false;
        @Parameter(names={"-s", "--show-untranslated"}, description="Show untranslated keys for each language.", order=1)
        private boolean showUntranslated = false;
        @Parameter(names={"-u", "--show-unknown"}, description="Show unknown keys for each language.", order=2)
        private boolean showUnknown = false;
        @Parameter(names={"-f", "--file"}, description="The name of the file to check, either 'gsbundle' or 'objects'.", order=3)
        private String bundleFile = "gsbundle";

        private CLIArgs() {
        }
    }
}

