/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.desktop.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Files;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import gaiasky.gui.main.ConsoleLogger;
import gaiasky.util.Logger;
import gaiasky.util.SettingsManager;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.StdRandom;
import gaiasky.util.math.Vector3D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;

public class OortGenerator {
    private static final boolean writeFile = true;
    private static final float outer_radius = 15000.0f;
    private static final int N = 10000;

    public static void main(String[] args) {
        try {
            Gdx.files = new Lwjgl3Files();
            SettingsManager.initialize(new FileInputStream("../assets/conf/config.yaml"), new FileInputStream("../assets/data/dummyversion"));
            I18n.initialize(new FileHandle(System.getenv("PROJECTS") + "/gaiasky/assets/i18n/gsbundle"), new FileHandle(System.getenv("PROJECTS") + "/gaiasky/assets/i18n/objects"));
            new ConsoleLogger();
            Array<double[]> oort = null;
            oort = OortGenerator.generateOort();
            OortGenerator.writeToDisk(oort, "/tmp/");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Array<double[]> generateOort() throws RuntimeException {
        StdRandom.setSeed(100L);
        Array particles = new Array(false, 10000);
        Vector3D particle = new Vector3D();
        for (int n = 0; n < 10000; ++n) {
            double x = StdRandom.gaussian() * 15000.0 * 2.0;
            double y = StdRandom.gaussian() * 15000.0 * 2.0;
            double z = StdRandom.gaussian() * 15000.0 * 2.0;
            particle.set(x, y, z);
            particles.add((Object)new double[]{particle.x, particle.y, particle.z});
        }
        return particles;
    }

    private static void writeToDisk(Array<double[]> oort, String dir) throws IOException {
        String filePath = dir + "oort_";
        filePath = filePath + "10000particles.dat";
        FileHandle fh = new FileHandle(filePath);
        File f = fh.file();
        if (fh.exists() && f.isFile()) {
            fh.delete();
        }
        if (fh.isDirectory()) {
            throw new RuntimeException("File is directory: " + filePath);
        }
        f.createNewFile();
        FileWriter fw = new FileWriter(filePath);
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write("#X Y Z");
        bw.newLine();
        for (int i = 0; i < oort.size; ++i) {
            double[] particle = (double[])oort.get(i);
            bw.write(particle[0] + " " + particle[1] + " " + particle[2]);
            bw.newLine();
        }
        bw.close();
        Logger.getLogger(OortGenerator.class).info("File written to " + filePath);
    }
}

