/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.desktop.util;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.tools.texturepacker.TexturePacker;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;

public class PackUITextures {
    public static void main(String[] args) {
        TexturePacker.Settings x1settings = new TexturePacker.Settings();
        x1settings.scale[0] = 1.0f;
        x1settings.jpegQuality = 0.95f;
        x1settings.paddingX = 2;
        x1settings.paddingY = 2;
        x1settings.filterMag = Texture.TextureFilter.Linear;
        x1settings.filterMin = Texture.TextureFilter.Linear;
        TexturePacker.Settings x2settings = new TexturePacker.Settings();
        x2settings.scale[0] = 1.5f;
        x2settings.jpegQuality = 0.95f;
        x2settings.paddingX = 2;
        x2settings.paddingY = 2;
        x2settings.filterMag = Texture.TextureFilter.Linear;
        x2settings.filterMin = Texture.TextureFilter.Linear;
        String gs = new File("").getAbsolutePath();
        Map<String, String> themes = Map.of("default", "#709fd3");
        for (String key : themes.keySet()) {
            try {
                String hex = themes.get(key);
                Color theme = Color.decode(hex);
                PurpleReplacer.generateTheme(gs + "/assets/skins/raw/source/", gs + String.format("/assets/skins/raw/%s/", key), theme);
                TexturePacker.process((TexturePacker.Settings)x2settings, (String)(gs + String.format("/assets/skins/raw/%s/", key)), (String)(gs + String.format("/assets/skins/%s/", key)), (String)key);
                File templateFile = new File(gs + "/assets/skins/source/source.json");
                File outputDir = new File(gs + String.format("/assets/skins/%s/", key));
                if (!outputDir.exists() && outputDir.mkdirs()) {
                    System.out.println("Created output directory");
                }
                File outputFile = new File(outputDir, key + ".json");
                String jsonTemplate = Files.readString(templateFile.toPath());
                String result = PackUITextures.replaceColors(jsonTemplate, theme);
                Files.writeString(outputFile.toPath(), (CharSequence)result, new OpenOption[0]);
                System.out.println("Written to: " + outputFile.getAbsolutePath());
            }
            catch (Exception e) {
                System.out.println(String.format("Error generating theme: %s", key));
                throw new RuntimeException(e);
            }
        }
    }

    private static String replaceColors(String template, Color theme) {
        return template.replace("\"%theme_r%\"", PackUITextures.format(theme.getRed())).replace("\"%theme_g%\"", PackUITextures.format(theme.getGreen())).replace("\"%theme_b%\"", PackUITextures.format(theme.getBlue()));
    }

    private static String format(int value) {
        return String.format("%.4f", (double)value / 255.0);
    }

    public static class PurpleReplacer {
        public static void generateTheme(String inputPath, String outputPath, Color themeColor) throws Exception {
            File inputDir = new File(inputPath);
            File outputDir = new File(outputPath);
            if (!inputDir.isDirectory()) {
                System.err.println("Input path is not a directory.");
                return;
            }
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                System.err.println("Failed to create output directory.");
                return;
            }
            for (File file : Objects.requireNonNull(inputDir.listFiles())) {
                if (!file.getName().toLowerCase(Locale.ROOT).endsWith(".png")) continue;
                BufferedImage img = ImageIO.read(file);
                for (int y = 0; y < img.getHeight(); ++y) {
                    for (int x = 0; x < img.getWidth(); ++x) {
                        int argb = img.getRGB(x, y);
                        Color purpleColor = new Color(argb, true);
                        if (!PurpleReplacer.isPurple(purpleColor)) continue;
                        float weightPurpleSat = 0.3f;
                        float weightTargetSat = 0.7f;
                        float weightPurpleBr = 0.3f;
                        float weightTargetBr = 0.7f;
                        float[] purpleHSB = Color.RGBtoHSB(purpleColor.getRed(), purpleColor.getGreen(), purpleColor.getBlue(), null);
                        float purpleSat = purpleHSB[1];
                        float purpleBr = purpleHSB[2];
                        boolean isTargetGrayscale = themeColor.getRed() == themeColor.getBlue() && themeColor.getBlue() == themeColor.getGreen();
                        float[] targetHSB = Color.RGBtoHSB(themeColor.getRed(), themeColor.getGreen(), themeColor.getBlue(), null);
                        float targetHue = targetHSB[0];
                        float targetSat = targetHSB[1];
                        float targetBr = targetHSB[2];
                        float finalSat = isTargetGrayscale ? 0.0f : purpleSat * weightPurpleSat + targetSat * weightTargetSat;
                        float finalBr = purpleBr * weightPurpleBr + targetBr * weightTargetBr;
                        int rgb = Color.HSBtoRGB(targetHue, finalSat, finalBr);
                        Color newColor = new Color(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, purpleColor.getAlpha());
                        img.setRGB(x, y, newColor.getRGB());
                    }
                }
                File outputFile = new File(outputDir, file.getName());
                ImageIO.write((RenderedImage)img, "png", outputFile);
                System.out.println("Saved: " + outputFile.getAbsolutePath());
            }
            System.out.println("Done.");
        }

        private static boolean isPurple(Color color) {
            int r = color.getRed();
            int g = color.getGreen();
            int b = color.getBlue();
            return r > 0 && b > 0 && (double)g < 0.5 * (double)Math.min(r, b);
        }
    }
}

