/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.event;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.TimeUtils;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.IObserver;
import gaiasky.event.PriorityQueue;
import gaiasky.event.Telegram;
import gaiasky.scene.entity.EntityRadio;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class EventManager
implements IObserver {
    public static final EventManager instance = new EventManager();
    private final Map<TimeFrame, PriorityQueue<Telegram>> delayedQueue;
    private final List<Telegram> waitingList;
    private final Pool<Telegram> pool;
    private final Map<Integer, Set<IObserver>> subscriptions = new ConcurrentHashMap<Integer, Set<IObserver>>();
    private TimeFrame defaultTimeFrame;

    public EventManager() {
        this.pool = new Pool<Telegram>(this, 20){

            protected Telegram newObject() {
                return new Telegram();
            }
        };
        this.delayedQueue = new HashMap<TimeFrame, PriorityQueue<Telegram>>(TimeFrame.values().length);
        for (TimeFrame tf : TimeFrame.values()) {
            PriorityQueue pq = new PriorityQueue();
            this.delayedQueue.put(tf, pq);
        }
        this.defaultTimeFrame = TimeFrame.REAL_TIME;
        this.waitingList = Collections.synchronizedList(new ArrayList());
        this.subscribe((IObserver)this, Event.EVENT_TIME_FRAME_CMD);
    }

    public static void publish(Event event, Object source, Object ... data) {
        instance.post(event, source, data);
    }

    public static void publishDelayed(Event event, Object source, long delayMs, Object ... data) {
        instance.postDelayed(event, source, delayMs, data);
    }

    public static void publishWaitUntilConsumer(Event event, Object source, Object ... data) {
        instance.postWaitUntilConsumer(event, source, data);
    }

    public void subscribe(IObserver observer, Event ... events) {
        for (Event event : events) {
            this.subscribe(observer, event);
        }
    }

    public void subscribe(IObserver listener, Event msg) {
        Set listeners = this.subscriptions.computeIfAbsent(msg.ordinal(), k -> ConcurrentHashMap.newKeySet(3));
        listeners.add(listener);
    }

    public void unsubscribe(IObserver listener, Event ... events) {
        for (Event event : events) {
            this.unsubscribe(listener, event);
        }
    }

    public void unsubscribe(IObserver listener, Event event) {
        Set<IObserver> listeners = this.subscriptions.get(event.ordinal());
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public void removeAllSubscriptions(IObserver listener) {
        Set<Integer> km = this.subscriptions.keySet();
        for (int key : km) {
            this.subscriptions.get(key).remove(listener);
        }
    }

    public void removeAllSubscriptions(IObserver ... listeners) {
        Set<Integer> km = this.subscriptions.keySet();
        for (int key : km) {
            for (IObserver listener : listeners) {
                this.subscriptions.get(key).remove(listener);
            }
        }
    }

    public void removeRadioSubscriptions(Entity entity) {
        Set<Integer> km = this.subscriptions.keySet();
        for (int key : km) {
            Set<IObserver> set = this.subscriptions.get(key);
            Iterator<IObserver> it = set.iterator();
            while (it.hasNext()) {
                EntityRadio radio;
                IObserver obs = it.next();
                if (!(obs instanceof EntityRadio) || (radio = (EntityRadio)obs).getEntity() != entity) continue;
                it.remove();
            }
        }
    }

    public void clearAllSubscriptions() {
        this.subscriptions.clear();
    }

    public void post(Event event, Object source) {
        this.post(event, source, new Object[0]);
    }

    public void post(Event event, Object source, Object ... data) {
        Set<IObserver> observers = this.subscriptions.get(event.ordinal());
        if (observers != null && !observers.isEmpty()) {
            for (IObserver observer : observers) {
                observer.notify(event, source, data);
            }
        }
    }

    public void postWaitUntilConsumer(Event event, Object source, Object ... data) {
        Set<IObserver> observers = this.subscriptions.get(event.ordinal());
        if (observers == null || observers.isEmpty()) {
            Telegram t = (Telegram)this.pool.obtain();
            t.event = event;
            t.source = source;
            t.data = data;
            t.timestamp = this.defaultTimeFrame.getCurrentTimeMs();
            this.waitingList.add(t);
        } else {
            for (IObserver observer : observers) {
                observer.notify(event, source, data);
            }
        }
    }

    public void postDelayed(Event event, Object source, long delayMs, Object ... data) {
        this.postDelayed(event, source, delayMs, this.defaultTimeFrame, data);
    }

    public void postDelayed(Event event, Object source, long delayMs, TimeFrame frame, Object ... data) {
        if (delayMs <= 0L) {
            this.post(event, source, data);
        } else {
            Telegram t = (Telegram)this.pool.obtain();
            t.event = event;
            t.source = source;
            t.data = data;
            t.timestamp = frame.getCurrentTimeMs() + delayMs;
            this.delayedQueue.get((Object)frame).add(t);
        }
    }

    public void dispatchDelayedMessages() {
        for (TimeFrame tf : this.delayedQueue.keySet()) {
            this.dispatch(this.delayedQueue.get((Object)tf), tf.getCurrentTimeMs());
        }
        if (!this.waitingList.isEmpty()) {
            Iterator<Telegram> it = this.waitingList.iterator();
            while (it.hasNext()) {
                Telegram t = it.next();
                Set<IObserver> observers = this.subscriptions.get(t.event.ordinal());
                if (observers == null || observers.isEmpty()) continue;
                for (IObserver observer : observers) {
                    observer.notify(t.event, t.source, t.data);
                }
                it.remove();
            }
        }
    }

    private void dispatch(PriorityQueue<Telegram> queue, long currentTime) {
        if (queue.size() == 0) {
            return;
        }
        do {
            Telegram telegram = queue.peek();
            if (telegram.timestamp > currentTime) break;
            this.discharge(telegram);
            queue.poll();
        } while (queue.size() > 0);
    }

    private void discharge(Telegram telegram) {
        this.post(telegram.event, telegram.source, telegram.data);
        this.pool.free((Object)telegram);
    }

    public boolean hasSubscriptors(Event event) {
        Set<IObserver> scr = this.subscriptions.get(event.ordinal());
        return scr != null && !scr.isEmpty();
    }

    public boolean isSubscribedTo(IObserver o, Event event) {
        Set<IObserver> scr = this.subscriptions.get(event.ordinal());
        return scr != null && scr.contains(o);
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.EVENT_TIME_FRAME_CMD) {
            this.defaultTimeFrame = (TimeFrame)((Object)data[0]);
        }
    }

    public static enum TimeFrame {
        REAL_TIME,
        SIMULATION_TIME;


        public long getCurrentTimeMs() {
            if (this.equals((Object)REAL_TIME)) {
                return TimeUtils.millis();
            }
            if (this.equals((Object)SIMULATION_TIME)) {
                return GaiaSky.instance.time.getTime().toEpochMilli();
            }
            return -1L;
        }
    }
}

