/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import gaiasky.gui.bookmarks.BookmarksManager;
import gaiasky.gui.window.GenericDialog;
import gaiasky.util.TextUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector3D;
import gaiasky.util.scene2d.OwnLabel;
import java.time.Instant;
import java.util.Locale;
import java.util.Objects;

public class BookmarkInfoDialog
extends GenericDialog {
    private BookmarksManager.BookmarkNode bookmark;

    public BookmarkInfoDialog(Stage stage, Skin skin) {
        super(I18n.msg("gui.bookmark.info"), skin, stage);
        this.setModal(false);
        this.setAcceptText(I18n.msg("gui.close"));
        this.buildSuper();
    }

    @Override
    protected void build() {
        this.content.clear();
        float pad = 8.0f;
        float pad34 = 70.0f;
        float minWidth = 300.0f;
        if (this.bookmark != null) {
            String type = TextUtils.trueCapitalise(I18n.msg("gui.bookmark.info.type." + this.bookmark.type.name().toLowerCase(Locale.ROOT)));
            OwnLabel bookmarkType = new OwnLabel((CharSequence)type, this.skin, "default-blue");
            this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.bookmark.info.type"), this.skin, "header-s")).left().padRight(pad34).padBottom(pad10).minWidth(minWidth);
            this.content.add((Actor)bookmarkType).pad(pad, 0.0f, pad20, pad).left().padBottom(pad10).minWidth(minWidth).row();
            if (this.bookmark.isTypeObject()) {
                OwnLabel bookmarkObject = new OwnLabel((CharSequence)this.bookmark.name, this.skin, "default-pink");
                this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.bookmark.info.object.name"), this.skin, "header-s")).left().padRight(pad34).padBottom(pad10).minWidth(minWidth);
                this.content.add((Actor)bookmarkObject).pad(pad, 0.0f, pad20, pad).left().padBottom(pad10).minWidth(minWidth).row();
            } else if (this.bookmark.isTypeLocation()) {
                OwnLabel bookmarkName = new OwnLabel((CharSequence)this.bookmark.name, this.skin, "default-pink");
                this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.bookmark.info.name"), this.skin, "header-s")).left().padRight(pad34).padBottom(pad10).minWidth(minWidth);
                this.content.add((Actor)bookmarkName).pad(pad, 0.0f, pad20, pad).left().padBottom(pad10).minWidth(minWidth).row();
                OwnLabel bookmarkPosition = new OwnLabel((CharSequence)this.vectorToString(this.bookmark.position), this.skin);
                this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.bookmark.info.location.position"), this.skin, "header-s")).left().padRight(pad34).padBottom(pad10).minWidth(minWidth);
                this.content.add((Actor)bookmarkPosition).pad(pad, 0.0f, pad20, pad).left().padBottom(pad10).minWidth(minWidth).row();
                OwnLabel bookmarkDirection = new OwnLabel((CharSequence)this.vectorToString(this.bookmark.direction), this.skin);
                this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.bookmark.info.location.direction"), this.skin, "header-s")).left().padRight(pad34).padBottom(pad10).minWidth(minWidth);
                this.content.add((Actor)bookmarkDirection).pad(pad, 0.0f, pad20, pad).left().padBottom(pad10).minWidth(minWidth).row();
                OwnLabel bookmarkUp = new OwnLabel((CharSequence)this.vectorToString(this.bookmark.up), this.skin);
                this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.bookmark.info.location.up"), this.skin, "header-s")).left().padRight(pad34).padBottom(pad10).minWidth(minWidth);
                this.content.add((Actor)bookmarkUp).pad(pad, 0.0f, pad20, pad).left().padBottom(pad10).minWidth(minWidth).row();
                OwnLabel bookmarkTime = new OwnLabel((CharSequence)this.instantToString(this.bookmark.time), this.skin);
                this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.bookmark.info.location.time"), this.skin, "header-s")).left().padRight(pad34).padBottom(pad10).minWidth(minWidth);
                this.content.add((Actor)bookmarkTime).pad(pad, 0.0f, pad20, pad).left().padBottom(pad10).minWidth(minWidth).row();
                OwnLabel bookmarkObject = new OwnLabel((CharSequence)this.stringToString(this.bookmark.focus), this.skin);
                this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.bookmark.info.location.focus"), this.skin, "header-s")).left().padRight(pad34).padBottom(pad10).minWidth(minWidth);
                this.content.add((Actor)bookmarkObject).pad(pad, 0.0f, pad20, pad).left().padBottom(pad10).minWidth(minWidth).row();
                OwnLabel bookmarkSettings = new OwnLabel((CharSequence)this.yesNo(this.bookmark.uuid), this.skin);
                this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.bookmark.info.location.settings"), this.skin, "header-s")).left().padRight(pad34).padBottom(pad10).minWidth(minWidth);
                this.content.add((Actor)bookmarkSettings).pad(pad, 0.0f, pad20, pad).left().padBottom(pad10).minWidth(minWidth).row();
                OwnLabel bookmarkUUID = new OwnLabel((CharSequence)this.stringToString(this.bookmark.uuid), this.skin, this.bookmark.uuid != null ? "mono-pink" : "default");
                this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.bookmark.info.location.settings.id"), this.skin, "header-s")).left().padRight(pad34).padBottom(pad10).minWidth(minWidth);
                this.content.add((Actor)bookmarkUUID).pad(pad, 0.0f, pad20, pad).left().padBottom(pad10).minWidth(minWidth).row();
            } else if (this.bookmark.isTypeFolder()) {
                OwnLabel bookmarkObject = new OwnLabel((CharSequence)this.bookmark.name, this.skin, "default-pink");
                this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.bookmark.info.folder.name"), this.skin, "header-s")).left().padRight(pad34).padBottom(pad10).minWidth(minWidth);
                this.content.add((Actor)bookmarkObject).pad(pad, 0.0f, pad20, pad).left().padBottom(pad10).minWidth(minWidth).row();
                OwnLabel bookmarkPath = new OwnLabel((CharSequence)this.bookmark.path.toString(), this.skin);
                this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.bookmark.info.folder.path"), this.skin, "header-s")).left().padRight(pad34).padBottom(pad10).minWidth(minWidth);
                this.content.add((Actor)bookmarkPath).pad(pad, 0.0f, pad20, pad).left().padBottom(pad10).minWidth(minWidth).row();
                OwnLabel bookmarksNum = new OwnLabel((CharSequence)Integer.toString(this.bookmark.countBookmarksRec()), this.skin);
                this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.bookmark.info.folder.number"), this.skin, "header-s")).left().padRight(pad34).padBottom(pad10).minWidth(minWidth);
                this.content.add((Actor)bookmarksNum).pad(pad, 0.0f, pad20, pad).left().padBottom(pad10).minWidth(minWidth).row();
            }
        }
    }

    private String vectorToString(Vector3D v) {
        if (v != null) {
            return v.toString();
        }
        return I18n.msg("gui.none");
    }

    private String instantToString(Instant i) {
        if (i != null) {
            return i.toString();
        }
        return I18n.msg("gui.none");
    }

    private String stringToString(String s) {
        return Objects.requireNonNullElse(s, I18n.msg("gui.none"));
    }

    private String yesNo(String s) {
        if (s != null) {
            return I18n.msg("gui.yes");
        }
        return I18n.msg("gui.no");
    }

    public void updateView(BookmarksManager.BookmarkNode bookmark) {
        this.bookmark = bookmark;
        this.build();
    }

    @Override
    protected boolean accept() {
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }
}

