/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.beans;

import gaiasky.util.i18n.I18n;

public class DistanceUnitComboBoxBean {
    public String name;
    public DistanceUnit unit;

    public DistanceUnitComboBoxBean(DistanceUnit unit) {
        this.unit = unit;
        this.name = unit.text();
    }

    public static DistanceUnitComboBoxBean[] defaultBeans() {
        int i = 0;
        DistanceUnitComboBoxBean[] beans = new DistanceUnitComboBoxBean[DistanceUnit.values().length];
        for (DistanceUnit unit : DistanceUnit.values()) {
            beans[i++] = new DistanceUnitComboBoxBean(unit);
        }
        return beans;
    }

    public String toString() {
        return this.name;
    }

    public static enum DistanceUnit {
        M(0.001, I18n.msg("gui.unit.m")),
        KM(1.0, I18n.msg("gui.unit.km")),
        AU(1.49597871E8, I18n.msg("gui.unit.au")),
        LY(9.46073E12, I18n.msg("gui.unit.ly")),
        PC(3.08567758149137E13, I18n.msg("gui.unit.pc"));

        private final double toKm;
        private final String text;

        private DistanceUnit(double toKm, String text) {
            this.toKm = toKm;
            this.text = text;
        }

        public String text() {
            return this.text;
        }

        public double toKm(double value) {
            return value * this.toKm;
        }
    }
}

