/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.beans;

import gaiasky.util.i18n.I18n;
import java.util.Locale;

public class OrientationComboBoxBean {
    public String name;
    public ShapeOrientation orientation;

    public OrientationComboBoxBean(ShapeOrientation orientation) {
        this.orientation = orientation;
        this.name = I18n.msg("gui.shape.orientation." + orientation.name().toLowerCase(Locale.ROOT));
    }

    public static OrientationComboBoxBean[] defaultOrientations() {
        int i = 0;
        OrientationComboBoxBean[] orientations = new OrientationComboBoxBean[ShapeOrientation.values().length];
        for (ShapeOrientation s : ShapeOrientation.values()) {
            orientations[i++] = new OrientationComboBoxBean(s);
        }
        return orientations;
    }

    public String toString() {
        return this.name;
    }

    public static enum ShapeOrientation {
        CAMERA,
        EQUATORIAL,
        ECLIPTIC,
        GALACTIC;

    }
}

