/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.bookmarks;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.window.GenericDialog;
import gaiasky.scene.camera.ICamera;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.scene2d.OwnCheckBox;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.scene2d.Separator;
import gaiasky.util.validator.FolderValidator;
import gaiasky.util.validator.LengthValidator;
import gaiasky.util.validator.StringValidator;
import java.time.Instant;

public class BookmarkNameDialog
extends GenericDialog
implements IObserver {
    private static int SEQ_NUM = 0;
    private OwnTextField bookmarkName;
    private OwnLabel errorText;
    private OwnCheckBox positionCb;
    private OwnCheckBox orientationCb;
    private OwnCheckBox timeCb;
    private OwnCheckBox settingsCb;
    private OwnCheckBox focusCb;

    public BookmarkNameDialog(Stage stage, Skin skin) {
        super(I18n.msg("context.bookmark.pos"), skin, stage);
        this.setAcceptText(I18n.msg("gui.ok"));
        this.setCancelText(I18n.msg("gui.cancel"));
        this.buildSuper();
    }

    @Override
    protected void build() {
        float inputWidth = 360.0f;
        float pad = 8.0f;
        this.bookmarkName = new OwnTextField("", this.skin);
        this.bookmarkName.setMaxLength(30);
        this.bookmarkName.setWidth(inputWidth);
        this.bookmarkName.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.check();
                return true;
            }
            return false;
        });
        FolderValidator folderValidator = new FolderValidator();
        StringValidator stringValidator = new StringValidator(folderValidator, new Character[]{Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'), Character.valueOf(',')});
        LengthValidator val = new LengthValidator(stringValidator, 1, 30);
        this.bookmarkName.setValidator(val);
        this.positionCb = new OwnCheckBox(I18n.msg("gui.bookmark.cb.position"), this.skin, pad10);
        this.positionCb.setChecked(true);
        this.positionCb.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.check();
                return true;
            }
            return false;
        });
        this.orientationCb = new OwnCheckBox(I18n.msg("gui.bookmark.cb.orientation"), this.skin, pad10);
        this.orientationCb.setChecked(true);
        this.orientationCb.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.check();
                return true;
            }
            return false;
        });
        this.timeCb = new OwnCheckBox(I18n.msg("gui.bookmark.cb.time"), this.skin, pad10);
        this.timeCb.setChecked(true);
        this.timeCb.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.check();
                return true;
            }
            return false;
        });
        this.focusCb = new OwnCheckBox(I18n.msg("gui.bookmark.cb.focus"), this.skin, pad10);
        this.focusCb.setChecked(false);
        this.updateFocusCheckbox();
        this.focusCb.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.check();
                return true;
            }
            return false;
        });
        this.settingsCb = new OwnCheckBox(I18n.msg("gui.bookmark.cb.settings"), this.skin, pad10);
        this.settingsCb.setChecked(false);
        this.settingsCb.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.check();
                return true;
            }
            return false;
        });
        this.errorText = new OwnLabel((CharSequence)"", this.skin, "default-red");
        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.bookmark.name"), this.skin)).left().padRight(pad).padBottom(pad34);
        this.content.add((Actor)this.bookmarkName).pad(pad, 0.0f, pad20, pad).left().padBottom(pad34).row();
        this.content.add((Actor)new Separator(this.skin, "gray")).left().colspan(2).fillX().padBottom(pad).row();
        this.content.add((Actor)this.positionCb).pad(pad, 0.0f, pad, pad).left().colspan(2).row();
        this.content.add((Actor)this.orientationCb).pad(pad, 0.0f, pad, pad).left().colspan(2).row();
        this.content.add((Actor)this.timeCb).pad(pad, 0.0f, pad, pad).left().colspan(2).row();
        this.content.add((Actor)this.focusCb).pad(pad, 0.0f, pad, pad).left().colspan(2).row();
        this.content.add((Actor)this.settingsCb).pad(pad, 0.0f, pad, pad).left().colspan(2).padBottom(pad20).row();
        this.content.add((Actor)this.errorText).center().colspan(2);
        EventManager.instance.subscribe((IObserver)this, Event.CAMERA_MODE_CMD);
    }

    public void resetName() {
        this.bookmarkName.setText("bookmark_" + ++SEQ_NUM);
    }

    @Override
    protected boolean accept() {
        Settings settings;
        ICamera cam = GaiaSky.instance.getICamera();
        Vector3Q pos = this.positionCb.isChecked() ? cam.getPos() : null;
        Vector3D dir = this.orientationCb.isChecked() ? cam.getDirection() : null;
        Vector3D up = this.orientationCb.isChecked() ? cam.getUp() : null;
        Instant time = this.timeCb.isChecked() ? GaiaSky.instance.time.getTime() : null;
        String focus = this.focusCb.isChecked() ? GaiaSky.instance.getCameraManager().getFocus().getName() : null;
        Settings settings2 = settings = this.settingsCb.isChecked() ? Settings.settings.clone() : null;
        if (this.check()) {
            EventManager.publish(Event.BOOKMARKS_ADD, this, pos, dir, up, time, focus, settings, this.bookmarkName.getText(), false);
            return true;
        }
        return false;
    }

    private boolean check() {
        if (!this.bookmarkName.isValid()) {
            this.error(I18n.msg("gui.bookmark.error.name"));
            this.acceptButton.setDisabled(true);
            return false;
        }
        if (!(this.positionCb.isChecked() || this.orientationCb.isChecked() || this.timeCb.isChecked() || this.focusCb.isChecked() || this.settingsCb.isChecked())) {
            this.error(I18n.msg("gui.bookmark.error.cb"));
            this.acceptButton.setDisabled(true);
            return false;
        }
        this.error(null);
        this.acceptButton.setDisabled(false);
        return true;
    }

    private void updateFocusCheckbox() {
        if (this.focusCb != null) {
            this.focusCb.setDisabled(!GaiaSky.instance.getCameraManager().getMode().isFocus());
        }
    }

    private void error(String info) {
        if (info == null) {
            this.errorText.setText("");
        } else {
            this.errorText.setText(info);
        }
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.CAMERA_MODE_CMD) {
            this.updateFocusCheckbox();
        }
    }
}

