/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.bookmarks;

import gaiasky.util.ArrayUtils;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;

public class BookmarkPath
implements Path {
    private static final String separator = "/";
    private final String pathString;
    private final String[] tokens;
    private final Path parent;

    public BookmarkPath(String path) {
        if (path != null && !path.isEmpty()) {
            this.tokens = path.split(separator);
            this.pathString = path;
            this.parent = this.tokens.length > 1 ? new BookmarkPath(Arrays.copyOf(this.tokens, this.tokens.length - 1)) : null;
        } else {
            this.tokens = null;
            this.parent = null;
            this.pathString = null;
        }
    }

    public BookmarkPath(String[] tokens) {
        this.tokens = tokens;
        this.parent = tokens != null && tokens.length > 1 ? new BookmarkPath(Arrays.copyOf(tokens, tokens.length - 1)) : null;
        this.pathString = this.constructString();
    }

    @Override
    public FileSystem getFileSystem() {
        return new BookmarksFileSystem(this);
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public Path getRoot() {
        if (this.tokens != null && this.tokens.length > 0) {
            return new BookmarkPath(this.tokens[0]);
        }
        return null;
    }

    @Override
    public Path getFileName() {
        if (this.tokens != null && this.tokens.length > 0) {
            return new BookmarkPath(this.tokens[this.tokens.length - 1]);
        }
        return null;
    }

    @Override
    public Path getParent() {
        return this.parent;
    }

    @Override
    public int getNameCount() {
        return 0;
    }

    @Override
    public Path getName(int i) {
        return null;
    }

    @Override
    public Path subpath(int i, int i1) {
        return null;
    }

    @Override
    public boolean startsWith(Path path) {
        return false;
    }

    @Override
    public boolean endsWith(Path path) {
        return false;
    }

    @Override
    public Path normalize() {
        return null;
    }

    @Override
    public Path resolve(Path path) {
        return this.resolve(path.toString());
    }

    @Override
    public Path resolve(String other) {
        String[] otherTokens = other.split(separator);
        String[] t = ArrayUtils.concatWithArrayCopy(this.tokens, otherTokens);
        return new BookmarkPath(t);
    }

    @Override
    public Path relativize(Path path) {
        return null;
    }

    @Override
    public URI toUri() {
        return null;
    }

    @Override
    public Path toAbsolutePath() {
        return this;
    }

    @Override
    public Path toRealPath(LinkOption ... linkOptions) throws IOException {
        return this;
    }

    @Override
    public WatchKey register(WatchService watchService, WatchEvent.Kind<?>[] kinds, WatchEvent.Modifier ... modifiers) throws IOException {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookmarkPath paths = (BookmarkPath)o;
        return Objects.equals(this.pathString, paths.pathString);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pathString);
    }

    @Override
    public int compareTo(Path path) {
        if (path instanceof BookmarkPath) {
            return this.pathString.compareTo(((BookmarkPath)path).pathString);
        }
        return this.pathString.compareTo(path.toString());
    }

    @Override
    public String toString() {
        return this.pathString;
    }

    public String constructString() {
        if (this.tokens == null || this.tokens.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.tokens.length; ++i) {
            sb.append(this.tokens[i]);
            if (i >= this.tokens.length - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public class BookmarksFileSystem
    extends FileSystem {
        public BookmarksFileSystem(BookmarkPath this$0) {
        }

        @Override
        public FileSystemProvider provider() {
            return null;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public String getSeparator() {
            return BookmarkPath.separator;
        }

        @Override
        public Iterable<Path> getRootDirectories() {
            return null;
        }

        @Override
        public Iterable<FileStore> getFileStores() {
            return null;
        }

        @Override
        public Set<String> supportedFileAttributeViews() {
            return null;
        }

        @Override
        public Path getPath(String s, String ... strings) {
            return null;
        }

        @Override
        public PathMatcher getPathMatcher(String s) {
            return null;
        }

        @Override
        public UserPrincipalLookupService getUserPrincipalLookupService() {
            return null;
        }

        @Override
        public WatchService newWatchService() throws IOException {
            return null;
        }
    }
}

