/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.bookmarks;

import com.badlogic.gdx.utils.Null;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.bookmarks.BookmarkPath;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SettingsManager;
import gaiasky.util.SysUtils;
import gaiasky.util.TextUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.parse.Parser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;

public class BookmarksManager
implements IObserver {
    private static final Logger.Log logger = Logger.getLogger(BookmarksManager.class);
    private Path bookmarksFile;
    private List<BookmarkNode> bookmarks;
    private Map<Path, BookmarkNode> nodes;
    private int version;

    public BookmarksManager() {
        this.initDefault();
        EventManager.instance.subscribe((IObserver)this, Event.BOOKMARKS_ADD, Event.BOOKMARKS_REMOVE, Event.BOOKMARKS_REMOVE_ALL, Event.BOOKMARKS_MOVE, Event.BOOKMARKS_MOVE_UP, Event.BOOKMARKS_MOVE_DOWN);
    }

    private void initDefault() {
        String bookmarksFileName = "bookmarks.txt";
        Path customBookmarks = SysUtils.getDefaultBookmarksDir().resolve("bookmarks.txt");
        Path defaultBookmarks = Paths.get(Settings.ASSETS_LOC, SysUtils.getBookmarksDirName(), "bookmarks.txt");
        this.bookmarksFile = customBookmarks;
        if (!Files.exists(customBookmarks, new LinkOption[0])) {
            this.overwriteBookmarksFile(defaultBookmarks, customBookmarks, false);
        } else {
            int customVersion = this.getFileVersion(customBookmarks);
            int defaultVersion = this.getFileVersion(defaultBookmarks);
            if (defaultVersion > customVersion) {
                this.overwriteBookmarksFile(defaultBookmarks, customBookmarks, true);
            }
        }
        logger.info(I18n.msg("gui.bookmark.file.use", this.bookmarksFile));
        this.bookmarks = this.loadBookmarks(this.bookmarksFile);
        this.version = this.getFileVersion(this.bookmarksFile);
        if (this.bookmarks != null) {
            logger.info(I18n.msg("gui.bookmark.loaded", this.bookmarks.size()));
        }
    }

    private void overwriteBookmarksFile(Path src, Path dst, boolean backup) {
        assert (src != null && src.toFile().exists() && src.toFile().isFile() && src.toFile().canRead()) : I18n.msg("error.file.exists.readable", src != null ? src.getFileName().toString() : "null");
        assert (dst != null) : I18n.msg("notif.null.not", "dest");
        if (backup && dst.toFile().exists() && dst.toFile().canRead()) {
            Date date = Calendar.getInstance().getTime();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-hhmmss");
            String strDate = dateFormat.format(date);
            String backupName = dst.getFileName().toString() + "." + strDate;
            Path backupFile = dst.getParent().resolve(backupName);
            try {
                Files.copy(dst, backupFile, StandardCopyOption.REPLACE_EXISTING);
                logger.info(I18n.msg("notif.file.backup", backupFile));
            }
            catch (IOException e) {
                logger.error(e);
            }
        }
        try {
            Files.copy(src, dst, StandardCopyOption.REPLACE_EXISTING);
            logger.info(I18n.msg("notif.file.update", dst.toString()));
            if (backup) {
                EventManager.publishWaitUntilConsumer(Event.POST_POPUP_NOTIFICATION, this, I18n.msg("notif.file.overriden.backup", dst.toString()), Float.valueOf(-1.0f));
            } else {
                EventManager.publishWaitUntilConsumer(Event.POST_POPUP_NOTIFICATION, this, I18n.msg("notif.file.overriden", dst.toString()), Float.valueOf(-1.0f));
            }
        }
        catch (IOException e) {
            logger.error(e);
        }
    }

    private int getFileVersion(Path path) {
        Optional<String> l = TextUtils.readFirstLine(path);
        if (l.isPresent()) {
            String firstLine = l.get().strip();
            if (!firstLine.isBlank()) {
                if (firstLine.startsWith("#v")) {
                    return Parser.parseIntException(firstLine.substring(2));
                }
                logger.warn(I18n.msg("error.file.version", path));
            } else {
                logger.warn(I18n.msg("error.file.version", path));
            }
        }
        return -1;
    }

    public List<BookmarkNode> getBookmarks() {
        return this.bookmarks;
    }

    public List<BookmarkNode> getFolders() {
        return this.getBookmarksByType(this.bookmarks, new ArrayList<BookmarkNode>(), true);
    }

    public List<BookmarkNode> getBookmarksByType(List<BookmarkNode> bookmarks, List<BookmarkNode> result, boolean folder) {
        if (bookmarks != null) {
            for (BookmarkNode bookmark : bookmarks) {
                if (bookmark.isTypeFolder() == folder) {
                    result.add(bookmark);
                }
                this.getBookmarksByType(bookmark.children, result, folder);
            }
        }
        return result;
    }

    private List<BookmarkNode> loadBookmarks(Path file) {
        List<BookmarkNode> list;
        block9: {
            Stream<String> lines = Files.lines(file);
            try {
                List<String> bookmarks = lines.filter(line -> !line.strip().startsWith("#")).filter(line -> !line.isBlank()).map(String::strip).toList();
                this.nodes = new HashMap<Path, BookmarkNode>();
                this.bookmarks = new ArrayList<BookmarkNode>();
                for (String bookmark : bookmarks) {
                    this.insertBookmark(bookmark, bookmark.endsWith("/"));
                }
                list = this.bookmarks;
                if (lines == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error(e);
                    return null;
                }
            }
            lines.close();
        }
        return list;
    }

    public boolean containsName(String name) {
        boolean contains = false;
        for (BookmarkNode bookmark : this.bookmarks) {
            contains = contains || this.containsNameRecursive(name, bookmark);
        }
        return contains;
    }

    public boolean containsNameRecursive(String name, BookmarkNode node) {
        if (node.name.equals(name)) {
            return true;
        }
        if (node.children != null) {
            boolean contains = false;
            for (BookmarkNode child : node.children) {
                contains |= this.containsNameRecursive(name, child);
            }
            return contains;
        }
        return false;
    }

    public boolean containsPath(Path path) {
        return this.nodes != null && this.nodes.containsKey(path);
    }

    public synchronized void persistBookmarks() {
        this.persistBookmarks(this.bookmarksFile);
    }

    private synchronized void persistBookmarks(Path file) {
        if (this.bookmarks != null) {
            StringBuilder content = new StringBuilder();
            if (this.version >= 0) {
                content.append(String.format("#v%04d\n", this.version));
            }
            content.append("# Bookmarks file for Gaia Sky, one bookmark per line, folder separator: '/', comments: '#'");
            this.buildContent(content, this.bookmarks);
            try {
                Files.delete(file);
                Files.write(file, content.toString().getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                logger.error(e);
            }
        }
    }

    private void buildContent(StringBuilder content, List<BookmarkNode> bookmarks) {
        for (BookmarkNode b : bookmarks) {
            if (b.children == null || b.children.isEmpty()) {
                if (b.isTypeFolder() && !b.path.toString().endsWith("/")) {
                    content.append("\n").append(b.path).append("/");
                    continue;
                }
                content.append("\n").append(b.path.toString());
                continue;
            }
            this.buildContent(content, b.children);
        }
    }

    public synchronized boolean addBookmark(String path, boolean folder) {
        boolean added = false;
        if (this.bookmarks != null) {
            added = this.insertBookmark(path, folder);
        }
        return added;
    }

    private synchronized boolean insertBookmark(String path, boolean folder) {
        BookmarkPath p;
        if (folder && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (!this.nodes.containsKey(p = new BookmarkPath(path))) {
            BookmarkNode node = new BookmarkNode(p, folder);
            this.nodes.put(p, node);
            BookmarkNode curr = node;
            while (curr.path.getParent() != null) {
                if (!this.nodes.containsKey(curr.path.getParent())) {
                    BookmarkNode bookmarkNode = new BookmarkNode(curr.path.getParent(), true);
                    this.nodes.put(bookmarkNode.path, bookmarkNode);
                }
                BookmarkNode parentNode = this.nodes.get(curr.path.getParent());
                parentNode.insert(curr);
                curr = parentNode;
            }
            if (!this.bookmarks.contains(curr)) {
                this.bookmarks.add(curr);
            }
            return true;
        }
        return false;
    }

    public synchronized boolean remove(BookmarkNode bookmark) {
        if (bookmark.uuid != null) {
            Path parent = SysUtils.getDefaultBookmarksDir().resolve("settings");
            Path settingsFile = parent.resolve(bookmark.uuid);
            try {
                Files.deleteIfExists(settingsFile);
                return true;
            }
            catch (IOException e) {
                logger.error(I18n.msg("error.file.delete", settingsFile.toAbsolutePath().toString()), e);
            }
        }
        return false;
    }

    public synchronized boolean removeBookmark(String path, boolean move) {
        BookmarkPath p = new BookmarkPath(path);
        if (this.nodes != null && this.nodes.containsKey(p)) {
            BookmarkNode n = this.nodes.get(p);
            if (n.parent != null) {
                n.parent.children.remove(n);
                n.parent = null;
            } else {
                this.bookmarks.remove(n);
            }
            this.nodes.remove(p);
            if (!move) {
                this.remove(n);
            }
            return true;
        }
        return false;
    }

    public synchronized int removeBookmarksByName(String name) {
        int nRemoved = 0;
        if (this.bookmarks != null && !this.bookmarks.isEmpty()) {
            Iterator<BookmarkNode> it = this.bookmarks.iterator();
            while (it.hasNext()) {
                BookmarkNode bookmark = it.next();
                if (bookmark.name.equals(name)) {
                    it.remove();
                    bookmark.parent = null;
                    this.nodes.remove(bookmark.path);
                    this.remove(bookmark);
                    ++nRemoved;
                    continue;
                }
                nRemoved += this.removeBookmarksByNameRec(name, bookmark, it);
            }
            return nRemoved;
        }
        return 0;
    }

    private synchronized int removeBookmarksByNameRec(String name, BookmarkNode bookmark, Iterator<BookmarkNode> itr) {
        int nRemoved = 0;
        if (bookmark.name.equals(name)) {
            itr.remove();
            bookmark.parent = null;
            this.nodes.remove(bookmark.path);
            this.remove(bookmark);
            ++nRemoved;
        } else if (bookmark.children != null) {
            Iterator<BookmarkNode> it = bookmark.children.iterator();
            while (it.hasNext()) {
                BookmarkNode child = it.next();
                nRemoved += this.removeBookmarksByNameRec(name, child, it);
            }
        }
        return nRemoved;
    }

    private String generateId(boolean needsId) {
        return needsId ? UUID.randomUUID().toString() : null;
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case BOOKMARKS_ADD: {
                String text;
                Object d0 = data[0];
                if (d0 instanceof String) {
                    String name = (String)d0;
                    boolean folder = (Boolean)data[1];
                    if (this.addBookmark(name, folder)) {
                        this.persistBookmarks();
                        logger.info(I18n.msg("gui.bookmark.add.ok", name));
                        break;
                    }
                    logger.error(I18n.msg("gui.bookmark.add.error", name));
                    break;
                }
                Vector3Q pos = data[0] != null ? (Vector3Q)d0 : null;
                Vector3D dir = data[1] != null ? (Vector3D)data[1] : null;
                Vector3D up = data[2] != null ? (Vector3D)data[2] : null;
                Instant t = data[3] != null ? (Instant)data[3] : null;
                String focus = data[4] != null ? (String)data[4] : null;
                Settings s = data[5] != null ? (Settings)data[5] : null;
                String name = (String)data[6];
                boolean folder = (Boolean)data[7];
                String id = this.generateId(s != null);
                if (s != null) {
                    Path parent = SysUtils.getDefaultBookmarksDir().resolve("settings");
                    Path settingsFile = parent.resolve(id);
                    try {
                        Files.createDirectories(parent, new FileAttribute[0]);
                        Files.deleteIfExists(settingsFile);
                    }
                    catch (IOException e) {
                        logger.error(I18n.msg("error.directory.create", parent.toAbsolutePath().toString()), e);
                    }
                    SettingsManager.persistSettings(s, settingsFile.toFile());
                }
                if (this.addBookmark(text = String.format("{%s|%s|%s|%s|%s|%s|%s}", this.str(pos), this.str(dir), this.str(up), this.str(t), name, this.str(id), this.str(focus)), folder)) {
                    this.persistBookmarks();
                    logger.info(I18n.msg("gui.bookmark.add.ok", text));
                    break;
                }
                logger.error(I18n.msg("gui.bookmark.add.error", text));
                break;
            }
            case BOOKMARKS_REMOVE: {
                String name = (String)data[0];
                if (!this.removeBookmark(name, false)) break;
                this.persistBookmarks();
                logger.info(I18n.msg("gui.bookmark.remove.ok", name));
                break;
            }
            case BOOKMARKS_REMOVE_ALL: {
                String name = (String)data[0];
                int removed = this.removeBookmarksByName(name);
                if (removed <= 0) break;
                this.persistBookmarks();
                logger.info(I18n.msg("gui.bookmark.remove.name.ok", removed, name));
                break;
            }
            case BOOKMARKS_MOVE: {
                BookmarkNode src = (BookmarkNode)data[0];
                BookmarkNode dest = (BookmarkNode)data[1];
                if (dest == null) {
                    this.removeBookmark(src.path.toString(), true);
                    this.addBookmark(src.text, false);
                    this.persistBookmarks();
                    break;
                }
                if (dest.isTypeFolder()) {
                    this.removeBookmark(src.path.toString(), true);
                    this.addBookmark(dest.path.resolve(src.text).toString(), false);
                    this.persistBookmarks();
                    break;
                }
                logger.error(I18n.msg("error.destination.notdir", dest));
                break;
            }
            case BOOKMARKS_MOVE_UP: {
                BookmarkNode bookmark = (BookmarkNode)data[0];
                List<BookmarkNode> list = bookmark.parent != null ? bookmark.parent.children : this.bookmarks;
                int idx0 = list.indexOf(bookmark);
                if (idx0 <= 0) break;
                list.remove(idx0);
                list.add(idx0 - 1, bookmark);
                this.persistBookmarks();
                break;
            }
            case BOOKMARKS_MOVE_DOWN: {
                BookmarkNode bookmark = (BookmarkNode)data[0];
                List<BookmarkNode> list = bookmark.parent != null ? bookmark.parent.children : this.bookmarks;
                int idx1 = list.indexOf(bookmark);
                if (idx1 >= list.size() - 1) break;
                list.remove(idx1);
                list.add(idx1 + 1, bookmark);
                this.persistBookmarks();
                break;
            }
        }
    }

    private String str(Vector3Q v) {
        return v != null ? "[" + v.x.toString() + "," + v.y.toString() + "," + v.z.toString() + "]" : "null";
    }

    private String str(Vector3D v) {
        return v != null ? "[" + v.x + "," + v.y + "," + v.z + "]" : "null";
    }

    private String str(Instant t) {
        return t != null ? t.toString() : "null";
    }

    private String str(String s) {
        return s != null ? s : "null";
    }

    public static class BookmarkNode {
        public static final String NULL_TOKEN = "null";
        private static final String VEC3_REGEX = "(null|\\[[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?,[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?,[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?])";
        public static final String LOC_BOOKMARK_REGEX = "\\{(null|\\[[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?,[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?,[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?])\\|(null|\\[[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?,[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?,[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?])\\|(null|\\[[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?,[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?,[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?])\\|(?:null|\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?Z)\\|[^|,\\\\]+(\\|(?:null|[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}))?(\\|(?:null|[^|,\\\\]+))?}";
        public String text;
        public String name;
        @Null
        public Vector3D position;
        @Null
        public Vector3D direction;
        @Null
        public Vector3D up;
        @Null
        public Instant time;
        @Null
        public String uuid;
        @Null
        public String focus;
        public Path path;
        public BookmarkNode parent;
        public List<BookmarkNode> children;
        public final BookmarkType type;

        public BookmarkNode(Path path, boolean folder) {
            this.path = path;
            this.text = this.path.getFileName().toString().strip();
            this.type = folder ? BookmarkType.FOLDER : (this.text.matches(LOC_BOOKMARK_REGEX) ? BookmarkType.LOCATION : BookmarkType.OBJECT);
            this.initializeText();
        }

        public void initializeText() {
            if (this.text != null) {
                if (this.isTypeLocation()) {
                    String[] tokens = this.text.substring(1, this.text.length() - 1).split("\\|");
                    String pos = tokens[0];
                    String dir = tokens[1];
                    String up = tokens[2];
                    String instant = tokens[3];
                    String name = tokens[4];
                    String uuid = tokens.length > 5 ? tokens[5] : null;
                    String focus = tokens.length > 6 ? tokens[6] : null;
                    this.name = name;
                    this.uuid = this.fromString(uuid);
                    this.position = this.vectorFromString(pos);
                    this.direction = this.vectorFromString(dir);
                    this.up = this.vectorFromString(up);
                    this.time = this.instantFromString(instant);
                    this.focus = this.fromString(focus);
                } else {
                    this.name = this.text;
                }
            }
        }

        public Settings loadSettingsFromFile() {
            if (this.uuid != null) {
                Path parent = SysUtils.getDefaultBookmarksDir().resolve("settings");
                Path settingsFile = parent.resolve(this.uuid);
                try {
                    Settings settings = SettingsManager.instance.loadSettings(settingsFile.toFile());
                    settings.setParent(settings);
                    settings.runtime = Settings.settings.runtime.clone();
                    settings.runtime.inputEnabled = true;
                    settings.runtime.setParent(settings);
                    return settings;
                }
                catch (IOException e) {
                    logger.error(String.format("Could not load settings file: %s", settingsFile.toAbsolutePath().toString()), e);
                }
            }
            return null;
        }

        private Vector3D vectorFromString(String vectorString) {
            if (vectorString.equals(NULL_TOKEN)) {
                return null;
            }
            String[] tokens = vectorString.substring(1, vectorString.length() - 1).split(",");
            return new Vector3D(Parser.parseDouble(tokens[0]), Parser.parseDouble(tokens[1]), Parser.parseDouble(tokens[2]));
        }

        private Instant instantFromString(String t) {
            return t.equals(NULL_TOKEN) ? null : Instant.parse(t);
        }

        private String fromString(String str) {
            return str == null || str.equals(NULL_TOKEN) ? null : str;
        }

        public void insert(BookmarkNode node) {
            if (node != null) {
                this.initChildren();
                if (!this.children.contains(node)) {
                    this.children.add(node);
                    node.parent = this;
                }
            }
        }

        private void initChildren() {
            if (this.children == null) {
                this.children = new ArrayList<BookmarkNode>(4);
            }
        }

        public int countBookmarksRec() {
            if (this.isTypeFolder()) {
                int num = 0;
                if (this.children != null) {
                    for (BookmarkNode c : this.children) {
                        num += c.countBookmarksRec();
                    }
                }
                return num;
            }
            return 1;
        }

        public String toString() {
            return this.path.toString();
        }

        public BookmarkNode getFirstFolderAncestor() {
            if (this.isTypeFolder()) {
                return this;
            }
            if (this.parent != null) {
                return this.parent.getFirstFolderAncestor();
            }
            return null;
        }

        public boolean isDescendantOf(BookmarkNode other) {
            BookmarkNode current = this;
            while (current != null) {
                if (current == other) {
                    return true;
                }
                current = current.parent;
            }
            return false;
        }

        public boolean isTypeFolder() {
            return this.type != null && this.type.equals((Object)BookmarkType.FOLDER);
        }

        public boolean isTypeObject() {
            return this.type != null && this.type.equals((Object)BookmarkType.OBJECT);
        }

        public boolean isTypeLocation() {
            return this.type != null && this.type.equals((Object)BookmarkType.LOCATION);
        }

        public static enum BookmarkType {
            FOLDER,
            OBJECT,
            LOCATION;

        }
    }
}

