/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.bookmarks;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import gaiasky.gui.window.GenericDialog;
import gaiasky.util.Logger;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.validator.FolderValidator;
import gaiasky.util.validator.StringValidator;

public class NewBookmarkFolderDialog
extends GenericDialog {
    private static final Logger.Log logger = Logger.getLogger(NewBookmarkFolderDialog.class);
    public OwnTextField input;

    public NewBookmarkFolderDialog(String parent, Skin skin, Stage ui) {
        super(I18n.msg("gui.bookmark.context.newfolder", parent), skin, ui);
        this.setAcceptText(I18n.msg("gui.ok"));
        this.setCancelText(I18n.msg("gui.cancel"));
        this.buildSuper();
        this.pack();
    }

    @Override
    public void build() {
        FolderValidator folderValidator = new FolderValidator();
        StringValidator stringValidator = new StringValidator(folderValidator, new Character[]{Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'), Character.valueOf(',')});
        this.input = new OwnTextField("", this.skin, stringValidator);
        this.input.setWidth(480.0f);
        this.input.setMessageText("New folder");
        this.content.add((Actor)this.input).top().left().expand().row();
    }

    @Override
    public boolean accept() {
        this.stage.unfocusAll();
        return true;
    }

    @Override
    public void cancel() {
        this.stage.unfocusAll();
    }

    @Override
    public GenericDialog show(Stage stage, Action action) {
        GenericDialog gd = super.show(stage, action);
        stage.setKeyboardFocus((Actor)this.input);
        return gd;
    }

    @Override
    public void dispose() {
    }
}

